Developers {#developers}
==========

# Overview #

[TOC]

This page documents various internal aspects of how the RMF library works and is built.

# Developer tools # {#dev_tools}

RMF uses the [Salilab developer tools](http://www.github.com/salilab/developer_tools) to provide basic developer tools in a way that is shared with [IMP](http://integrativemodeling.org). This is included as a subrepository. Read the docs of that repository for more information.

# CMake tools # {#cmake_tools}

RMF uses [Salilab cmake modules](http://www.github.com/salilab/cmake_modules) to provide some extensions to [CMake](http://cmake.org). This is included as a subrepository.

# Decorators # {#makedecorators}

Headers containing the simple decorators are generated by a script `tools/build/make_decorators.py`. These decorator headers are put into the build directory. New decorators should either be defined through the script or modeled after the existing ones.

# Avro # {#avrocpp}

RMF uses a [fork of AvroCpp](https://github.com/salilab/avrocpp) to encode data. See that repository for more information. The fork is mostly necessary in order to add seek support to the DataFileReader and to support writing to memory buffers with the DataFileWriter. The other big patch has made it into Avro 1.7.6.

# SharedData # {#shareddata}

RMF::NodeConstHandle and RMF::FileConstHandle work by maintaining a reference counted pointer to an RMF::internal::SharedData that contains the data for the open file. The SharedData object contains in memory a copy of the data from the current frame as well as various other file data (node hierarchy, frame hierarchy etc). Note, since it is ref counted, the file is kept open as long as there are any handles in existence.

# Documentation # {#documentation}

RMF uses doxygen to build its documentation.
