// Autogenerated by ../../../../tmp/imp-20181023-81973-auecv7/imp-2.9.0/tools/build/make_containers.py
// from ../../../../tmp/imp-20181023-81973-auecv7/imp-2.9.0/tools/build/container_templates/container/ListClassnameContainer.h
// Do not edit - any changes will be lost!

/**
 *  \file IMP/container/ListPairContainer.h
 *  \brief Store a list of ParticleIndexPairs.
 *
 *  Copyright 2007-2018 IMP Inventors. All rights reserved.
 */

#ifndef IMPCONTAINER_LIST_PAIR_CONTAINER_H
#define IMPCONTAINER_LIST_PAIR_CONTAINER_H

#include <IMP/container/container_config.h>
#include <IMP/object_macros.h>
#include <IMP/internal/StaticListContainer.h>
#include <IMP/PairContainer.h>
#include <IMP/PairModifier.h>
#include <IMP/base_types.h>

IMPCONTAINER_BEGIN_NAMESPACE

//! Store a list of ParticleIndexPairs
/** \note The order may change when particles are inserted
    as the list is maintained in sorted order.

    \note Changing the contents of the container is a fairly heavy
    weight operation as it resets part of the dependency graph. Use
    a DynamicListPairContainer if you want to change the contents
    frequently (eg via a ScoreState).
 */
class IMPCONTAINEREXPORT ListPairContainer :
#if defined(IMP_DOXYGEN) || defined(SWIG)
    public PairContainer
#else
    public IMP::internal::StaticListContainer<PairContainer>
#endif
    {
  typedef IMP::internal::StaticListContainer<PairContainer> P;

 public:
  ListPairContainer(Model *m, const ParticleIndexPairs &contents,
                         std::string name = "ListPairContainer%1%");

#ifndef IMP_DOXYGEN
  ListPairContainer(Model *m,
                         std::string name = "ListPairContainer %1%");
  ListPairContainer(Model *m, const char *name);

#endif
#if defined(SWIG) || defined(IMP_DOXYGEN)
  //! Add a single const ParticleIndexPair& to the container.
  void add(const ParticleIndexPair& vt);

  //! Add ParticleIndexPairs to the container.
  void add(const ParticleIndexPairs &c);

  //! Set the contents of the container to the given ParticleIndexPairs.
  void set(ParticleIndexPairs cp);

  //! Clear the contents of the container.
  void clear();
#endif

#ifdef SWIG
  ParticleIndexPairs get_indexes() const;
  ParticleIndexPairs get_range_indexes() const;
  ModelObjectsTemp do_get_inputs() const;
  void do_apply(const PairModifier *sm) const;
  ParticleIndexes get_all_possible_indexes() const;

 private:
  std::size_t do_get_contents_hash() const;
#endif
  IMP_OBJECT_METHODS(ListPairContainer);
};

IMP_OBJECTS(ListPairContainer, ListPairContainers);

IMPCONTAINER_END_NAMESPACE

#endif /* IMPCONTAINER_LIST_PAIR_CONTAINER_H */
