// Autogenerated by ../../../../tmp/imp-20180912-85017-hf2bvh/imp-2.9.0/tools/build/make_containers.py
// from ../../../../tmp/imp-20180912-85017-hf2bvh/imp-2.9.0/tools/build/container_templates/container/ClassnamesRestraint.h
// Do not edit - any changes will be lost!

/**
 *  \file IMP/container/TripletsRestraint.h
 *  \brief Apply a TripletScore to each Triplet in a list.
 *
 *  Copyright 2007-2018 IMP Inventors. All rights reserved.
 *
 */

#ifndef IMPCONTAINER_TRIPLETS_RESTRAINT_H
#define IMPCONTAINER_TRIPLETS_RESTRAINT_H

#include <IMP/container/container_config.h>
#include <IMP/internal/ContainerRestraint.h>
#include <IMP/TripletContainer.h>
#include <IMP/TripletScore.h>

IMPCONTAINER_BEGIN_NAMESPACE

//! Applies a TripletScore to each Triplet in a list.
/** This restraint stores the used particle indexes in a ParticleIndexTriplets.
    The container used can be set so that the list can be shared
    with other containers (or a nonbonded list can be used).

    Examples using various multiplicity containers:
    \include restrain_in_sphere.py
    \include nonbonded_interactions.py

    \see IMP::core::TripletRestraint
 */
class TripletsRestraint :
#if defined(SWIG) || defined(IMP_DOXYGEN)
    public Restraint
#else
    public IMP::internal::ContainerRestraint<TripletScore, TripletContainer>
#endif
    {
  typedef IMP::internal::ContainerRestraint<
      TripletScore, TripletContainer> P;

 public:
  //! Create the restraint with a shared container
  /** \param[in] ss The function to apply to each particle.
      \param[in] pc The container containing the stored particles. This
      container is not copied.
      \param[in] name The object name
   */
  TripletsRestraint(TripletScore *ss, TripletContainerAdaptor pc,
                      std::string name = "TripletsRestraint %1%")
      : P(ss, pc, name) {}

#if defined(IMP_DOXYGEN) || defined(SWIG)
  double unprotected_evaluate(IMP::DerivativeAccumulator *accum) const;
  IMP::ModelObjectsTemp do_get_inputs() const;
  IMP_OBJECT_METHODS(TripletsRestraint)
#endif
};

IMP_OBJECTS(TripletsRestraint, TripletsRestraints);

IMPCONTAINER_END_NAMESPACE

#endif /* IMPCONTAINER_TRIPLETS_RESTRAINT_H */
