// Autogenerated by ../../../../tmp/imp-20180702-10733-wiic2r/imp-2.9.0/tools/build/make_containers.py
// from ../../../../tmp/imp-20180702-10733-wiic2r/imp-2.9.0/tools/build/container_templates/container/ClassnameContainerSet.h
// Do not edit - any changes will be lost!

/**
 *  \file IMP/container/PairContainerSet.h
 *  \brief Store a set of PairContainers
 *
 *  Copyright 2007-2018 IMP Inventors. All rights reserved.
 */

#ifndef IMPCONTAINER_PAIR_CONTAINER_SET_H
#define IMPCONTAINER_PAIR_CONTAINER_SET_H

#include <IMP/container/container_config.h>
#include <IMP/PairContainer.h>
#include <IMP/container_macros.h>
#include <IMP/internal/container_helpers.h>
#include <IMP/scoped.h>

IMPCONTAINER_BEGIN_NAMESPACE

//! Stores a set of PairContainers
/** The input sets must be disjoint. This can change if there is
    demand for it.

    \usesconstraint
*/
class IMPCONTAINEREXPORT PairContainerSet : public PairContainer {
  Ints versions_;
  static PairContainerSet *get_set(PairContainer *c) {
    return dynamic_cast<PairContainerSet *>(c);
  }
  virtual std::size_t do_get_contents_hash() const IMP_OVERRIDE;

 public:
  //! Construct and empty set
  PairContainerSet(Model *m,
                        std::string name = "PairContainerSet %1%");

  PairContainerSet(const PairContainersTemp &pc,
                        std::string name = "PairContainerSet %1%");

  /** \brief apply modifier sm to all pair containers */
  IMP_IMPLEMENT(void do_apply(const PairModifier *sm) const);

  template <class M>
  void apply_generic(const M *m) const {
    apply(m);
  }

  ParticleIndexes get_all_possible_indexes() const;
  IMP_OBJECT_METHODS(PairContainerSet);

  /** @name Methods to control the nested container

      This container merges a set of nested containers. To add
      or remove nested containers, use the methods below.
  */
  /**@{*/
  IMP_LIST_ACTION(public, PairContainer, PairContainers,
                  pair_container, pair_containers,
                  PairContainer *, PairContainers,
  {
    obj->set_was_used(true);
    versions_.clear();
  },
                  {}, );
/**@}*/

#ifndef IMP_DOXYGEN
  ParticleIndexPairs get_indexes() const;
  ParticleIndexPairs get_range_indexes() const;
  ModelObjectsTemp do_get_inputs() const;
#endif

 protected:
  //! Insert the contents of the container into output
  //! instead of output's current content
  virtual void get_indexes_in_place(ParticleIndexPairs& output)
    const IMP_OVERRIDE;
};

IMPCONTAINER_END_NAMESPACE

#endif /* IMPCONTAINER_PAIR_CONTAINER_SET_H */
