// Autogenerated by ../../../../tmp/imp-20171226-86380-7okh6w/imp-2.8.0/tools/build/make_containers.py
// from ../../../../tmp/imp-20171226-86380-7okh6w/imp-2.8.0/tools/build/container_templates/container/DistributeClassnamesScoreState.h
// Do not edit - any changes will be lost!

/**
 *  \file IMP/container/DistributeTripletsScoreState.h
 *  \brief Apply a TripletScore to each Triplet in a list.
 *
 *  Copyright 2007-2017 IMP Inventors. All rights reserved.
 *
 */

#ifndef IMPCONTAINER_DISTRIBUTE_TRIPLETS_SCORE_STATE_H
#define IMPCONTAINER_DISTRIBUTE_TRIPLETS_SCORE_STATE_H

#include <IMP/container/container_config.h>

#include "DynamicListTripletContainer.h"
#include <IMP/TripletPredicate.h>
#include <IMP/TripletContainer.h>
#include <IMP/Vector.h>
#include <IMP/triplet_macros.h>
#include <boost/tuple/tuple.hpp>

#include <iostream>

IMPCONTAINER_BEGIN_NAMESPACE

//! Distribute contents of one container into several based on predicates
/** This ScoreState takes a list of predicates and values. For
    each tuple in the input container, it is placed in a given output container
    if the predicate, when applied, has the passed value.

    \note The output containers contents are not necessarily disjoint.
*/
class IMPCONTAINEREXPORT DistributeTripletsScoreState : public ScoreState {
  PointerMember<TripletContainer> input_;
  typedef boost::tuple<Pointer<DynamicListTripletContainer>,
                       PointerMember<TripletPredicate>, int> Data;
  Vector<Data> data_;
  mutable std::size_t input_version_;
  void update_lists_if_necessary() const;

 public:
  DistributeTripletsScoreState(TripletContainerAdaptor input,
                                 std::string name =
                                     "DistributeTripletsScoreState %1%");

  /** A given tuple will go into the returned container if \c predicate
      returns \c value when applied to it.*/
  DynamicListTripletContainer *add_predicate(TripletPredicate *predicate,
                                               int value) {
    IMP_NEW(DynamicListTripletContainer, c,
            (input_, predicate->get_name() + " output"));
    data_.push_back(Data(c, predicate, value));
    return c;
  }
  virtual void do_before_evaluate() IMP_OVERRIDE;
  virtual void do_after_evaluate(DerivativeAccumulator *da) IMP_OVERRIDE;
  virtual ModelObjectsTemp do_get_inputs() const IMP_OVERRIDE;
  virtual ModelObjectsTemp do_get_outputs() const IMP_OVERRIDE;
  IMP_OBJECT_METHODS(DistributeTripletsScoreState);
};

IMPCONTAINER_END_NAMESPACE

#endif /* IMPCONTAINER_DISTRIBUTE_TRIPLETS_SCORE_STATE_H */
