/**
 *  \file IMP/algebra.h
 *  \brief Include all non-deprecated headers in IMP.algebra.
 *
 *  Copyright 2007-2017 IMP Inventors. All rights reserved.
 */

#ifndef IMP_ALGEBRA_H
#define IMP_ALGEBRA_H
#include <IMP/algebra/BoundingBoxD.h>
#include <IMP/algebra/Cone3D.h>
#include <IMP/algebra/Cylinder3D.h>
#include <IMP/algebra/Ellipsoid3D.h>
#include <IMP/algebra/Gaussian3D.h>
#include <IMP/algebra/GeometricPrimitiveD.h>
#include <IMP/algebra/GridD.h>
#include <IMP/algebra/Line3D.h>
#include <IMP/algebra/LinearFit.h>
#include <IMP/algebra/ParabolicFit.h>
#include <IMP/algebra/Plane3D.h>
#include <IMP/algebra/ReferenceFrame3D.h>
#include <IMP/algebra/Reflection3D.h>
#include <IMP/algebra/Rotation2D.h>
#include <IMP/algebra/Rotation3D.h>
#include <IMP/algebra/Segment3D.h>
#include <IMP/algebra/Sphere3D.h>
#include <IMP/algebra/SphereD.h>
#include <IMP/algebra/SpherePatch3D.h>
#include <IMP/algebra/SphericalVector3D.h>
#include <IMP/algebra/Torus3D.h>
#include <IMP/algebra/Transformation2D.h>
#include <IMP/algebra/Transformation3D.h>
#include <IMP/algebra/Triangle3D.h>
#include <IMP/algebra/Vector2D.h>
#include <IMP/algebra/Vector3D.h>
#include <IMP/algebra/VectorBaseD.h>
#include <IMP/algebra/VectorD.h>
#include <IMP/algebra/algebra_macros.h>
#include <IMP/algebra/connolly_surface.h>
#include <IMP/algebra/constants.h>
#include <IMP/algebra/distance.h>
#include <IMP/algebra/eigen_analysis.h>
#include <IMP/algebra/endian.h>
#include <IMP/algebra/geometric_alignment.h>
#include <IMP/algebra/geometric_primitive_macros.h>
#include <IMP/algebra/grid_embeddings.h>
#include <IMP/algebra/grid_indexes.h>
#include <IMP/algebra/grid_ranges.h>
#include <IMP/algebra/grid_storages.h>
#include <IMP/algebra/grid_utility.h>
#include <IMP/algebra/io.h>
#include <IMP/algebra/python_only.h>
#include <IMP/algebra/shortest_segment.h>
#include <IMP/algebra/standard_grids.h>
#include <IMP/algebra/utility.h>
#include <IMP/algebra/vector_generators.h>
#include <IMP/algebra/vector_metrics.h>
#include <IMP/algebra/vector_search.h>
#endif /* IMP_ALGEBRA_H */
