// Autogenerated by ../../../../tmp/imp-20171220-7688-apo6cr/imp-2.8.0/tools/build/make_containers.py
// from ../../../../tmp/imp-20171220-7688-apo6cr/imp-2.8.0/tools/build/container_templates/container/ClassnamesRestraint.h
// Do not edit - any changes will be lost!

/**
 *  \file IMP/container/PairsRestraint.h
 *  \brief Apply a PairScore to each Pair in a list.
 *
 *  Copyright 2007-2017 IMP Inventors. All rights reserved.
 *
 */

#ifndef IMPCONTAINER_PAIRS_RESTRAINT_H
#define IMPCONTAINER_PAIRS_RESTRAINT_H

#include <IMP/container/container_config.h>
#include <IMP/internal/ContainerRestraint.h>
#include <IMP/PairContainer.h>
#include <IMP/PairScore.h>

IMPCONTAINER_BEGIN_NAMESPACE

//! Applies a PairScore to each Pair in a list.
/** This restraint stores the used particle indexes in a ParticleIndexPairs.
    The container used can be set so that the list can be shared
    with other containers (or a nonbonded list can be used).

    Examples using various multiplicity containers:
    \include restrain_in_sphere.py
    \include nonbonded_interactions.py

    \see IMP::core::PairRestraint
 */
class PairsRestraint :
#if defined(SWIG) || defined(IMP_DOXYGEN)
    public Restraint
#else
    public IMP::internal::ContainerRestraint<PairScore, PairContainer>
#endif
    {
  typedef IMP::internal::ContainerRestraint<
      PairScore, PairContainer> P;

 public:
  //! Create the restraint with a shared container
  /** \param[in] ss The function to apply to each particle.
      \param[in] pc The container containing the stored particles. This
      container is not copied.
      \param[in] name The object name
   */
  PairsRestraint(PairScore *ss, PairContainerAdaptor pc,
                      std::string name = "PairsRestraint %1%")
      : P(ss, pc, name) {}

#if defined(IMP_DOXYGEN) || defined(SWIG)
  double unprotected_evaluate(IMP::DerivativeAccumulator *accum) const;
  IMP::ModelObjectsTemp do_get_inputs() const;
  IMP_OBJECT_METHODS(PairsRestraint)
#endif
};

IMP_OBJECTS(PairsRestraint, PairsRestraints);

IMPCONTAINER_END_NAMESPACE

#endif /* IMPCONTAINER_PAIRS_RESTRAINT_H */
