// Autogenerated by ../../../../tmp/imp-20171026-27405-syk5qd/imp-2.8.0/tools/build/setup_module.py
// from ../../../../tmp/imp-20171026-27405-syk5qd/imp-2.8.0/tools/build/config_templates/header.h
// Do not edit - any changes will be lost!

/*
 * \file IMP/kernel_config.h
 * \brief Provide macros to mark functions and classes as exported
 *        from a DLL/.so, and to set up namespaces
 *
 * When building the module, IMPKERNEL_EXPORTS should be defined, and when
 * using the module externally, it should not be. Classes and functions
 * declared in the module's headers should then be marked with
 * IMPKERNELEXPORT if they are intended to be part of the API and
 * they are not defined entirely in a header.
 *
 * The Windows build environment requires applications to mark exports in
 * this way; we use the same markings to set the visibility of ELF symbols
 * if we have compiler support.
 *
 * All code in this module should live in the IMP namespace.
 * This is simply achieved by wrapping things with the
 * IMPKERNEL_BEGIN_NAMESPACE and IMPKERNEL_END_NAMESPACE macros.
 * There are similar macros for module code that is designed to be for
 * internal use only.
 *
 * Copyright 2007-2017 IMP Inventors. All rights reserved.
 *
 */

#ifndef IMPKERNEL_CONFIG_H
#define IMPKERNEL_CONFIG_H

#include <IMP/kernel_config.h>
#include <string>

#ifdef _MSC_VER
#define NOMINMAX

#ifdef IMPKERNEL_EXPORTS
#define IMPKERNELEXPORT __declspec(dllexport)
#else  // EXPORTS
#define IMPKERNELEXPORT __declspec(dllimport)
#endif  // EXPORTS

#else  // _MSC_VER

#ifdef GCC_VISIBILITY
#define IMPKERNELEXPORT __attribute__((visibility("default")))
#else  // GCC_VISIBILITY
#define IMPKERNELEXPORT
#endif  // GCC_VISIBILITY

#endif  // _MSC_VER

#if defined(_MSC_VER) && !defined(SWIG)
#ifdef IMPKERNEL_EXPORTS

#define IMPKERNEL_EXPORT_TEMPLATE(name)     \
  template class __declspec(dllexport) name

#else  //EXPORTS

#define IMPKERNEL_EXPORT_TEMPLATE(name)     \
  template class __declspec(dllimport) name

#endif  // EXPORTS

#else  // MSC and SWIG
#define IMPKERNEL_EXPORT_TEMPLATE(name) IMP_REQUIRE_SEMICOLON_NAMESPACE

#endif  // MSC and SWIG

#if !defined(SWIG) && !defined(IMP_DOXYGEN)

#define IMPKERNEL_BEGIN_NAMESPACE \
  IMP_COMPILER_ENABLE_WARNINGS namespace IMP{

#define IMPKERNEL_END_NAMESPACE } \
IMP_COMPILER_DISABLE_WARNINGS

#define IMPKERNEL_BEGIN_INTERNAL_NAMESPACE IMPKERNEL_BEGIN_NAMESPACE \
  namespace internal {

#define IMPKERNEL_END_INTERNAL_NAMESPACE } IMPKERNEL_END_NAMESPACE

#else  // SWIG and DOXYGEN
#define IMPKERNEL_BEGIN_NAMESPACE namespace IMP{

#define IMPKERNEL_END_NAMESPACE }

#define IMPKERNEL_BEGIN_INTERNAL_NAMESPACE IMPKERNEL_BEGIN_NAMESPACE\
  namespace internal {

#define IMPKERNEL_END_INTERNAL_NAMESPACE } IMPKERNEL_END_NAMESPACE

#endif  // SWIG AND DOXYGEN

#define IMP_BUILD IMP_RELEASE
#define IMP_HAS_LOG IMP_VERBOSE
#define IMP_HAS_CHECKS IMP_USAGE
#define IMP_DEBUG 0
#define IMP_RELEASE 1
#define IMP_SILENT 0
#define IMP_PROGRESS 2
#define IMP_TERSE 3
#define IMP_VERBOSE 4
#define IMP_MEMORY 5
#define IMP_NONE 0
#define IMP_USAGE 1
#define IMP_INTERNAL 2
#define IMP_KERNEL_HAS_LOG4CXX 0
#define IMP_COMPILER_HAS_AUTO 1
#define IMP_COMPILER_HAS_DEBUG_VECTOR 0
#define IMP_COMPILER_HAS_UNIQUE_PTR 1
#define IMP_KERNEL_USE_BOOST_RANDOM
#define IMP_KERNEL_HAS_BOOST_RANDOM 1
#define IMP_KERNEL_NO_GPERFTOOLS
#define IMP_KERNEL_HAS_GPERFTOOLS 0
#define IMP_KERNEL_NO_TCMALLOC_HEAPCHECKER
#define IMP_KERNEL_HAS_TCMALLOC_HEAPCHECKER 0
#define IMP_KERNEL_NO_TCMALLOC_HEAPPROFILER
#define IMP_KERNEL_HAS_TCMALLOC_HEAPPROFILER 0

// functions are defined explicitly for SWIG
namespace IMP{
/** \name Standard module functions
  All \imp modules have a set of standard functions to help get information
  about the module and about files associated with the module.
  @{
  */
#if !defined(SWIG)
    IMPKERNELEXPORT std::string get_module_version();
#endif

#if !defined(SWIG)
    // SWIG will whine about duplicate definitions of function
    inline std::string get_module_name() { return "IMP"; }
#endif

    //! Return the full path to one of this module's data files
    /** To read the data file "data_library" that was placed in the \c data
        directory of this module, do something like
        \code
        std::ifstream in(IMP::get_data_path("data_library"));
        \endcode
        This will ensure that the code works both when %IMP is installed or
        if used via the \c setup_environment.sh script.

        \note Each module has its own data directory, so be sure to use
              this function from the correct module.
    */
#if !defined(SWIG)
    IMPKERNELEXPORT std::string get_data_path(std::string file_name);
#endif

    //! Return the full path to one of this module's example files
    /** To read the example file "example_protein.pdb" that was placed
        in the \c examples directory of this module, do something like
        \code
        std::ifstream in(IMP::get_example_path("example_protein.pdb"));
        \endcode
        This will ensure that the code works both when %IMP is installed or
        if used via the \c setup_environment.sh script.

        \note Each module has its own example directory, so be sure to use
              this function from the correct module.
    */
#if !defined(SWIG)
    IMPKERNELEXPORT std::string get_example_path(std::string file_name);
#endif
    /** @} */


}  //namespace



#include <IMP/compiler_macros.h>

#endif /* IMPKERNEL_CONFIG_H */

// Here so it is always parsed

#ifdef IMPKERNEL_DEPRECATED_HEADER
#undef IMPKERNEL_DEPRECATED_HEADER
#undef IMPKERNEL_DEPRECATED_VALUE_DEF
#undef IMPKERNEL_DEPRECATED_VALUE_DECL
#undef IMPKERNEL_DEPRECATED_OBJECT_DEF
#undef IMPKERNEL_DEPRECATED_OBJECT_DECL
#undef IMPKERNEL_DEPRECATED_FUNCTION_DEF
#undef IMPKERNEL_DEPRECATED_FUNCTION_DECL
#undef IMPKERNEL_DEPRECATED_METHOD_DEF
#undef IMPKERNEL_DEPRECATED_METHOD_DECL
#undef IMPKERNEL_DEPRECATED_MACRO
#undef IMPKERNEL_SHOW_WARNINGS
#endif

// the central modules we can update easily, so don't warn in them
#if defined( IMPKERNEL_COMPILATION)                                 \
  || defined(SWIG) || defined(IMP_SWIG_WRAPPER)                         \
  || defined( IMPKERNEL_ALL) || defined(IMP_DOXYGEN)                \
  || defined(IMPBASE_COMPILATION) || defined(IMPKERNEL_COMPILATION)     \
  || defined(IMPCORE_COMPILATION) || defined(IMPATOM_COMPILATION)       \
  || defined(IMPSTATISTICS_COMPILATION) || defined(IMPDOMINO_COMPILATION) \
  || defined(IMPCONTAINER_COMPILATION) || defined(IMPDISPLAY_COMPILATION) \
  || defined(IMPSCOREFUNCTOR_COMPILATION) || defined(IMPRMF_COMPILATION) \
  || defined(IMPGSL_COMPILATION)
#define IMPKERNEL_SHOW_WARNINGS 0
#else
#define IMPKERNEL_SHOW_WARNINGS 1
#endif

// suppress header warnings with all header, SWIG wrapper and in the module
#if IMPKERNEL_SHOW_WARNINGS
#define IMPKERNEL_DEPRECATED_HEADER(version, help_message)          \
    IMP_PRAGMA(message(__FILE__ " is deprecated: " help_message))
#define IMPKERNEL_DEPRECATED_VALUE_DECL(version)    \
  IMP_DEPRECATED_ATTRIBUTE
#define IMPKERNEL_DEPRECATED_OBJECT_DECL(version)    \
  IMP_DEPRECATED_ATTRIBUTE
#define IMPKERNEL_DEPRECATED_FUNCTION_DECL(version) \
  IMP_DEPRECATED_ATTRIBUTE
#define IMPKERNEL_DEPRECATED_METHOD_DECL(version) \
  IMP_DEPRECATED_ATTRIBUTE

#else //IMPKERNEL_SHOW_WARNINGS
/** See [deprecation support](@ref deprecation). */
#define IMPKERNEL_DEPRECATED_HEADER(version, help_message) \
/** See [deprecation support](@ref deprecation). */
#define IMPKERNEL_DEPRECATED_VALUE_DECL(version)
/** See [deprecation support](@ref deprecation). */
#define IMPKERNEL_DEPRECATED_OBJECT_DECL(version)
/** See [deprecation support](@ref deprecation). */
#define IMPKERNEL_DEPRECATED_FUNCTION_DECL(version)
/** See [deprecation support](@ref deprecation). */
#define IMPKERNEL_DEPRECATED_METHOD_DECL(version)

#endif // IMPKERNEL_SHOW_WARNINGS

// only warn about it in the all inclusion to cut down on copies
#if !defined(IMP_ALL) || defined(SWIG) || defined(IMP_DOXYGEN)          \
  || defined(IMPBASE_COMPILATION) || defined(IMPKERNEL_COMPILATION)     \
  || defined(IMPCORE_COMPILATION) || defined(IMPATOM_COMPILATION)       \
  || defined(IMPSTATISTICS_COMPILATION) || defined(IMPDOMINO_COMPILATION) \
  || defined(IMPCONTAINER_COMPILATION) || defined(IMPDISPLAY_COMPILATION) \
  || defined(IMPSCOREFUNCTOR_COMPILATION)
/** See [deprecation support](@ref deprecation). */
#define IMPKERNEL_DEPRECATED_MACRO(version, message)

#else
#define IMPKERNEL_DEPRECATED_MACRO(version, message)        \
  IMP_DEPRECATED_MACRO(version, message)
#endif

/** See [deprecation support](@ref deprecation). */
#define IMPKERNEL_DEPRECATED_VALUE_DEF(version, message) \
  IMP_DEPRECATED_VALUE_RUNTIME_WARNING(version, message)

/** See [deprecation support](@ref deprecation). */
#define IMPKERNEL_DEPRECATED_OBJECT_DEF(version, message) \
  IMP_DEPRECATED_OBJECT_RUNTIME_WARNING(version, message)

/** See [deprecation support](@ref deprecation). */
#define IMPKERNEL_DEPRECATED_FUNCTION_DEF(version, message) \
  IMP_DEPRECATED_FUNCTION_RUNTIME_WARNING(version, message)

/** See [deprecation support](@ref deprecation). */
#define IMPKERNEL_DEPRECATED_METHOD_DEF(version, message) \
  IMP_DEPRECATED_METHOD_RUNTIME_WARNING(version, message)


#include <IMP/compiler_macros.h>

#if defined(IMP_EXECUTABLE) && !defined(IMP_EXECUTABLE_WARNINGS)
IMP_COMPILER_ENABLE_WARNINGS
#define IMP_EXECUTABLE_WARNINGS
#endif
