namespace IMP {
namespace atom {
%warnfilter(403) ForceFieldParameters;
}
}





IMP_SWIG_GRAPH(IMP::atom, HierarchyTree, HierarchyTree, IMP::atom::Hierarchy);
IMP_SWIG_BASE_OBJECT(IMP::atom, PDBSelector, PDBSelectors);
IMP_SWIG_DECORATOR(IMP::atom, Angle, Angles);
IMP_SWIG_DECORATOR(IMP::atom, Atom, Atoms);
IMP_SWIG_DECORATOR(IMP::atom, Bond, Bonds);
IMP_SWIG_DECORATOR(IMP::atom, Bonded, Bondeds);
IMP_SWIG_DECORATOR(IMP::atom, CHARMMAtom, CHARMMAtomList);
IMP_SWIG_DECORATOR(IMP::atom, Chain, Chains);
IMP_SWIG_DECORATOR(IMP::atom, CenterOfMass, CenterOfMasses);
IMP_SWIG_DECORATOR(IMP::atom, Charged, Chargeds);
IMP_SWIG_DECORATOR(IMP::atom, Diffusion, Diffusions);
IMP_SWIG_DECORATOR(IMP::atom, RigidBodyDiffusion, RigidBodyDiffusions);
IMP_SWIG_DECORATOR(IMP::atom, TAMDParticle, TAMDParticles);
IMP_SWIG_DECORATOR(IMP::atom, TAMDCentroid, TAMDCentroids);
IMP_SWIG_DECORATOR(IMP::atom, Dihedral, Dihedrals);
IMP_SWIG_DECORATOR(IMP::atom, Domain, Domains);
IMP_SWIG_DECORATOR(IMP::atom, Fragment, Fragments);
IMP_SWIG_DECORATOR(IMP::atom, Hierarchy, Hierarchies);
IMP_SWIG_DECORATOR(IMP::atom, LennardJones, LennardJonesList);
IMP_SWIG_DECORATOR(IMP::atom, Mass, Masses);
IMP_SWIG_DECORATOR(IMP::atom, LinearVelocity, LinearVelocities);
IMP_SWIG_DECORATOR(IMP::atom, AngularVelocity, AngularVelocities);
IMP_SWIG_DECORATOR(IMP::atom, Molecule, Molecules);
IMP_SWIG_DECORATOR(IMP::atom, Residue, Residues);
IMP_SWIG_DECORATOR(IMP::atom, Representation, Representations);
IMP_SWIG_DECORATOR(IMP::atom, State, States);
IMP_SWIG_DECORATOR(IMP::atom, Copy, Copies);
IMP_SWIG_DECORATOR(IMP::atom, SecondaryStructureResidue, SecondaryStructureResidues);
IMP_SWIG_DECORATOR(IMP::atom, StructureSource, StructureSources);
IMP_SWIG_BASE_OBJECT(IMP::atom, Simulator, Simulators);
IMP_SWIG_DIRECTOR(IMP::atom, PDBSelector);
IMP_SWIG_OBJECT(IMP::atom, ATOMPDBSelector, ATOMPDBSelectors);
IMP_SWIG_OBJECT(IMP::atom, AllMol2Selector,AllMol2Selectors);
IMP_SWIG_OBJECT(IMP::atom, AllPDBSelector, AllPDBSelectors);
IMP_SWIG_OBJECT(IMP::atom, AndPDBSelector,AndPDBSelectors);
IMP_SWIG_OBJECT(IMP::atom, XorPDBSelector,XorPDBSelectors);
IMP_SWIG_OBJECT(IMP::atom, ResidueTypePDBSelector, ResidueTypePDBSelectors);
IMP_SWIG_OBJECT(IMP::atom, AtomTypePDBSelector, AtomTypePDBSelectors);
IMP_SWIG_OBJECT(IMP::atom, AngleSingletonScore, AngleSingletonScores);
IMP_SWIG_OBJECT(IMP::atom, BondEndpointsRefiner, BondEndpointsRefiners);
IMP_SWIG_OBJECT(IMP::atom, BondPairContainer, BondPairContainers);
IMP_SWIG_OBJECT(IMP::atom, BondSingletonScore, BondSingletonScores);
IMP_SWIG_OBJECT(IMP::atom, BondedPairFilter, BondedPairFilters);
IMP_SWIG_OBJECT(IMP::atom, BrownianDynamics, BrownianDynamicsList);
IMP_SWIG_OBJECT(IMP::atom, BrownianDynamicsTAMD, BrownianDynamicsTAMDList);
IMP_SWIG_OBJECT(IMP::atom, CAlphaPDBSelector, CAlphaPDBSelectors);
IMP_SWIG_OBJECT(IMP::atom, CBetaPDBSelector, CBetaPDBSelectors);
IMP_SWIG_OBJECT(IMP::atom, BackbonePDBSelector, BackbonePDBSelectors);
IMP_SWIG_OBJECT(IMP::atom, CHARMMParameters, CHARMMParametersList);
IMP_SWIG_OBJECT(IMP::atom, CHARMMResidueTopology, CHARMMResidueTopologies);
IMP_SWIG_OBJECT(IMP::atom, CHARMMSegmentTopology, CHARMMSegmentTopologies);
IMP_SWIG_OBJECT(IMP::atom, CHARMMStereochemistryRestraint, CHARMMStereochemistryRestraints);
IMP_SWIG_OBJECT(IMP::atom, CHARMMTopology, CHARMMTopologies);
IMP_SWIG_OBJECT(IMP::atom, CPDBSelector, CPDBSelectors);
IMP_SWIG_OBJECT(IMP::atom, ChainPDBSelector, ChainPDBSelectors);
IMP_SWIG_OBJECT(IMP::atom, CoulombPairScore, CoulombPairScores);
IMP_SWIG_OBJECT(IMP::atom, CoverBond, CoverBonds);
IMP_SWIG_OBJECT(IMP::atom, DihedralSingletonScore, DihedralSingletonScores);
IMP_SWIG_OBJECT(IMP::atom, DopePairScore, DopePairScores);
IMP_SWIG_OBJECT(IMP::atom, OrientedSoapPairScore, OrientedSoapPairScores);
IMP_SWIG_OBJECT(IMP::atom, EzRestraint, EzRestraints);
IMP_SWIG_OBJECT(IMP::atom, ForceFieldParameters, ForceFieldParametersList);
IMP_SWIG_OBJECT(IMP::atom, ForceSwitch, ForceSwitches);
IMP_SWIG_OBJECT(IMP::atom, HydrogenPDBSelector,HydrogenPDBSelectors);
IMP_SWIG_OBJECT(IMP::atom, ImproperSingletonScore, ImproperSingletonScores);
IMP_SWIG_OBJECT(IMP::atom, LennardJonesPairScore, LennardJonesPairScores);
IMP_SWIG_OBJECT(IMP::atom, Mol2Selector, Mol2Selectors);
IMP_SWIG_OBJECT(IMP::atom, MolecularDynamics, MolecularDynamicsList);
IMP_SWIG_OBJECT(IMP::atom, NPDBSelector, NPDBSelectors);
IMP_SWIG_OBJECT(IMP::atom, NonAlternativePDBSelector, NonAlternativePDBSelectors);
IMP_SWIG_OBJECT(IMP::atom, NonHydrogenMol2Selector, NonHydrogenMol2Selectors);
IMP_SWIG_OBJECT(IMP::atom, NonHydrogenPDBSelector, NonHydrogenPDBSelectors);
IMP_SWIG_OBJECT(IMP::atom, NonWaterNonHydrogenPDBSelector, NonWaterNonHydrogenPDBSelectors);
IMP_SWIG_OBJECT(IMP::atom, NonWaterPDBSelector,NonWaterPDBSelectors);
IMP_SWIG_OBJECT(IMP::atom, NotPDBSelector,NotPDBSelectors);
IMP_SWIG_OBJECT(IMP::atom, OrPDBSelector,OrPDBSelectors);
IMP_SWIG_OBJECT(IMP::atom, PPDBSelector, PPDBSelectors);
IMP_SWIG_OBJECT(IMP::atom, ProteinLigandAtomPairScore, ProteinLigandAtomPairScores);
IMP_SWIG_OBJECT(IMP::atom, ProteinLigandRestraint, ProteinLigandRestraints);
IMP_SWIG_OBJECT(IMP::atom, SameResiduePairFilter, SameResiduePairFilters);
IMP_SWIG_OBJECT(IMP::atom, SoapPairFilter, SoapPairFilters);
IMP_SWIG_OBJECT(IMP::atom, SmoothingFunction, SmoothingFunctions);
IMP_SWIG_OBJECT(IMP::atom, StereochemistryPairFilter, StereochemistryPairFilters);
IMP_SWIG_OBJECT(IMP::atom, VelocityScalingOptimizerState, VelocityScalingOptimizerStates);
IMP_SWIG_OBJECT(IMP::atom, WaterPDBSelector,WaterPDBSelectors);
IMP_SWIG_OBJECT(IMP::atom, WritePDBOptimizerState, WritePDBOptimizerStates);
IMP_SWIG_VALUE_INSTANCE(IMP::atom, AtomType, AtomType, AtomTypes);
IMP_SWIG_VALUE(IMP::atom, CHARMMAtomTopology, CHARMMAtomTopologies);
IMP_SWIG_VALUE(IMP::atom, CHARMMBondEndpoint, CHARMMBondEndpoints);
IMP_SWIG_VALUE(IMP::atom, CHARMMBondParameters, CHARMMBondParametersList);
IMP_SWIG_VALUE(IMP::atom, CHARMMDihedralParameters, CHARMMDihedralParametersList);
IMP_SWIG_OBJECT(IMP::atom, CHARMMIdealResidueTopology, CHARMMIdealResidueTopologies);
IMP_SWIG_VALUE(IMP::atom, CHARMMInternalCoordinate, CHARMMInternalCoordinates);
IMP_SWIG_OBJECT(IMP::atom, CHARMMPatch, CHARMMPatches);
IMP_SWIG_OBJECT(IMP::atom, CHARMMResidueTopologyBase, CHARMMResidueTopologyBases);
IMP_SWIG_VALUE_INSTANCE(IMP::atom, ResidueType, ResidueType, ResidueTypes);
IMP_SWIG_VALUE(IMP::atom, Selection, Selections);
IMP_SWIG_OBJECT(IMP::atom, RemoveRigidMotionOptimizerState, RemoveRigidMotionOptimizerStates);
IMP_SWIG_OBJECT(IMP::atom, BerendsenThermostatOptimizerState, BerendsenThermostatOptimizerStates);
IMP_SWIG_OBJECT(IMP::atom, LangevinThermostatOptimizerState, LangevinThermostatOptimizerStates);
IMP_SWIG_OBJECT(IMP::atom, SelectionGeometry, SelectionGeometries);
IMP_SWIG_OBJECT(IMP::atom, HierarchyGeometry, HierarchyGeometries);
IMP_SWIG_OBJECT(IMP::atom, HierarchiesGeometry, HierarchiesGeometries);
IMP_SWIG_OBJECT(IMP::atom, BondGeometry, BondGeometries);
IMP_SWIG_OBJECT(IMP::atom, BondsGeometry, BondsGeometries);
IMP_SWIG_OBJECT(IMP::atom, CAAngleRestraint, CAAngleRestraints);
IMP_SWIG_OBJECT(IMP::atom, CADihedralRestraint, CADihedralRestraints);
IMP_SWIG_OBJECT(IMP::atom, HelixRestraint, HelixRestraints);
IMP_SWIG_VALUE_INSTANCE(IMP::atom, CHARMMDihedral, CHARMMConnection, CHARMMDihedrals);
IMP_SWIG_VALUE_INSTANCE(IMP::atom, CHARMMBond, CHARMMConnection, CHARMMBonds);
IMP_SWIG_VALUE_INSTANCE(IMP::atom, CHARMMAngle, CHARMMConnection, CHARMMAngles);
// for some reason this one fails using the generic macro
 %extend IMP::atom::CHARMMConnection<D> {
  IMP_SWIG_SHOWSTUFF(CHARMMConnection);
 }

%extend IMP::atom::PDBSelector {
%pythoncode %{
  def __and__(self, s):
      return AndPDBSelector(self, s)
  def __or__(self, s):
      return OrPDBSelector(self, s)
  def __xor__(self, s):
      return XorPDBSelector(self, s)
  def __invert__(self):
      return NotPDBSelector(self)
  def __sub__(self, s):
      return AndPDBSelector(self, NotPDBSelector(s))
%}
}

%extend IMP::atom::Selection {
%pythoncode %{
  def __init__(self, hierarchy=None,
               hierarchies=None, **params):
      if hierarchy and hierarchies:
        raise RuntimeError("You can't pass both hierarchy and hierarchies to Selection")
      if hierarchy:
        this = _IMP_atom.new_Selection(hierarchy)
        try: self.this.append(this)
        except: self.this = this
      elif hierarchies:
        this = _IMP_atom.new_Selection(hierarchies)
        try: self.this.append(this)
        except: self.this = this
      else:
        raise ValueError("Either hierarchy or hierarchies must be provided.")
      for k in params.keys():
        eval("self.set_%s(params[k])"%k)

  def union(self, s):
      news = self.create_clone()
      news.union_update(s)
      return news
  def intersection(self, s):
      news = self.create_clone()
      news.intersection_update(s)
      return news
  def symmetric_difference(self, s):
      news = self.create_clone()
      news.symmetric_difference_update(s)
      return news
  def difference(self, s):
      news = self.create_clone()
      news.difference_update(s)
      return news
  def union_update(self, s):
      self.set_union(s)
      return self
  def intersection_update(self, s):
      self.set_intersection(s)
      return self
  def symmetric_difference_update(self, s):
      self.set_symmetric_difference(s)
      return self
  def difference_update(self, s):
      self.set_difference(s)
      return self
  __or__ = union
  __and__ = intersection
  __xor__ = symmetric_difference
  __sub__ = difference
  __ior__ = union_update
  __iand__ = intersection_update
  __ixor__ = symmetric_difference_update
  __isub__ = difference_update
%}
}

%include "IMP/atom/atom_macros.h"

// must be before hierarchy
%include "IMP/atom/bond_decorators.h"

// it is used as a base class
%include "IMP/atom/Hierarchy.h"


/* Wrap our own classes */
%include "IMP/atom/angle_decorators.h"
%include "IMP/atom/smoothing_functions.h"
%include "IMP/atom/AngleSingletonScore.h"
%include "IMP/atom/BondEndpointsRefiner.h"
%include "IMP/atom/BondPairContainer.h"
%include "IMP/atom/BondSingletonScore.h"
%include "IMP/atom/DihedralSingletonScore.h"
%include "IMP/atom/ImproperSingletonScore.h"
%include "IMP/atom/CenterOfMass.h"
%include "IMP/atom/CoverBond.h"
%include "IMP/atom/Simulator.h"
%include "IMP/atom/BrownianDynamics.h"
%include "IMP/atom/BrownianDynamicsTAMD.h"
%include "IMP/atom/Diffusion.h"
%include "IMP/atom/TAMDParticle.h"
%include "IMP/atom/Chain.h"
%include "IMP/atom/Charged.h"
%include "IMP/atom/CoulombPairScore.h"
%include "IMP/atom/Domain.h"
%include "IMP/atom/LennardJones.h"
%include "IMP/atom/LennardJonesPairScore.h"
%include "IMP/atom/MolecularDynamics.h"
%include "IMP/atom/VelocityScalingOptimizerState.h"
%include "IMP/atom/Fragment.h"
%include "IMP/atom/StereochemistryPairFilter.h"
%include "IMP/atom/SoapPairFilter.h"
%include "IMP/atom/Mass.h"
%include "IMP/atom/BondedPairFilter.h"
%include "IMP/atom/mol2.h"
%include "IMP/atom/SecondaryStructureResidue.h"
%include "IMP/atom/secondary_structure_reader.h"

%template(_ADopeBase) IMP::score_functor::DistancePairScore<IMP::score_functor::Dope>;
%template(_BDopeBase) IMP::score_functor::DistancePairScore< IMP::score_functor::Statistical< IMP::atom::DopeType,false,true,false > >;
%template(_OrientedSoapBase) IMP::score_functor::DistancePairScore<IMP::score_functor::OrientedSoap>;
namespace IMP {
  namespace atom {
   %template(_SPSFTB) ::IMP::score_functor::DistancePairScore<score_functor::Statistical< IMP::atom::ProteinLigandType, true, false> >;
   %template(_SPSTF) ::IMP::core::StatisticalPairScore< IMP::atom::ProteinLigandType, true, false>;
   %template(_SPSFT) ::IMP::core::StatisticalPairScore< IMP::atom::DopeType, false, true>;
  }
}
%include "IMP/atom/protein_ligand_score.h"

namespace IMP {
  namespace atom {
   // swig has random, perplexing issues if these are higher in the file
   %template(AtomType) ::IMP::Key<IMP_ATOM_TYPE_INDEX>;
   %template(ResidueType) ::IMP::Key<IMP_RESIDUE_TYPE_INDEX>;
  }
}
%include "IMP/atom/element.h"
%include "IMP/atom/Atom.h"
%include "IMP/atom/Residue.h"
%include "IMP/atom/Representation.h"
%include "IMP/atom/State.h"
%include "IMP/atom/dihedrals.h"
%include "IMP/atom/Molecule.h"
%include "IMP/atom/Copy.h"
%include "IMP/atom/Selection.h"
%include "IMP/atom/distance.h"
%include "IMP/atom/ForceFieldParameters.h"
%include "IMP/atom/charmm_topology.h"
%include "IMP/atom/CHARMMAtom.h"
%include "IMP/atom/CHARMMParameters.h"
%include "IMP/atom/charmm_segment_topology.h"
%include "IMP/atom/CHARMMStereochemistryRestraint.h"
%include "IMP/atom/force_fields.h"
%include "IMP/atom/estimates.h"
%include "IMP/atom/EzRestraint.h"
%include "IMP/atom/hierarchy_tools.h"
%include "IMP/atom/DopePairScore.h"
%include "IMP/atom/OrientedSoapPairScore.h"
%include "IMP/atom/SameResiduePairFilter.h"
%include "IMP/atom/RemoveRigidMotionOptimizerState.h"
%include "IMP/atom/BerendsenThermostatOptimizerState.h"
%include "IMP/atom/LangevinThermostatOptimizerState.h"
%include "IMP/atom/pdb.h"
%include "IMP/atom/constants.h"
%include "IMP/atom/CAAngleRestraint.h"
%include "IMP/atom/CADihedralRestraint.h"
%include "IMP/atom/StructureSource.h"
%include "IMP/atom/HelixRestraint.h"

namespace IMP {
  namespace atom {
   %template(show_molecular_hierarchy) IMP::core::show<IMP::atom::Hierarchy>;
   %template(CHARMMBond) CHARMMConnection<2>;
   %template(CHARMMAngle) CHARMMConnection<3>;
   %template(_get_native_overlap_cpp) get_native_overlap<IMP::Vector<algebra::VectorD<3> >, IMP::Vector<algebra::VectorD<3> > >;
   %template(_get_drmsd_cpp) get_drmsd<IMP::Vector<algebra::VectorD<3> >, IMP::Vector<algebra::VectorD<3> > >;
   %template(_get_drmsd_Q_cpp) get_drmsd_Q<IMP::Vector<algebra::VectorD<3> >, IMP::Vector<algebra::VectorD<3> > >;
   %template(_get_drms_cpp) get_drms<IMP::Vector<algebra::VectorD<3> >, IMP::Vector<algebra::VectorD<3> > >;
   %template(_get_rigid_bodies_drms_cpp) get_rigid_bodies_drms<IMP::Vector<algebra::VectorD<3> >, IMP::Vector<algebra::VectorD<3> > >;

  }
}

%pythoncode %{
def get_native_overlap(a, b, d):
   va= [IMP.algebra.get_vector(x) for x in a]
   vb= [IMP.algebra.get_vector(x) for x in b]
   return _get_native_overlap_cpp(va, vb, d)

def get_drmsd(a, b):
   va= [IMP.algebra.get_vector(x) for x in a]
   vb= [IMP.algebra.get_vector(x) for x in b]
   return _get_drmsd_cpp(va, vb)

def get_drms(a, b):
   va= [IMP.algebra.get_vector(x) for x in a]
   vb= [IMP.algebra.get_vector(x) for x in b]
   return _get_drms_cpp(va, vb)

def get_drmsd_Q(a, b, t):
   va= [IMP.algebra.get_vector(x) for x in a]
   vb= [IMP.algebra.get_vector(x) for x in b]
   return _get_drmsd_Q_cpp(va, vb, t)

def get_rigid_bodies_drms(a, b, ranges):
    va= [IMP.algebra.get_vector(x) for x in a]
    vb= [IMP.algebra.get_vector(x) for x in b]
    #rs = [IMP.IntRange(r[0],r[1]) for r in ranges]
    return _get_rigid_bodies_drms_cpp(va, vb, ranges)

%}
