// Autogenerated by ../../../../tmp/imp-20170926-4199-g92jdp/imp-2.8.0/tools/build/make_containers.py
// from ../../../../tmp/imp-20170926-4199-g92jdp/imp-2.8.0/tools/build/container_templates/container/ListClassnameContainer.h
// Do not edit - any changes will be lost!

/**
 *  \file IMP/container/ListQuadContainer.h
 *  \brief Store a list of ParticleIndexQuads.
 *
 *  Copyright 2007-2017 IMP Inventors. All rights reserved.
 */

#ifndef IMPCONTAINER_LIST_QUAD_CONTAINER_H
#define IMPCONTAINER_LIST_QUAD_CONTAINER_H

#include <IMP/container/container_config.h>
#include <IMP/object_macros.h>
#include <IMP/internal/StaticListContainer.h>
#include <IMP/QuadContainer.h>
#include <IMP/QuadModifier.h>
#include <IMP/base_types.h>

IMPCONTAINER_BEGIN_NAMESPACE

//! Store a list of ParticleIndexQuads
/** \note The order may change when particles are inserted
    as the list is maintained in sorted order.

    \note Changing the contents of the container is a fairly heavy
    weight operation as it resets part of the dependency graph. Use
    a DynamicListQuadContainer if you want to change the contents
    frequently (eg via a ScoreState).
 */
class IMPCONTAINEREXPORT ListQuadContainer :
#if defined(IMP_DOXYGEN) || defined(SWIG)
    public QuadContainer
#else
    public IMP::internal::StaticListContainer<QuadContainer>
#endif
    {
  typedef IMP::internal::StaticListContainer<QuadContainer> P;

 public:
  ListQuadContainer(Model *m, const ParticleIndexQuads &contents,
                         std::string name = "ListQuadContainer%1%");

  /** \deprecated_at{2.7} Use the index-based constructor instead */
  IMPCONTAINER_DEPRECATED_METHOD_DECL(2.7)
  ListQuadContainer(const ParticleQuadsTemp &ps,
                         std::string name = "ListQuadContainer%1%");

#ifndef IMP_DOXYGEN
  ListQuadContainer(Model *m,
                         std::string name = "ListQuadContainer %1%");
  ListQuadContainer(Model *m, const char *name);

#endif
#if defined(SWIG) || defined(IMP_DOXYGEN)
  //! Add a single const ParticleIndexQuad& to the container.
  void add(const ParticleIndexQuad& vt);

  //! Add ParticleIndexQuads to the container.
  void add(const ParticleIndexQuads &c);

  //! Set the contents of the container to the given ParticleIndexQuads.
  void set(ParticleIndexQuads cp);

  //! Clear the contents of the container.
  void clear();
#endif

#ifdef SWIG
  ParticleIndexQuads get_indexes() const;
  ParticleIndexQuads get_range_indexes() const;
  ModelObjectsTemp do_get_inputs() const;
  void do_apply(const QuadModifier *sm) const;
  ParticleIndexes get_all_possible_indexes() const;

 private:
  std::size_t do_get_contents_hash() const;
#endif
  IMP_OBJECT_METHODS(ListQuadContainer);
};

IMP_OBJECTS(ListQuadContainer, ListQuadContainers);

IMPCONTAINER_END_NAMESPACE

#endif /* IMPCONTAINER_LIST_QUAD_CONTAINER_H */
