// Autogenerated by ../../../../tmp/imp-20170913-7019-1eqecof/imp-2.8.0/tools/build/make_containers.py
// from ../../../../tmp/imp-20170913-7019-1eqecof/imp-2.8.0/tools/build/container_templates/core/classname_predicates.h
// Do not edit - any changes will be lost!

/**
 *  \file IMP/core/pair_predicates.h
 *  \brief Define some predicates.
 *
 *  Copyright 2007-2017 IMP Inventors. All rights reserved.
 */

#ifndef IMPCORE_PAIR_PREDICATES_H
#define IMPCORE_PAIR_PREDICATES_H

#include <IMP/core/core_config.h>
#include <IMP/PairPredicate.h>
#include <IMP/pair_macros.h>
#include <boost/random.hpp>
#include "internal/container_helpers.h"

IMPCORE_BEGIN_NAMESPACE

/** Always return a constant value.
 */
class IMPCOREEXPORT ConstantPairPredicate : public PairPredicate {
  int v_;

 public:
  ConstantPairPredicate(int v,
                             std::string name = "ConstPairPredicate%1%");
  virtual int get_value_index(Model *, const ParticleIndexPair&) const
      IMP_OVERRIDE {
    return v_;
  }
  virtual ModelObjectsTemp do_get_inputs(
      Model *, const ParticleIndexes &) const IMP_OVERRIDE {
    return ModelObjectsTemp();
  }
  IMP_PAIR_PREDICATE_METHODS(ConstantPairPredicate);
  IMP_OBJECT_METHODS(ConstantPairPredicate);
};

/** Return a unique predicate value for each unordered set of
   ParticleTypes
    (see Typed).
*/

class IMPCOREEXPORT UnorderedTypePairPredicate
    : public PairPredicate {
 public:
  UnorderedTypePairPredicate(std::string name =
                                      "UnorderedTypePairPredicate%1%");
  virtual int get_value_index(Model *m, const ParticleIndexPair& pi) const
      IMP_OVERRIDE {
    return internal::get_type_hash(m, pi);
  }
  virtual ModelObjectsTemp do_get_inputs(
      Model *m, const ParticleIndexes &pis) const IMP_OVERRIDE {
    ModelObjectsTemp ret;
    ret += IMP::get_particles(m, pis);
    return ret;
  }
  IMP_PAIR_PREDICATE_METHODS(UnorderedTypePairPredicate);
  IMP_OBJECT_METHODS(UnorderedTypePairPredicate);
};

/** Return a unique predicate value for each ordered pair of
    ParticleTypes (see Typed).
*/
class IMPCOREEXPORT OrderedTypePairPredicate : public PairPredicate {
 public:
  OrderedTypePairPredicate(std::string name =
                                    "OrderedTypePairPredicate%1%");
#ifndef SWIG
  using PairPredicate::get_value;
#endif
  int get_value(const core::ParticleTypes &types) {
    return internal::get_ordered_type_hash(types);
  }
  virtual int get_value_index(Model *m, const ParticleIndexPair& pi) const
      IMP_OVERRIDE {
    return internal::get_ordered_type_hash(m, pi);
  }
  virtual ModelObjectsTemp do_get_inputs(
      Model *m, const ParticleIndexes &pis) const IMP_OVERRIDE {
    ModelObjectsTemp ret;
    ret += IMP::get_particles(m, pis);
    return ret;
  }
  IMP_PAIR_PREDICATE_METHODS(OrderedTypePairPredicate);
  IMP_OBJECT_METHODS(OrderedTypePairPredicate);
};

/** Return true if all members of the tuple are the same. */
class IMPCOREEXPORT AllSamePairPredicate : public PairPredicate {
 public:
  AllSamePairPredicate(std::string name = "AllSamePairPredicate%1%");
  virtual int get_value_index(Model *m, const ParticleIndexPair& pi) const
      IMP_OVERRIDE {
    return internal::get_all_same(m, pi);
  }
  virtual ModelObjectsTemp do_get_inputs(
      Model *, const ParticleIndexes &) const IMP_OVERRIDE {
    return ModelObjectsTemp();
  }
  IMP_PAIR_PREDICATE_METHODS(AllSamePairPredicate);
  IMP_OBJECT_METHODS(AllSamePairPredicate);
};

/** Return true with a fixed probability. */
class IMPCOREEXPORT CoinFlipPairPredicate : public PairPredicate {
  double p_;
  mutable boost::uniform_real<double> rng_;

 public:
  CoinFlipPairPredicate(double p, std::string name =
                                           "CoinFlipPairPredicate%1%");
  virtual int get_value_index(Model *, const ParticleIndexPair&) const
      IMP_OVERRIDE {
    if (rng_(random_number_generator) < p_)
      return 1;
    else
      return 0;
  }
  virtual ModelObjectsTemp do_get_inputs(
      Model *, const ParticleIndexes &) const IMP_OVERRIDE {
    return ModelObjectsTemp();
  }
  IMP_PAIR_PREDICATE_METHODS(CoinFlipPairPredicate);
  IMP_OBJECT_METHODS(CoinFlipPairPredicate);
};

IMPCORE_END_NAMESPACE

#endif /* IMPCORE_PAIR_PREDICATES_H */
