// Autogenerated by ../../../../tmp/imp-20170905-68237-1btmru5/imp-2.8.0/tools/build/make_containers.py
// from ../../../../tmp/imp-20170905-68237-1btmru5/imp-2.8.0/tools/build/container_templates/kernel/ClassnameScore.h
// Do not edit - any changes will be lost!

/**
 *  \file IMP/QuadScore.h
 *  \brief Define QuadScore.
 *
 *  Copyright 2007-2017 IMP Inventors. All rights reserved.
 */

#ifndef IMPKERNEL_QUAD_SCORE_H
#define IMPKERNEL_QUAD_SCORE_H

#include <IMP/kernel_config.h>
#include "base_types.h"
#include "DerivativeAccumulator.h"
#include "internal/container_helpers.h"
#include <IMP/utility_macros.h>
#include "model_object_helpers.h"

IMPKERNEL_BEGIN_NAMESPACE

//! Abstract class for scoring object(s) of type ParticleIndexQuad.
/** QuadScore will evaluate the score and derivatives
    for passed object(s) of type ParticleIndexQuad.

    Use in conjunction with various
    restraints such as IMP::container::QuadsRestraint or
    IMP::core::QuadRestraint. The restraints couple the score
    functions with appropriate lists of object(s) of type ParticleIndexQuad.

    Implementers should check out IMP_QUAD_SCORE().

    \see PredicateQuadRestraint
*/
class IMPKERNELEXPORT QuadScore : public ParticleInputs,
                                       public Object {
 public:
  typedef ParticleQuad Argument;
  typedef ParticleIndexQuad IndexArgument;
  typedef const ParticleQuad& PassArgument;
  typedef const ParticleIndexQuad& PassIndexArgument;
  typedef QuadModifier Modifier;
  QuadScore(std::string name = "QuadScore %1%");

  //! Compute the score and the derivative if needed.
  /** @param m the model of vt
      @param vt the index in m of an object of type ParticleQuad
      @param da a DerivativeAccumulator that weights
                computed derivatives. If nullptr, derivatives
                will not be computed.
   */
  virtual double evaluate_index(Model *m, const ParticleIndexQuad& vt,
                                DerivativeAccumulator *da) const = 0;

  //! Compute the score and the derivative if needed over a set.
  /** @param m the model of o
      @param o objects of type ParticleQuad, specified by index
      @param da a derivative accumulator that weights
                computed derivatives. If nullptr, derivatives
                will not be computed.
      @param lower_bound index of first item in o to evaluate
      @param upper_bound index of last item in o to evaluate

      @note Implementations for these are provided by
            the IMP_QUAD_SCORE() macro.
  */
  virtual double evaluate_indexes(Model *m, const ParticleIndexQuads &o,
                                  DerivativeAccumulator *da,
                                  unsigned int lower_bound,
                                  unsigned int upper_bound) const;

  //! Compute the score and the derivative if needed, only if "good".
  /** This functions similarly to evaluate_index(),
      but may terminate the computation early if the score is higher than max.

      @return the score if score<= max or some arbitrary value > max otherwise.
  */
  virtual double evaluate_if_good_index(Model *m, const ParticleIndexQuad& vt,
                                        DerivativeAccumulator *da,
                                        double max) const;

  /** Compute the score and the derivative if needed over a set, only if "good".
      This functions similarly to evaluate_indexes(), but may terminate
      the computation early if the total score is higher than max.

      @return the score if score<= max or some arbitrary value > max otherwise.

      @note Implementations for these are provided by the IMP_QUAD_SCORE()
            macro.
  */
  virtual double evaluate_if_good_indexes(Model *m,
                                          const ParticleIndexQuads &o,
                                          DerivativeAccumulator *da, double max,
                                          unsigned int lower_bound,
                                          unsigned int upper_bound) const;

  //! Decompose this QuadScore into a set of
  //! currently positive restraints over vt.
  /** The scoring function and derivatives should
      be equal to the current score. The default implementation
      returns a single restraint with this score bound to vt,
      or zero restraints if the score equals zero.
. */
  Restraints create_current_decomposition(Model *m,
                                          const ParticleIndexQuad& vt) const;

 protected:
  //! Override this to return your own decomposition.
  virtual Restraints do_create_current_decomposition(Model *m,
                                                     const ParticleIndexQuad& vt) const;

  IMP_REF_COUNTED_DESTRUCTOR(QuadScore);
};

IMPKERNEL_END_NAMESPACE

#endif /* IMPKERNEL_QUAD_SCORE_H */
