// Autogenerated by ../../../../tmp/imp-20170905-25778-1jijakj/imp-2.8.0/tools/build/make_containers.py
// from ../../../../tmp/imp-20170905-25778-1jijakj/imp-2.8.0/tools/build/container_templates/core/classname_predicates.h
// Do not edit - any changes will be lost!

/**
 *  \file IMP/core/triplet_predicates.h
 *  \brief Define some predicates.
 *
 *  Copyright 2007-2017 IMP Inventors. All rights reserved.
 */

#ifndef IMPCORE_TRIPLET_PREDICATES_H
#define IMPCORE_TRIPLET_PREDICATES_H

#include <IMP/core/core_config.h>
#include <IMP/TripletPredicate.h>
#include <IMP/triplet_macros.h>
#include <boost/random.hpp>
#include "internal/container_helpers.h"

IMPCORE_BEGIN_NAMESPACE

/** Always return a constant value.
 */
class IMPCOREEXPORT ConstantTripletPredicate : public TripletPredicate {
  int v_;

 public:
  ConstantTripletPredicate(int v,
                             std::string name = "ConstTripletPredicate%1%");
  virtual int get_value_index(Model *, const ParticleIndexTriplet&) const
      IMP_OVERRIDE {
    return v_;
  }
  virtual ModelObjectsTemp do_get_inputs(
      Model *, const ParticleIndexes &) const IMP_OVERRIDE {
    return ModelObjectsTemp();
  }
  IMP_TRIPLET_PREDICATE_METHODS(ConstantTripletPredicate);
  IMP_OBJECT_METHODS(ConstantTripletPredicate);
};

/** Return a unique predicate value for each unordered set of
   ParticleTypes
    (see Typed).
*/

class IMPCOREEXPORT UnorderedTypeTripletPredicate
    : public TripletPredicate {
 public:
  UnorderedTypeTripletPredicate(std::string name =
                                      "UnorderedTypeTripletPredicate%1%");
  virtual int get_value_index(Model *m, const ParticleIndexTriplet& pi) const
      IMP_OVERRIDE {
    return internal::get_type_hash(m, pi);
  }
  virtual ModelObjectsTemp do_get_inputs(
      Model *m, const ParticleIndexes &pis) const IMP_OVERRIDE {
    ModelObjectsTemp ret;
    ret += IMP::get_particles(m, pis);
    return ret;
  }
  IMP_TRIPLET_PREDICATE_METHODS(UnorderedTypeTripletPredicate);
  IMP_OBJECT_METHODS(UnorderedTypeTripletPredicate);
};

/** Return a unique predicate value for each ordered triplet of
    ParticleTypes (see Typed).
*/
class IMPCOREEXPORT OrderedTypeTripletPredicate : public TripletPredicate {
 public:
  OrderedTypeTripletPredicate(std::string name =
                                    "OrderedTypeTripletPredicate%1%");
#ifndef SWIG
  using TripletPredicate::get_value;
#endif
  int get_value(const core::ParticleTypes &types) {
    return internal::get_ordered_type_hash(types);
  }
  virtual int get_value_index(Model *m, const ParticleIndexTriplet& pi) const
      IMP_OVERRIDE {
    return internal::get_ordered_type_hash(m, pi);
  }
  virtual ModelObjectsTemp do_get_inputs(
      Model *m, const ParticleIndexes &pis) const IMP_OVERRIDE {
    ModelObjectsTemp ret;
    ret += IMP::get_particles(m, pis);
    return ret;
  }
  IMP_TRIPLET_PREDICATE_METHODS(OrderedTypeTripletPredicate);
  IMP_OBJECT_METHODS(OrderedTypeTripletPredicate);
};

/** Return true if all members of the tuple are the same. */
class IMPCOREEXPORT AllSameTripletPredicate : public TripletPredicate {
 public:
  AllSameTripletPredicate(std::string name = "AllSameTripletPredicate%1%");
  virtual int get_value_index(Model *m, const ParticleIndexTriplet& pi) const
      IMP_OVERRIDE {
    return internal::get_all_same(m, pi);
  }
  virtual ModelObjectsTemp do_get_inputs(
      Model *, const ParticleIndexes &) const IMP_OVERRIDE {
    return ModelObjectsTemp();
  }
  IMP_TRIPLET_PREDICATE_METHODS(AllSameTripletPredicate);
  IMP_OBJECT_METHODS(AllSameTripletPredicate);
};

/** Return true with a fixed probability. */
class IMPCOREEXPORT CoinFlipTripletPredicate : public TripletPredicate {
  double p_;
  mutable boost::uniform_real<double> rng_;

 public:
  CoinFlipTripletPredicate(double p, std::string name =
                                           "CoinFlipTripletPredicate%1%");
  virtual int get_value_index(Model *, const ParticleIndexTriplet&) const
      IMP_OVERRIDE {
    if (rng_(random_number_generator) < p_)
      return 1;
    else
      return 0;
  }
  virtual ModelObjectsTemp do_get_inputs(
      Model *, const ParticleIndexes &) const IMP_OVERRIDE {
    return ModelObjectsTemp();
  }
  IMP_TRIPLET_PREDICATE_METHODS(CoinFlipTripletPredicate);
  IMP_OBJECT_METHODS(CoinFlipTripletPredicate);
};

IMPCORE_END_NAMESPACE

#endif /* IMPCORE_TRIPLET_PREDICATES_H */
