// Autogenerated by ../../../../tmp/imp-20180427-38378-1xhv085/imp-2.8.0/tools/build/make_containers.py
// from ../../../../tmp/imp-20180427-38378-1xhv085/imp-2.8.0/tools/build/container_templates/container/ClassnamesRestraint.h
// Do not edit - any changes will be lost!

/**
 *  \file IMP/container/SingletonsRestraint.h
 *  \brief Apply a SingletonScore to each Singleton in a list.
 *
 *  Copyright 2007-2017 IMP Inventors. All rights reserved.
 *
 */

#ifndef IMPCONTAINER_SINGLETONS_RESTRAINT_H
#define IMPCONTAINER_SINGLETONS_RESTRAINT_H

#include <IMP/container/container_config.h>
#include <IMP/internal/ContainerRestraint.h>
#include <IMP/SingletonContainer.h>
#include <IMP/SingletonScore.h>

IMPCONTAINER_BEGIN_NAMESPACE

//! Applies a SingletonScore to each Singleton in a list.
/** This restraint stores the used particle indexes in a ParticleIndexes.
    The container used can be set so that the list can be shared
    with other containers (or a nonbonded list can be used).

    Examples using various multiplicity containers:
    \include restrain_in_sphere.py
    \include nonbonded_interactions.py

    \see IMP::core::SingletonRestraint
 */
class SingletonsRestraint :
#if defined(SWIG) || defined(IMP_DOXYGEN)
    public Restraint
#else
    public IMP::internal::ContainerRestraint<SingletonScore, SingletonContainer>
#endif
    {
  typedef IMP::internal::ContainerRestraint<
      SingletonScore, SingletonContainer> P;

 public:
  //! Create the restraint with a shared container
  /** \param[in] ss The function to apply to each particle.
      \param[in] pc The container containing the stored particles. This
      container is not copied.
      \param[in] name The object name
   */
  SingletonsRestraint(SingletonScore *ss, SingletonContainerAdaptor pc,
                      std::string name = "SingletonsRestraint %1%")
      : P(ss, pc, name) {}

#if defined(IMP_DOXYGEN) || defined(SWIG)
  double unprotected_evaluate(IMP::DerivativeAccumulator *accum) const;
  IMP::ModelObjectsTemp do_get_inputs() const;
  IMP_OBJECT_METHODS(SingletonsRestraint)
#endif
};

IMP_OBJECTS(SingletonsRestraint, SingletonsRestraints);

IMPCONTAINER_END_NAMESPACE

#endif /* IMPCONTAINER_SINGLETONS_RESTRAINT_H */
