// Autogenerated by ../../../../tmp/imp-20180419-88325-vxxqg8/imp-2.8.0/tools/build/make_containers.py
// from ../../../../tmp/imp-20180419-88325-vxxqg8/imp-2.8.0/tools/build/container_templates/container/PredicateClassnamesRestraint.h
// Do not edit - any changes will be lost!

/**
 *  \file IMP/container/PredicateTripletsRestraint.h
 *  \brief Apply a TripletScore to each Triplet in a list.
 *
 *  Copyright 2007-2017 IMP Inventors. All rights reserved.
 *
 */

#ifndef IMPCONTAINER_PREDICATE_TRIPLETS_RESTRAINT_H
#define IMPCONTAINER_PREDICATE_TRIPLETS_RESTRAINT_H

#include <IMP/container/container_config.h>
#include <boost/unordered_map.hpp>
#include <IMP/TripletPredicate.h>
#include "generic.h"

#include <iostream>

IMPCONTAINER_BEGIN_NAMESPACE

//! Applies a TripletScore to each Triplet in a list based on a predicate
/** This restraint uses a passed predicate to choose which score to apply
    to each tuple in the input container. The selections are cached, making it
    substantially faster than using a core::TypedPairScore.

    \note The ordering of particles within a tuple may vary depending on the
    input container used. You may need to call set_score() with several
    different predicate values for different orderings.
*/
class IMPCONTAINEREXPORT PredicateTripletsRestraint : public Restraint {
  PointerMember<TripletPredicate> predicate_;
  PointerMember<TripletContainer> input_;
  mutable boost::unordered_map<int, ParticleIndexTriplets> lists_;
  boost::unordered_map<int, PointerMember<TripletScore> > scores_;
  mutable std::size_t input_version_;
  bool is_unknown_score_set_;
  bool error_on_unknown_;
  void update_lists_if_necessary() const;

 public:
  PredicateTripletsRestraint(TripletPredicate *pred,
                               TripletContainerAdaptor input,
                               std::string name =
                                   "PredicateTripletsRestraint %1%");

  /** Apply the passed score to all pairs whose predicate values match
      the passed value.*/
  void set_score(int predicate_value, TripletScore *score);

  /** Apply this score to any pair whose predicate value does not match
      one passed to set_score().*/
  void set_unknown_score(TripletScore *score);

  /** By default, it is an error if the predicate returns a value that is
      not known. If this is false, then they are silently skipped.
  */
  void set_is_complete(bool tf) { error_on_unknown_ = tf; }

  /** return the indexes of all particles for  a given predicate value.*/
  ParticleIndexTriplets get_indexes(int predicate_value) const {
    return lists_.find(predicate_value)->second;
  }

 public:
  void do_add_score_and_derivatives(IMP::ScoreAccumulator sa) const
      IMP_OVERRIDE;
  IMP::ModelObjectsTemp do_get_inputs() const IMP_OVERRIDE;
  IMP_OBJECT_METHODS(PredicateTripletsRestraint);

 private:
  Restraints do_create_current_decomposition() const;
};

IMPCONTAINER_END_NAMESPACE

#endif /* IMPCONTAINER_PREDICATE_TRIPLETS_RESTRAINT_H */
