// Autogenerated by ../../../../tmp/imp-20170821-71685-fbusj7/imp-2.8.0/tools/build/make_containers.py
// from ../../../../tmp/imp-20170821-71685-fbusj7/imp-2.8.0/tools/build/container_templates/kernel/ClassnameContainer.h
// Do not edit - any changes will be lost!

/**
 *  \file IMP/PairContainer.h
 *  \brief A container for Pairs.
 *
 *  Copyright 2007-2017 IMP Inventors. All rights reserved.
 */

#ifndef IMPKERNEL_PAIR_CONTAINER_H
#define IMPKERNEL_PAIR_CONTAINER_H

#include <IMP/kernel_config.h>
#include "internal/IndexingIterator.h"
#include "Particle.h"
#include "container_base.h"
#include "internal/container_helpers.h"
#include "DerivativeAccumulator.h"
#include "base_types.h"
#include <IMP/ref_counted_macros.h>
#include <IMP/check_macros.h>
#include <IMP/Pointer.h>
#include <IMP/InputAdaptor.h>
#include <IMP/utility_macros.h>
#include <IMP/deprecation_macros.h>
#include <algorithm>

IMPKERNEL_BEGIN_NAMESPACE
class PairModifier;
class PairScore;

//! A shared container for Pairs
/** Stores a shared collection of Pairs.
 */
class IMPKERNELEXPORT PairContainer : public Container {
 public:
  typedef ParticlePair ContainedType;
  typedef ParticlePairsTemp ContainedTypes;
  typedef ParticleIndexPairs ContainedIndexTypes;
  typedef ParticleIndexPair ContainedIndexType;
  typedef PairModifier Modifier;
  typedef const ParticleIndexPair& PassContainedIndexType;

  //! Just use apply() in the base class
  void apply_generic(const PairModifier *m) const;

  //! Apply a SingletonModifier to the contents
  void apply(const PairModifier *sm) const;

  /** Get all the indexes that might possibly be contained in the
      container, useful with dynamic containers. For example,
      with a container::ClosePairContainer, this is the list
      of all pairs taken from input list (those that are far apart
      in addition to those that are close).
  */
  virtual ParticleIndexPairs get_range_indexes() const = 0;

  const ParticleIndexPairs &get_contents() const {
    if (get_provides_access())
      return get_access();
    else {
      std::size_t nhash = get_contents_hash();
      if (contents_hash_ != nhash || !cache_initialized_) {
        contents_hash_ = nhash;
        cache_initialized_ = true;
        contents_cache_ = get_indexes();
      }
      return contents_cache_;
    }
  }

  /** Get all the indexes contained in the container.

    This should be protected but isn't for compatibility reasons.

    External callers should use get_contents().
  */
  virtual ParticleIndexPairs get_indexes() const = 0;

#ifndef IMP_DOXYGEN

  ParticlePairsTemp get() const {
    return IMP::internal::get_particle(get_model(), get_indexes());
  }

  ParticlePair get(unsigned int i) const {
    return IMP::internal::get_particle(get_model(), get_indexes()[i]);
  }
  unsigned int get_number() const { return get_indexes().size(); }
#ifndef SWIG
  bool get_provides_access() const;
  virtual const ParticleIndexPairs &get_access() const {
    IMP_THROW("Object not implemented properly.", IndexException);
  }

  template <class Functor>
  Functor for_each(Functor f) {
    ParticleIndexPairs vs = get_indexes();
    // use boost range instead
    return std::for_each(vs.begin(), vs.end(), f);
  }

#endif
#endif

  /** \deprecated_at{2.1} Use get_indexes() instead.
   */
  ParticlePairsTemp get_particle_pairs() const;

  /** \deprecated_at{2.1}Use get_indexes() instead and thing about using the
      IMP_CONTAINER_FOREACH() macro.*/
  IMPKERNEL_DEPRECATED_METHOD_DECL(2.1)
  ParticlePair get_particle_pair(unsigned int i) const;

 protected:
  PairContainer(Model *m,
                     std::string name = "PairContainer %1%");

  virtual void do_apply(const PairModifier *sm) const = 0;
  virtual bool do_get_provides_access() const { return false; }

  IMP_REF_COUNTED_NONTRIVIAL_DESTRUCTOR(PairContainer);

 private:
  mutable std::size_t contents_hash_;
  mutable ParticleIndexPairs contents_cache_;
  mutable bool cache_initialized_;
};

/** This class allows either a list or a container to be
    accepted as input.
*/
class IMPKERNELEXPORT PairContainerAdaptor :
#if !defined(SWIG) && !defined(IMP_DOXYGEN)
    public Pointer<PairContainer>
#else
    public InputAdaptor
#endif
    {
  typedef Pointer<PairContainer> P;

 public:
  PairContainerAdaptor() {}

  /**
     Constructs the adaptor pointing to c (so if the contents of c are changed
     dynamically, so do the contents of the adaptor, and vice versa)
   */
  PairContainerAdaptor(PairContainer *c);

  /**
     Constructs the adaptor pointing to c (so if the contents of c are changed
     dynamically, so do the contents of the adaptor, and vice versa)
   */
  template <class C>
  PairContainerAdaptor(IMP::internal::PointerBase<C> c)
      : P(c) {}

  /**
     Adapts the non-empty list t to PairContainer

     @param t a non-empty list of ParticlePairsTemp
  */
  PairContainerAdaptor(const ParticlePairsTemp &t);

  /** Set the name of the resulting container if it is currently the
      default value. */
  void set_name_if_default(std::string name);
};

IMPKERNEL_END_NAMESPACE

#endif /* IMPKERNEL_PAIR_CONTAINER_H */
