%template(_OpenCubicSplineBase) IMP::score_functor::ScoreUnaryFunction<IMP::score_functor::OpenCubicSpline>;

IMP_SWIG_BASE_OBJECT(IMP::core,  MonteCarloMover, MonteCarloMovers);
IMP_SWIG_VALUE(IMP::core, MonteCarloMoverResult, MonteCarloMoverResults);
IMP_SWIG_CONTAINER(IMP::core, IMP::core, MonteCarlo, Mover, mover);
IMP_SWIG_CONTAINER(IMP::core, IMP::core, SerialMover, Mover, mover);
IMP_SWIG_CONTAINER(IMP::core, IMP::core, SubsetMover, Mover, mover);

IMP_SWIG_OBJECT( IMP::core, AngleRestraint, AngleRestraints);
IMP_SWIG_OBJECT( IMP::core, AngleTripletScore, AngleTripletScores);
IMP_SWIG_OBJECT_INSTANCE( IMP::core, AttributeSingletonScore, AttributeSingletonScore, AttributeSingletonScores);
IMP_SWIG_OBJECT( IMP::core, BallMover, BallMovers);
IMP_SWIG_OBJECT( IMP::core, SerialMover, SerialMovers);
IMP_SWIG_OBJECT( IMP::core, SubsetMover, SubsetMovers);
IMP_SWIG_OBJECT( IMP::core, DirectionMover, DirectionMovers);
IMP_SWIG_OBJECT( IMP::core, SurfaceMover, SurfaceMovers);
IMP_SWIG_OBJECT_INSTANCE( IMP::core, BoundingBox3DSingletonScore, BoundingBox3DSingletonScore, BoundingBox3DSingletonScores);
#ifdef IMP_CORE_USE_IMP_CGAL
IMP_SWIG_OBJECT( IMP::core, BoxSweepClosePairsFinder, BoxSweepClosePairsFinders);
#endif
IMP_SWIG_OBJECT( IMP::core, NearestNeighborsClosePairsFinder, NearestNeighborsClosePairsFinders);
IMP_SWIG_OBJECT( IMP::core, CentroidOfRefined, CentroidOfRefineds);
IMP_SWIG_OBJECT( IMP::core, ChecksScoreState, ChecksScoreStates);
IMP_SWIG_OBJECT( IMP::core, ChildrenRefiner, ChildrenRefiners);
IMP_SWIG_OBJECT( IMP::core, ClosePairsFinder, ClosePairsFinders);
IMP_SWIG_OBJECT( IMP::core, ClosePairsPairScore, ClosePairsPairScores);
IMP_SWIG_OBJECT( IMP::core, ClosedCubicSpline, ClosedCubicSplines);
IMP_SWIG_OBJECT( IMP::core, ConjugateGradients, ConjugateGradientsList);
IMP_SWIG_OBJECT( IMP::core, ConnectivityRestraint, ConnectivityRestraints);
IMP_SWIG_OBJECT( IMP::core, ConstantRestraint, ConstantRestraints);
IMP_SWIG_OBJECT( IMP::core, Cosine, Cosines);
IMP_SWIG_OBJECT( IMP::core, CoverRefined, CoverRefineds);
IMP_SWIG_OBJECT( IMP::core, DerivativesFromRefined, DerivativesFromRefineds);
IMP_SWIG_OBJECT( IMP::core, DerivativesToRefined, DerivativesToRefineds);
IMP_SWIG_OBJECT( IMP::core, WeightedDerivativesToRefined, WeightedDerivativesToRefineds);
IMP_SWIG_OBJECT( IMP::core, DiameterRestraint, DiameterRestraints);
IMP_SWIG_OBJECT( IMP::core, DihedralRestraint, DihedralRestraints);
IMP_SWIG_OBJECT( IMP::core, DistanceRestraint, DistanceRestraints);
IMP_SWIG_OBJECT_INSTANCE( IMP::core, DistanceToSingletonScore, DistanceToSingletonScore, DistanceToSingletonScores);
IMP_SWIG_OBJECT( IMP::core, ExcludedVolumeRestraint, ExcludedVolumeRestraints);
IMP_SWIG_OBJECT( IMP::core, FixedRefiner, FixedRefiners);
IMP_SWIG_OBJECT( IMP::core, GridClosePairsFinder, GridClosePairsFinders);
IMP_SWIG_OBJECT( IMP::core, Harmonic, Harmonics);
IMP_SWIG_OBJECT( IMP::core, HarmonicWell, HarmonicWells);
IMP_SWIG_OBJECT( IMP::core, HarmonicLowerBound, HarmonicLowerBounds);
IMP_SWIG_OBJECT( IMP::core, HarmonicUpperBound, HarmonicUpperBounds);
IMP_SWIG_OBJECT( IMP::core, HarmonicSphereDistancePairScore, HarmonicSphereDistancePairScores);
IMP_SWIG_OBJECT( IMP::core, HarmonicUpperBoundSphereDistancePairScore, HarmonicUpperBoundSphereDistancePairScores);
IMP_SWIG_OBJECT( IMP::core, HarmonicUpperBoundSphereDiameterPairScore, HarmonicUpperBoundSphereDiameterPairScores);
IMP_SWIG_OBJECT( IMP::core, HarmonicSurfaceDistancePairScore, HarmonicSurfaceDistancePairScores);
IMP_SWIG_OBJECT( IMP::core, HarmonicSurfaceHeightPairScore, HarmonicSurfaceHeightPairScores);
IMP_SWIG_OBJECT( IMP::core, HarmonicSurfaceDepthPairScore, HarmonicSurfaceDepthPairScores);
IMP_SWIG_OBJECT( IMP::core, WeightedSum, WeightedSums);
IMP_SWIG_OBJECT( IMP::core, WeightedSumOfExponential, WeightedSumOfExponentials);
IMP_SWIG_OBJECT( IMP::core, IncrementalScoringFunction, IncrementalScoringFunctions);
IMP_SWIG_OBJECT( IMP::core, KClosePairsPairScore, KClosePairsPairScores);
IMP_SWIG_OBJECT( IMP::core, LeavesRefiner, LeavesRefiners);
IMP_SWIG_OBJECT( IMP::core, Linear, Linears);
IMP_SWIG_OBJECT( IMP::core, LogNormalMover, LogNormalMovers);
IMP_SWIG_OBJECT( IMP::core, MCCGSampler, MCCGSamplers);
IMP_SWIG_OBJECT( IMP::core, MonteCarlo, MonteCarlos);
IMP_SWIG_OBJECT( IMP::core, MonteCarloWithLocalOptimization, MonteCarloWithLocalOptimizations);
IMP_SWIG_OBJECT( IMP::core, MonteCarloWithBasinHopping, MonteCarloWithBasinHoppings);
IMP_SWIG_OBJECT( IMP::core, MSConnectivityRestraint, MSConnectivityRestraints);
IMP_SWIG_OBJECT( IMP::core, NeighborsTable, NeighborsTables);
IMP_SWIG_OBJECT( IMP::core, NormalMover, NormalMovers);
IMP_SWIG_OBJECT( IMP::core, NormalizedSphereDistancePairScore, NormalizedSphereDistancePairScores);
IMP_SWIG_OBJECT( IMP::core, OpenCubicSpline, OpenCubicSplines);
IMP_SWIG_OBJECT( IMP::core, PairConstraint, PairConstraints);
IMP_SWIG_OBJECT( IMP::core, PairRestraint, PairRestraints);
IMP_SWIG_OBJECT( IMP::core, QuadConstraint, QuadConstraints);
IMP_SWIG_OBJECT( IMP::core, QuadRestraint, QuadRestraints);
IMP_SWIG_OBJECT( IMP::core, QuadraticClosePairsFinder, QuadraticClosePairsFinders);
IMP_SWIG_OBJECT( IMP::core, RefinedPairsPairScore, RefinedPairsPairScores);
IMP_SWIG_OBJECT(IMP::core, RestraintsScoringFunction, RestraintsScoringFunctions);

IMP_SWIG_OBJECT( IMP::core, RigidBodyDistancePairScore, RigidBodyDistancePairScores);
IMP_SWIG_OBJECT( IMP::core, RigidBodyAnglePairScore, RigidBodyAnglePairScores);
IMP_SWIG_OBJECT( IMP::core, RigidBodyMover, RigidBodyMovers);
IMP_SWIG_OBJECT( IMP::core, RigidBodyTunneler, RigidBodyTunnelers);
IMP_SWIG_OBJECT( IMP::core, RigidBodyUmbrella, RigidBodyUmbrellas);
IMP_SWIG_OBJECT( IMP::core, RigidClosePairsFinder, RigidClosePairsFinders);
IMP_SWIG_OBJECT( IMP::core, RigidMembersRefiner, RigidMembersRefiners);
IMP_SWIG_OBJECT( IMP::core, SingletonConstraint, SingletonConstraints);
IMP_SWIG_OBJECT( IMP::core, SingletonRestraint, SingletonRestraints);
IMP_SWIG_OBJECT( IMP::core, SoftSpherePairScore, SoftSpherePairScores);
IMP_SWIG_OBJECT( IMP::core, SphereDistancePairScore, SphereDistancePairScores);
IMP_SWIG_OBJECT( IMP::core, SphereDistanceToSingletonScore, SphereDistanceToSingletonScores);
IMP_SWIG_OBJECT( IMP::core, SoftSubSurfacePairScore, SoftSubSurfacePairScores);
IMP_SWIG_OBJECT( IMP::core, SoftSuperSurfacePairScore, SoftSuperSurfacePairScores);
IMP_SWIG_OBJECT( IMP::core, SurfaceDistancePairScore, SurfaceDistancePairScores);
IMP_SWIG_OBJECT( IMP::core, SurfaceHeightPairScore, SurfaceHeightPairScores);
IMP_SWIG_OBJECT( IMP::core, SurfaceDepthPairScore, SurfaceDepthPairScores);
IMP_SWIG_OBJECT( IMP::core, SurfaceTetheredChain, SurfaceTetheredChains);
IMP_SWIG_OBJECT( IMP::core, SurfaceSymmetryConstraint, SurfaceSymmetryConstraints);
IMP_SWIG_OBJECT( IMP::core, SteepestDescent, SteepestDescents);
IMP_SWIG_OBJECT( IMP::core, TableRefiner, TableRefiners);
IMP_SWIG_OBJECT( IMP::core, Transform, Transforms);
IMP_SWIG_OBJECT( IMP::core, TransformationAndReflectionSymmetry, TransformationAndReflectionSymmetries);
IMP_SWIG_OBJECT( IMP::core, TransformationSymmetry, TransformationSymmetries);
IMP_SWIG_OBJECT( IMP::core, TransformationSymmetryMover, TransformationSymmetryMovers);
IMP_SWIG_OBJECT( IMP::core, TransformedDistancePairScore, TransformedDistancePairScores);
IMP_SWIG_OBJECT( IMP::core, TripletConstraint, TripletConstraints);
IMP_SWIG_OBJECT( IMP::core, TripletRestraint, TripletRestraints);
IMP_SWIG_OBJECT( IMP::core, TypedPairScore, TypedPairScores);
#ifdef IMP_CORE_USE_IMP_CGAL
IMP_SWIG_OBJECT( IMP::core, VolumeRestraint, VolumeRestraints);
#endif
IMP_SWIG_OBJECT( IMP::core, WeightedSphereDistancePairScore, WeightedSphereDistancePairScores);
IMP_SWIG_OBJECT( IMP::core, MoveStatisticsScoreState, MoveStatisticsScoreStates);
IMP_SWIG_OBJECT( IMP::core, MinimumRestraint, MinimumRestraints);
IMP_SWIG_OBJECT( IMP::core, WriteRestraintScoresOptimizerState, WriteRestraintScoresOptimizerStates);
IMP_SWIG_OBJECT( IMP::core, LateralSurfaceConstraint, LateralSurfaceConstraints);

IMP_SWIG_OBJECT( IMP::core, ConstantSingletonPredicate, ConstantSingletonPredicates);
IMP_SWIG_OBJECT( IMP::core, ConstantPairPredicate, ConstantPairPredicates);
IMP_SWIG_OBJECT( IMP::core, ConstantTripletPredicate, ConstantTripletPredicates);
IMP_SWIG_OBJECT( IMP::core, ConstantQuadPredicate, ConstantQuadPredicates);

IMP_SWIG_OBJECT( IMP::core, CoinFlipSingletonPredicate, CoinFlipSingletonPredicates);
IMP_SWIG_OBJECT( IMP::core, CoinFlipPairPredicate, CoinFlipPairPredicates);
IMP_SWIG_OBJECT( IMP::core, CoinFlipTripletPredicate, CoinFlipTripletPredicates);
IMP_SWIG_OBJECT( IMP::core, CoinFlipQuadPredicate, CoinFlipQuadPredicates);

IMP_SWIG_OBJECT( IMP::core, UnorderedTypeSingletonPredicate, UnorderedTypeSingletonPredicates);
IMP_SWIG_OBJECT( IMP::core, UnorderedTypePairPredicate, UnorderedTypePairPredicates);
IMP_SWIG_OBJECT( IMP::core, UnorderedTypeTripletPredicate, UnorderedTypeTripletPredicates);
IMP_SWIG_OBJECT( IMP::core, UnorderedTypeQuadPredicate, UnorderedTypeQuadPredicates);

IMP_SWIG_OBJECT( IMP::core, OrderedTypeSingletonPredicate, OrderedTypeSingletonPredicates);
IMP_SWIG_OBJECT( IMP::core, OrderedTypePairPredicate, OrderedTypePairPredicates);
IMP_SWIG_OBJECT( IMP::core, OrderedTypeTripletPredicate, OrderedTypeTripletPredicates);
IMP_SWIG_OBJECT( IMP::core, OrderedTypeQuadPredicate, OrderedTypeQuadPredicates);

IMP_SWIG_OBJECT( IMP::core, AllSameSingletonPredicate, AllSameSingletonPredicates);
IMP_SWIG_OBJECT( IMP::core, AllSamePairPredicate, AllSamePairPredicates);
IMP_SWIG_OBJECT( IMP::core, AllSameTripletPredicate, AllSameTripletPredicates);
IMP_SWIG_OBJECT( IMP::core, AllSameQuadPredicate, AllSameQuadPredicates);

IMP_SWIG_DECORATOR( IMP::core, XYZ, XYZs);
IMP_SWIG_DECORATOR( IMP::core, XYZR, XYZRs);
IMP_SWIG_DECORATOR( IMP::core, RigidBody, RigidBodies);
IMP_SWIG_DECORATOR( IMP::core, RigidBodyMember, RigidBodyMembers);
IMP_SWIG_DECORATOR( IMP::core, RigidMember, RigidMembers);
IMP_SWIG_DECORATOR( IMP::core, NonRigidMember, NonRigidMembers);
IMP_SWIG_DECORATOR( IMP::core, Centroid, Centroids);
IMP_SWIG_DECORATOR( IMP::core, Cover, Covers);
IMP_SWIG_DECORATOR( IMP::core, Reference, References);
IMP_SWIG_VALUE_INSTANCE(IMP::core, ParticleType, ParticleType, ParticleTypes);
IMP_SWIG_DECORATOR( IMP::core, Typed, Typeds);
IMP_SWIG_DECORATOR_WITH_TRAITS( IMP::core, Hierarchy, GenericHierarchies);
IMP_SWIG_DECORATOR( IMP::core, Gaussian, Gaussians)
IMP_SWIG_DIRECTOR(IMP::core, HierarchyVisitor);
IMP_SWIG_DECORATOR( IMP::core, Direction, Directions);
IMP_SWIG_DECORATOR( IMP::core, DirectionAngle, DirectionAngles);
IMP_SWIG_DECORATOR( IMP::core, Surface, Surfaces);

IMP_SWIG_VALUE( IMP::core, HierarchyCounter, HierarchyCounters);
IMP_SWIG_VALUE( IMP::core, HierarchyTraits, HierarchyTraitsList);

IMP_SWIG_OBJECT_INSTANCE( IMP::core, TruncatedHarmonicBound, TruncatedHarmonic, TruncatedHarmonicBounds);
IMP_SWIG_OBJECT_INSTANCE( IMP::core, TruncatedHarmonicLowerBound, TruncatedHarmonic, TruncatedHarmonicLowerBounds);
IMP_SWIG_OBJECT_INSTANCE( IMP::core, TruncatedHarmonicUpperBound, TruncatedHarmonic, TruncatedHarmonicUpperBounds);
IMP_SWIG_OBJECT_TEMPLATE( IMP::core, TruncatedHarmonic);
IMP_SWIG_OBJECT( IMP::core, HarmonicDistancePairScore, HarmonicDistancePairScores);
IMP_SWIG_OBJECT( IMP::core, DistancePairScore, DistancePairScores);


IMP_SWIG_OBJECT(IMP::core, XYZRGeometry, XYZRGeometries);
IMP_SWIG_OBJECT(IMP::core, XYZRsGeometry, XYZRsGeometries);
IMP_SWIG_OBJECT(IMP::core, XYZDerivativeGeometry, XYZDerivativeGeometries);
IMP_SWIG_OBJECT(IMP::core, XYZDerivativesGeometry, XYZDerivativesGeometries);
IMP_SWIG_OBJECT(IMP::core, RigidBodyDerivativeGeometry, RigidBodyDerivativeGeometries);
IMP_SWIG_OBJECT(IMP::core, RigidBodyDerivativesGeometry, RigidBodyDerivativesGeometries);
IMP_SWIG_OBJECT(IMP::core, RigidBodyHierarchyGeometry, RigidBodyHierarchyGeometries);
IMP_SWIG_OBJECT(IMP::core, RigidBodyFrameGeometry, RigidBodyFrameGeometries);
IMP_SWIG_OBJECT(IMP::core, RigidBodyFramesGeometry, RigidBodyFramesGeometries);
IMP_SWIG_OBJECT(IMP::core, RigidBodyTorque, RigidBodyFramesTorques);
IMP_SWIG_OBJECT(IMP::core, EdgePairGeometry, EdgePairGeometries);
IMP_SWIG_OBJECT(IMP::core, EdgePairsGeometry, EdgePairsGeometries);
IMP_SWIG_OBJECT(IMP::core, SurfaceGeometry, SurfaceGeometries);
IMP_SWIG_OBJECT(IMP::core, SurfaceGeometryConstraint, SurfaceGeometryConstraints);

IMP_SWIG_OBJECT(IMP::core, AttributeSingletonPredicate, AttributeSingletonPredicates);
IMP_SWIG_OBJECT(IMP::core, InBoundingBox3DSingletonPredicate, InBoundingBox3DSingletonPredicates);
IMP_SWIG_OBJECT(IMP::core, IsCollisionPairPredicate, IsCollisionPairPredicates);

IMP_SWIG_VALUE(IMP::core, BinormalTerm, BinormalTermList);
IMP_SWIG_OBJECT(IMP::core, MultipleBinormalRestraint, MultipleBinormalRestraints);


/* Don't wrap internal classes */
%ignore IMP::core::internal::ChildArrayTraits;

/* Wrap our own base classes */
%include "IMP/core/ClosePairsFinder.h"
%include "IMP/core/MonteCarloMover.h"

%include "IMP/core/XYZ.h"

%include "IMP/core/XYZR.h"

%include "IMP/core/direction.h"

%include "IMP/core/Surface.h"

/* Wrap the final classes */
%include "IMP/core/AngleTripletScore.h"
%include "IMP/core/GenericAttributeSingletonScore.h"
%include "IMP/core/BallMover.h"
%include "IMP/core/SerialMover.h"
%include "IMP/core/SubsetMover.h"
%include "IMP/core/DirectionMover.h"
%include "IMP/core/SurfaceMover.h"
%include "IMP/core/BoxSweepClosePairsFinder.h"
%include "IMP/core/CentroidOfRefined.h"
%include "IMP/core/ChecksScoreState.h"
%include "IMP/core/ChildrenRefiner.h"
%include "IMP/core/ClosedCubicSpline.h"
%include "IMP/core/ClosePairsPairScore.h"
%include "IMP/core/ConjugateGradients.h"
%include "IMP/core/ConnectivityRestraint.h"
%include "IMP/core/ConstantRestraint.h"
%include "IMP/core/Cosine.h"
%include "IMP/core/CoverRefined.h"
%include "IMP/core/DerivativesFromRefined.h"
%include "IMP/core/DerivativesToRefined.h"
%include "IMP/core/DiameterRestraint.h"
%include "IMP/core/Transform.h"
%include "IMP/core/symmetry.h"
%include "IMP/core/DihedralRestraint.h"
%include "IMP/core/DistancePairScore.h"
%include "IMP/core/DistanceRestraint.h"
%include "IMP/core/DistanceToSingletonScore.h"
%include "IMP/core/ExcludedVolumeRestraint.h"
%include "IMP/core/BoundingBox3DSingletonScore.h"
%include "IMP/core/FixedRefiner.h"
%include "IMP/core/GridClosePairsFinder.h"
%include "IMP/core/Harmonic.h"
%include "IMP/core/HarmonicWell.h"
%include "IMP/core/HarmonicLowerBound.h"
%include "IMP/core/HarmonicUpperBound.h"
%include "IMP/core/WeightedSum.h"
%include "IMP/core/WeightedSumOfExponential.h"
%include "IMP/core/PeriodicOptimizerState.h"
%include "IMP/core/MSConnectivityRestraint.h"
%inline %{
namespace IMP {
namespace core {
class HierarchyTraits;
}
}
%}
%include "IMP/core/Hierarchy.h"
%inline %{
namespace IMP {
namespace core {
void visit_breadth_first(Hierarchy d, HierarchyVisitor *f)
{
  std::deque<Hierarchy> stack;
  stack.push_back(d);
  //d.show(std::cerr);
  do {
    Hierarchy cur= stack.front();
    stack.pop_front();
    if (f->operator()(cur)) {
      //std::cerr << "Visiting particle " << cur.get_particle() << std::endl;
      for (int i=cur.get_number_of_children()-1; i>=0; --i) {
        stack.push_back(cur.get_child(i));
      }
    }
  } while (!stack.empty());
}

void visit_depth_first(Hierarchy d, HierarchyVisitor *f)
{
  IMP::Vector<Hierarchy> stack;
  stack.push_back(d);
  do {
    Hierarchy cur= stack.back();
    stack.pop_back();
    if (f->operator()(cur)) {
      for (int i=cur.get_number_of_children()-1; i>=0; --i) {
        stack.push_back(cur.get_child(i));
      }
    }
  } while (!stack.empty());
}
}
}

%}
%include "IMP/core/LeavesRefiner.h"
%include "IMP/core/Linear.h"
%include "IMP/core/LogNormalMover.h"
%include "IMP/core/IncrementalScoringFunction.h"
%include "IMP/core/MonteCarlo.h"
%include "IMP/core/NeighborsTable.h"
%include "IMP/core/NormalMover.h"
%include "IMP/core/OpenCubicSpline.h"
%include "IMP/core/QuadraticClosePairsFinder.h"
%include "IMP/core/RefinedPairsPairScore.h"
%include "IMP/core/rigid_bodies.h"
%include "IMP/core/rigid_body_geometries.h"
%include "IMP/core/NearestNeighborsClosePairsFinder.h"
%include "IMP/core/RestraintsScoringFunction.h"
%include "IMP/core/RigidClosePairsFinder.h"
%include "IMP/core/SphereDistancePairScore.h"
%include "IMP/core/SurfaceDistancePairScore.h"
%include "IMP/core/SurfaceTetheredChain.h"
%include "IMP/core/SurfaceSymmetryConstraint.h"
%include "IMP/core/SteepestDescent.h"
%include "IMP/core/TransformedDistancePairScore.h"
%include "IMP/core/TypedPairScore.h"
%include "IMP/core/RigidBodyDistancePairScore.h"
%include "IMP/core/RigidBodyAnglePairScore.h"
%include "IMP/core/TableRefiner.h"
%include "IMP/core/TruncatedHarmonic.h"
%include "IMP/core/MCCGSampler.h"
%include "IMP/core/MinimumRestraint.h"
%include "IMP/core/Gaussian.h"

%include "IMP/core/PairRestraint.h"
%include "IMP/core/SingletonRestraint.h"
%include "IMP/core/TripletRestraint.h"
%include "IMP/core/QuadRestraint.h"

%include "IMP/core/SingletonConstraint.h"
%include "IMP/core/PairConstraint.h"
%include "IMP/core/TripletConstraint.h"
%include "IMP/core/QuadConstraint.h"

%include "IMP/core/singleton_predicates.h"
%include "IMP/core/pair_predicates.h"
%include "IMP/core/triplet_predicates.h"
%include "IMP/core/quad_predicates.h"
%include "IMP/core/predicates.h"

%include "IMP/core/AngleRestraint.h"
%include "IMP/core/RigidBodyMover.h"
%include "IMP/core/RigidBodyTunneler.h"
%include "IMP/core/RigidBodyUmbrella.h"
%include "IMP/core/VolumeRestraint.h"
%include "IMP/core/utility.h"
%include "IMP/core/StatisticalPairScore.h"
%include "IMP/core/MoveStatisticsScoreState.h"
%include "IMP/core/Typed.h"
%include "IMP/core/model_statistics.h"
%include "IMP/core/blame.h"
%include "IMP/core/MultipleBinormalRestraint.h"

%inline %{
namespace IMP {
namespace core {
algebra::Transformation3D get_transformation_aligning_first_to_second(const ParticlesTemp &a, const ParticlesTemp &b) {
return IMP::algebra::get_transformation_aligning_first_to_second(XYZs(a),XYZs(b));
}
algebra::Transformation3D get_transformation_aligning_first_to_second(const ParticlesTemp &a, const IMP::Vector<algebra::VectorD<3> > &b) {
return IMP::algebra::get_transformation_aligning_first_to_second(XYZs(a), b);
}
algebra::Transformation3D get_transformation_aligning_first_to_second(const IMP::Vector<algebra::VectorD<3> > &a, const ParticlesTemp &b) {
return algebra::get_transformation_aligning_first_to_second(a, XYZs(b));
}
}
}

IMP::Restraint *create_restraint(IMP::PairScore *ps, IMP::ParticlePair pp) {
   return IMP::create_restraint(ps, pp);
}
%}

namespace IMP {
  namespace core {
    %template(TruncatedHarmonicLowerBound) ::IMP::core::TruncatedHarmonic<LOWER>;
    %template(TruncatedHarmonicUpperBound) ::IMP::core::TruncatedHarmonic<UPPER>;
    %template(TruncatedHarmonicBound) ::IMP::core::TruncatedHarmonic<BOTH>;
    // swig screws up on scopes, I can't be bothered to fix it
    //%template(show_named_hierarchy) show<::IMP::core::Name>;
   %template(ParticleType) ::IMP::Key<IMP_PARTICLE_TYPE_INDEX>;

  }
}

IMP_SWIG_GENERIC_OBJECT_TEMPLATE(IMP::core, AttributeSingletonScore, generic_attribute_singleton_score, UnaryFunction);
IMP_SWIG_GENERIC_OBJECT_TEMPLATE(IMP::core, BoundingBox3DSingletonScore, bounding_box_3d_singleton_score, UnaryFunction);
IMP_SWIG_GENERIC_OBJECT_TEMPLATE(IMP::core, DistanceToSingletonScore, distance_to_singleton_score, UnaryFunction);
