// Autogenerated by ../../../../tmp/imp-20170811-44635-xz9e0d/imp-2.8.0/tools/build/make_containers.py
// from ../../../../tmp/imp-20170811-44635-xz9e0d/imp-2.8.0/tools/build/container_templates/kernel/classname_macros.h
// Do not edit - any changes will be lost!

/**
 *  \file IMP/pair_macros.h
 *  \brief Macros for various classes.
 *
 *  Copyright 2007-2017 IMP Inventors. All rights reserved.
 */

#ifndef IMPKERNEL_PAIR_MACROS_H
#define IMPKERNEL_PAIR_MACROS_H

#include "internal/TupleRestraint.h"
#include "internal/functors.h"
#include "container_macros.h"
#include <IMP/object_macros.h>
#include <algorithm>

/** Define
    - IMP::PairScore::evaluate_indexes()
    - IMP::PairScore::evaluate_if_good_indexes()
 */
#define IMP_PAIR_SCORE_METHODS(Name)                                      \
  double evaluate_indexes(Model *m, const ParticleIndexPairs &p,                  \
                          DerivativeAccumulator *da, unsigned int lower_bound, \
                          unsigned int upper_bound) const IMP_FINAL {          \
    double ret = 0;                                                            \
    for (unsigned int i = lower_bound; i < upper_bound; ++i) {                 \
      ret += evaluate_index(m, p[i], da);                                      \
    }                                                                          \
    return ret;                                                                \
  }                                                                            \
  double evaluate_if_good_indexes(                                             \
      Model *m, const ParticleIndexPairs &p, DerivativeAccumulator *da,           \
      double max, unsigned int lower_bound, unsigned int upper_bound) const {  \
    double ret = 0;                                                            \
    for (unsigned int i = lower_bound; i < upper_bound; ++i) {                 \
      ret += evaluate_if_good_index(m, p[i], da, max - ret);                   \
      if (ret > max) return std::numeric_limits<double>::max();                \
    }                                                                          \
    return ret;                                                                \
  }

//! Define extra the functions needed for a PairPredicate
#define IMP_PAIR_PREDICATE_METHODS(Name)                                  \
  int get_value(const ParticlePair& a) const {                                        \
    return get_value_index(IMP::internal::get_model(a),                        \
                           IMP::internal::get_index(a));                       \
  }                                                                            \
  Ints get_value(const ParticlePairsTemp &o) const {                          \
    Ints ret(o.size());                                                        \
    for (unsigned int i = 0; i < o.size(); ++i) {                              \
      ret[i] += Name::get_value(o[i]);                                         \
    }                                                                          \
    return ret;                                                                \
  }                                                                            \
  Ints get_value_index(Model *m, const ParticleIndexPairs &o) const {             \
    Ints ret(o.size());                                                        \
    for (unsigned int i = 0; i < o.size(); ++i) {                              \
      ret[i] += Name::get_value_index(m, o[i]);                                \
    }                                                                          \
    return ret;                                                                \
  }                                                                            \
  IMP_IMPLEMENT_INLINE_NO_SWIG(                                                \
      void remove_if_equal(Model *m, ParticleIndexPairs &ps,                      \
                           int value) const,                                   \
  {                                                                            \
        ps.erase(                                                              \
            std::remove_if(ps.begin(), ps.end(),                               \
                           IMP::internal::PredicateEquals<Name, true>(         \
                               this, m, value)),                               \
            ps.end());                                                         \
      });                                                                      \
  IMP_IMPLEMENT_INLINE_NO_SWIG(void remove_if_not_equal(Model *m,              \
                                                        ParticleIndexPairs &ps,   \
                                                        int value) const,      \
  {                                                                            \
    ps.erase(                                                                  \
        std::remove_if(ps.begin(), ps.end(),                                   \
                       IMP::internal::PredicateEquals<Name, false>(            \
                           this, m, value)),                                   \
        ps.end());                                                             \
  });

//! Use IMP_PAIR_MODIFIER() instead
#define IMP_PAIR_DERIVATIVE_MODIFIER(Name) IMP_PAIR_MODIFIER(Name)

/** Define
    - IMP::PairModifier::apply_indexes()
*/
#define IMP_PAIR_MODIFIER_METHODS(Name)                             \
  virtual void apply_indexes(Model *m, const ParticleIndexPairs &o,         \
                             unsigned int lower_bound,                   \
                             unsigned int upper_bound) const IMP_FINAL { \
    for (unsigned int i = lower_bound; i < upper_bound; ++i) {           \
      apply_index(m, o[i]);                                              \
    }                                                                    \
  }

//! Use IMP_INDEX_PAIR_MODIFIER instead
#define IMP_INDEX_PAIR_DERIVATIVE_MODIFIER(Name) \
  IMP_INDEX_PAIR_MODIFIER(Name)

#ifndef IMP_DOXYGEN
#define IMP_IMPLEMENT_PAIR_CONTAINER(Name)                          \
  IMP_IMPLEMENT_INLINE(void do_apply(const PairModifier *sm) const, \
  { apply_generic(sm); });                                               \
  virtual ParticleIndexes get_all_possible_indexes() const IMP_OVERRIDE; \
  IMP_OBJECT_METHODS(Name)
#endif

/** Use this to fill in container methods
    IMP::PairContainer::do_apply()
*/
#define IMP_PAIR_CONTAINER_METHODS(Name) \
  void do_apply(const PairModifier *sm) const { apply_generic(sm); }

#endif /* IMPKERNEL_PAIR_MACROS_H */
