// Autogenerated by ../../../../tmp/imp-20170413-86920-y4qu5y/imp-2.7.0/tools/build/make_containers.py
// from ../../../../tmp/imp-20170413-86920-y4qu5y/imp-2.7.0/tools/build/container_templates/container/internal/ClassnameContainerIndex.h
// Do not edit - any changes will be lost!

/**
 *  \file IMP/container/SingletonContainerStatistics.h
 *  \brief A container for Singletons.
 *
 *  Copyright 2007-2017 IMP Inventors. All rights reserved.
 */

#ifndef IMPCONTAINER_SINGLETON_CONTAINER_INDEX_H
#define IMPCONTAINER_SINGLETON_CONTAINER_INDEX_H

#include <IMP/container/container_config.h>
#include <IMP/SingletonContainer.h>
#include <IMP/internal/container_helpers.h>
#include <IMP/ScoreState.h>
#include <boost/unordered_set.hpp>

IMPCONTAINER_BEGIN_INTERNAL_NAMESPACE

/** Store an index that allows one to quickly determine of something
    is in a container.*/
class IMPCONTAINEREXPORT SingletonContainerIndex : public ScoreState {
  Pointer<SingletonContainer> container_;
  std::size_t container_version_;
  boost::unordered_set<ParticleIndex> contents_;
  bool handle_permutations_;

  void build();

 public:
  SingletonContainerIndex(SingletonContainerAdaptor c,
                          bool handle_permutations);
  bool get_contains(ParticleIndex i) const {
    if (handle_permutations_) i = IMP::internal::get_canonical(i);
    return contents_.find(i) != contents_.end();
  }
  virtual void do_before_evaluate() IMP_OVERRIDE;
  virtual void do_after_evaluate(DerivativeAccumulator *da) IMP_OVERRIDE;
  virtual ModelObjectsTemp do_get_inputs() const IMP_OVERRIDE;
  virtual ModelObjectsTemp do_get_outputs() const IMP_OVERRIDE;
  IMP_OBJECT_METHODS(SingletonContainerIndex);
};

IMPCONTAINER_END_INTERNAL_NAMESPACE

#endif /* IMPCONTAINER_SINGLETON_CONTAINER_INDEX_H */
