// Autogenerated by ../../../../tmp/imp-20170413-86920-y4qu5y/imp-2.7.0/tools/build/make_containers.py
// from ../../../../tmp/imp-20170413-86920-y4qu5y/imp-2.7.0/tools/build/container_templates/container/ListClassnameContainer.h
// Do not edit - any changes will be lost!

/**
 *  \file IMP/container/ListSingletonContainer.h
 *  \brief Store a list of ParticleIndexes.
 *
 *  Copyright 2007-2017 IMP Inventors. All rights reserved.
 */

#ifndef IMPCONTAINER_LIST_SINGLETON_CONTAINER_H
#define IMPCONTAINER_LIST_SINGLETON_CONTAINER_H

#include <IMP/container/container_config.h>
#include <IMP/object_macros.h>
#include <IMP/internal/StaticListContainer.h>
#include <IMP/SingletonContainer.h>
#include <IMP/SingletonModifier.h>
#include <IMP/base_types.h>

IMPCONTAINER_BEGIN_NAMESPACE

//! Store a list of ParticleIndexes
/** \note The order may change when particles are inserted
    as the list is maintained in sorted order.

    \note Changing the contents of the container is a fairly heavy
    weight operation as it resets part of the dependency graph. Use
    a DynamicListSingletonContainer if you want to change the contents
    frequently (eg via a ScoreState).
 */
class IMPCONTAINEREXPORT ListSingletonContainer :
#if defined(IMP_DOXYGEN) || defined(SWIG)
    public SingletonContainer
#else
    public IMP::internal::StaticListContainer<SingletonContainer>
#endif
    {
  typedef IMP::internal::StaticListContainer<SingletonContainer> P;

 public:
  ListSingletonContainer(Model *m, const ParticleIndexes &contents,
                         std::string name = "ListSingletonContainer%1%");

  /** \deprecated_at{2.7} Use the index-based constructor instead */
  IMPCONTAINER_DEPRECATED_METHOD_DECL(2.7)
  ListSingletonContainer(const ParticlesTemp &ps,
                         std::string name = "ListSingletonContainer%1%");

#ifndef IMP_DOXYGEN
  ListSingletonContainer(Model *m,
                         std::string name = "ListSingletonContainer %1%");
  ListSingletonContainer(Model *m, const char *name);

#endif
#if defined(SWIG) || defined(IMP_DOXYGEN)
  //! Add a single ParticleIndex to the container.
  void add(ParticleIndex vt);

  //! Add ParticleIndexes to the container.
  void add(const ParticleIndexes &c);

  //! Set the contents of the container to the given ParticleIndexes.
  void set(ParticleIndexes cp);

  //! Clear the contents of the container.
  void clear();
#endif

#ifdef SWIG
  ParticleIndexes get_indexes() const;
  ParticleIndexes get_range_indexes() const;
  ModelObjectsTemp do_get_inputs() const;
  void do_apply(const SingletonModifier *sm) const;
  ParticleIndexes get_all_possible_indexes() const;

 private:
  std::size_t do_get_contents_hash() const;
#endif
  IMP_OBJECT_METHODS(ListSingletonContainer);
};

IMP_OBJECTS(ListSingletonContainer, ListSingletonContainers);

IMPCONTAINER_END_NAMESPACE

#endif /* IMPCONTAINER_LIST_SINGLETON_CONTAINER_H */
