// Autogenerated by ../../../../tmp/imp-20170413-27705-92djbr/imp-2.7.0/tools/build/make_containers.py
// from ../../../../tmp/imp-20170413-27705-92djbr/imp-2.7.0/tools/build/container_templates/kernel/ClassnameContainer.h
// Do not edit - any changes will be lost!

/**
 *  \file IMP/QuadContainer.h
 *  \brief A container for Quads.
 *
 *  Copyright 2007-2017 IMP Inventors. All rights reserved.
 */

#ifndef IMPKERNEL_QUAD_CONTAINER_H
#define IMPKERNEL_QUAD_CONTAINER_H

#include <IMP/kernel_config.h>
#include "internal/IndexingIterator.h"
#include "Particle.h"
#include "container_base.h"
#include "internal/container_helpers.h"
#include "DerivativeAccumulator.h"
#include "base_types.h"
#include <IMP/ref_counted_macros.h>
#include <IMP/check_macros.h>
#include <IMP/Pointer.h>
#include <IMP/InputAdaptor.h>
#include <IMP/utility_macros.h>
#include <IMP/deprecation_macros.h>
#include <algorithm>

IMPKERNEL_BEGIN_NAMESPACE
class QuadModifier;
class QuadScore;

//! A shared container for Quads
/** Stores a shared collection of Quads.
 */
class IMPKERNELEXPORT QuadContainer : public Container {
 public:
  typedef ParticleQuad ContainedType;
  typedef ParticleQuadsTemp ContainedTypes;
  typedef ParticleIndexQuads ContainedIndexTypes;
  typedef ParticleIndexQuad ContainedIndexType;
  typedef QuadModifier Modifier;
  typedef const ParticleIndexQuad& PassContainedIndexType;

  //! Just use apply() in the base class
  void apply_generic(const QuadModifier *m) const;

  //! Apply a SingletonModifier to the contents
  void apply(const QuadModifier *sm) const;

  /** Get all the indexes that might possibly be contained in the
      container, useful with dynamic containers. For example,
      with a container::ClosePairContainer, this is the list
      of all pairs taken from input list (those that are far apart
      in addition to those that are close).
  */
  virtual ParticleIndexQuads get_range_indexes() const = 0;

  const ParticleIndexQuads &get_contents() const {
    if (get_provides_access())
      return get_access();
    else {
      std::size_t nhash = get_contents_hash();
      if (contents_hash_ != nhash || !cache_initialized_) {
        contents_hash_ = nhash;
        cache_initialized_ = true;
        contents_cache_ = get_indexes();
      }
      return contents_cache_;
    }
  }

  /** Get all the indexes contained in the container.

    This should be protected but isn't for compatibility reasons.

    External callers should use get_contents().
  */
  virtual ParticleIndexQuads get_indexes() const = 0;

#ifndef IMP_DOXYGEN

  ParticleQuadsTemp get() const {
    return IMP::internal::get_particle(get_model(), get_indexes());
  }

  ParticleQuad get(unsigned int i) const {
    return IMP::internal::get_particle(get_model(), get_indexes()[i]);
  }
  unsigned int get_number() const { return get_indexes().size(); }
#ifndef SWIG
  bool get_provides_access() const;
  virtual const ParticleIndexQuads &get_access() const {
    IMP_THROW("Object not implemented properly.", IndexException);
  }

  template <class Functor>
  Functor for_each(Functor f) {
    ParticleIndexQuads vs = get_indexes();
    // use boost range instead
    return std::for_each(vs.begin(), vs.end(), f);
  }

#endif
#endif

  /** \deprecated_at{2.1} Use get_indexes() instead.
   */
  ParticleQuadsTemp get_particle_quads() const;

  /** \deprecated_at{2.1}Use get_indexes() instead and thing about using the
      IMP_CONTAINER_FOREACH() macro.*/
  IMPKERNEL_DEPRECATED_METHOD_DECL(2.1)
  ParticleQuad get_particle_quad(unsigned int i) const;

 protected:
  QuadContainer(Model *m,
                     std::string name = "QuadContainer %1%");

  virtual void do_apply(const QuadModifier *sm) const = 0;
  virtual bool do_get_provides_access() const { return false; }

  IMP_REF_COUNTED_NONTRIVIAL_DESTRUCTOR(QuadContainer);

 private:
  mutable std::size_t contents_hash_;
  mutable ParticleIndexQuads contents_cache_;
  mutable bool cache_initialized_;
};

/** This class allows either a list or a container to be
    accepted as input.
*/
class IMPKERNELEXPORT QuadContainerAdaptor :
#if !defined(SWIG) && !defined(IMP_DOXYGEN)
    public Pointer<QuadContainer>
#else
    public InputAdaptor
#endif
    {
  typedef Pointer<QuadContainer> P;

 public:
  QuadContainerAdaptor() {}

  /**
     Constructs the adaptor pointing to c (so if the contents of c are changed
     dynamically, so do the contents of the adaptor, and vice versa)
   */
  QuadContainerAdaptor(QuadContainer *c);

  /**
     Constructs the adaptor pointing to c (so if the contents of c are changed
     dynamically, so do the contents of the adaptor, and vice versa)
   */
  template <class C>
  QuadContainerAdaptor(IMP::internal::PointerBase<C> c)
      : P(c) {}

  /**
     Adapts the non-empty list t to QuadContainer

     @param t a non-empty list of ParticleQuadsTemp
  */
  QuadContainerAdaptor(const ParticleQuadsTemp &t);

  /** Set the name of the resulting container if it is currently the
      default value. */
  void set_name_if_default(std::string name);
};

IMPKERNEL_END_NAMESPACE

#endif /* IMPKERNEL_QUAD_CONTAINER_H */
