%include "IMP_domino.hdf5.i"
%include "IMP/domino/domino_macros.h"
namespace IMP {
namespace domino {
%warnfilter(473) AssignmentsTable;
%warnfilter(473) SubsetFilterTable;
%warnfilter(473,403) DiscreteSampler;
%warnfilter(403) DisjointSetsSubsetFilterTable;
}
}
%rename(_ParticlesAdaptor) IMP::domino::ParticlesAdaptor;

/* Tell swig how to treat various types when moving them to and from pyton */


IMP_SWIG_BASE_OBJECT(IMP::domino, DiscreteSampler, DiscreteSamplers);
IMP_SWIG_BASE_OBJECT(IMP::domino, ParticleStates, ParticleStatesList);
IMP_SWIG_BASE_OBJECT(IMP::domino, SubsetFilter, SubsetFilters);
IMP_SWIG_BASE_OBJECT(IMP::domino, SubsetFilterTable, SubsetFilterTables);
IMP_SWIG_BASE_OBJECT(IMP::domino, AssignmentsTable, AssignmentsTables);
IMP_SWIG_BASE_OBJECT(IMP::domino, AssignmentContainer, AssignmentContainers);
IMP_SWIG_GRAPH(IMP::domino, InteractionGraph, InteractionGraph, IMP::Particle*);
IMP_SWIG_GRAPH(IMP::domino, SubsetGraph, SubsetGraph, IMP::domino::Subset );
IMP_SWIG_GRAPH(IMP::domino, CliqueGraph, CliqueGraph, IMP::domino::Subset );
IMP_SWIG_GRAPH(IMP::domino, MergeTree, MergeTree, IMP::domino::Subset );
IMP_SWIG_OBJECT(IMP::domino, BranchAndBoundSampler, BranchAndBoundSamplers);
IMP_SWIG_OBJECT(IMP::domino, BranchAndBoundAssignmentsTable, BranchAndBoundAssignmentsTables);
IMP_SWIG_OBJECT(IMP::domino, RecursiveAssignmentsTable, RecursiveAssignmentsTables);
IMP_SWIG_OBJECT(IMP::domino, SimpleAssignmentsTable, SimpleAssignmentsTables);
IMP_SWIG_OBJECT(IMP::domino, CompoundStates, CompoundStatesList);
IMP_SWIG_OBJECT(IMP::domino, DisjointSetsSubsetFilterTable, DisjointSetsSubsetFilterTables);
IMP_SWIG_OBJECT(IMP::domino, MinimumRestraintScoreSubsetFilterTable, MinimumRestraintScoreSubsetFilterTables);
IMP_SWIG_OBJECT(IMP::domino, DominoSampler, DominoSamplers);
IMP_SWIG_OBJECT(IMP::domino, EqualitySubsetFilterTable, EqualitySubsetFilterTables);
IMP_SWIG_OBJECT(IMP::domino, EquivalenceSubsetFilterTable, EquivalenceSubsetFilterTables);
IMP_SWIG_OBJECT(IMP::domino, EquivalenceAndExclusionSubsetFilterTable, EquivalenceAndExclusionSubsetFilterTables);
IMP_SWIG_OBJECT(IMP::domino, ExclusionSubsetFilterTable, ExclusionSubsetFilterTables);
IMP_SWIG_OBJECT(IMP::domino, IndexStates, IndexStatesList);
IMP_SWIG_OBJECT(IMP::domino, ListSubsetFilterTable, ListSubsetFilterTables);
IMP_SWIG_OBJECT(IMP::domino, ListAssignmentsTable, ListAssignmentsTables);
IMP_SWIG_OBJECT(IMP::domino, ParticleStatesTable, ParticleStatesTables);
IMP_SWIG_OBJECT(IMP::domino, RecursiveStates, RecursiveStatesList);
IMP_SWIG_OBJECT(IMP::domino, ProbabilisticSubsetFilterTable, ProbabilisticSubsetFilterTables);
IMP_SWIG_OBJECT(IMP::domino, RestraintScoreSubsetFilterTable, RestraintScoreSubsetFilterTables);
IMP_SWIG_OBJECT(IMP::domino, RigidBodyStates, RigidBodyStatess);
IMP_SWIG_OBJECT(IMP::domino, XYZStates, XYZStatesList);
IMP_SWIG_OBJECT(IMP::domino, NestedRigidBodyStates, NestedRigidBodyStatesList);
IMP_SWIG_OBJECT(IMP::domino, DependencyScoreState, DependencyScoreStates);
IMP_SWIG_OBJECT(IMP::domino, PairListSubsetFilterTable, PairListSubsetFilterTables);
IMP_SWIG_OBJECT(IMP::domino, ListAssignmentContainer, ListAssignmentContainers);
IMP_SWIG_OBJECT(IMP::domino, PackedAssignmentContainer, PackedAssignmentContainers);
IMP_SWIG_OBJECT(IMP::domino, HeapAssignmentContainer, HeapAssignmentContainers);
IMP_SWIG_OBJECT(IMP::domino, RangeViewAssignmentContainer, RangeViewAssignmentContainers);
IMP_SWIG_OBJECT(IMP::domino, SampleAssignmentContainer, SampleAssignmentContainers);
IMP_SWIG_OBJECT(IMP::domino, PermutationStates, PermutationStatesList);
#ifdef IMP_DOMINO_USE_RMF
IMP_SWIG_OBJECT(IMP::domino, WriteHDF5AssignmentContainer, WriteHDF5AssignmentContainers);
IMP_SWIG_OBJECT(IMP::domino, ReadHDF5AssignmentContainer, ReadHDF5AssignmentContainers);
%{
#include <RMF.h>
%}
#endif
IMP_SWIG_OBJECT(IMP::domino, ReadAssignmentContainer, ReadAssignmentContainers);
IMP_SWIG_OBJECT(IMP::domino, WriteAssignmentContainer, WriteAssignmentContainers);
IMP_SWIG_OBJECT(IMP::domino, CappedAssignmentContainer, CappedAssignmentContainers);
IMP_SWIG_OBJECT(IMP::domino, RestraintCache, RestraintCaches);
IMP_SWIG_VALUE(IMP::domino, Subset, Subsets);
IMP_SWIG_VALUE(IMP::domino, Assignment, Assignments);
IMP_SWIG_VALUE(IMP::domino, Slice, Slices);
IMP_SWIG_VALUE(IMP::domino, Order, Orders);
%template(_IntArray) IMP::ConstVector<int>;
%template(_UIntArray) IMP::ConstVector<unsigned int>;
%template(_ParticleArray) IMP::ConstVector<IMP::WeakPointer<Particle>, Particle* >;

%include "IMP/domino/Subset.h"
%include "IMP/domino/Assignment.h"
%include "IMP/domino/Slice.h"
%include "IMP/domino/Order.h"
%include "IMP/domino/particle_states.h"
%include "IMP/domino/subset_scores.h"
%include "IMP/domino/subset_filters.h"
%include "IMP/domino/assignment_containers.h"
%include "IMP/domino/assignment_tables.h"
%include "IMP/domino/subset_graphs.h"
%include "IMP/domino/DiscreteSampler.h"
%include "IMP/domino/DominoSampler.h"
%include "IMP/domino/BranchAndBoundSampler.h"
%include "IMP/domino/utility.h"
%include "IMP/domino/interactive.h"
%include "IMP/domino/analysis.h"
%include "IMP/domino/DependencyScoreState.h"

%inline %{
IMP::IntsList _get_ints_list(const IMP::IntsList &input) {
return input;
}
%}
