// Autogenerated by ../../../../tmp/imp-20170410-74741-b3peny/imp-2.7.0/tools/build/make_containers.py
// from ../../../../tmp/imp-20170410-74741-b3peny/imp-2.7.0/tools/build/container_templates/kernel/ClassnameModifier.h
// Do not edit - any changes will be lost!

/**
 *  \file IMP/TripletModifier.h
 *  \brief A Modifier on ParticleTripletsTemp
 *
 *  Copyright 2007-2017 IMP Inventors. All rights reserved.
 */

#ifndef IMPKERNEL_TRIPLET_MODIFIER_H
#define IMPKERNEL_TRIPLET_MODIFIER_H

#include <IMP/kernel_config.h>
#include "DerivativeAccumulator.h"
#include "base_types.h"
#include "internal/container_helpers.h"
#include "model_object_helpers.h"

IMPKERNEL_BEGIN_NAMESPACE

//! A base class for modifiers of ParticleTripletsTemp
/** The primary function of such a class is to change
    the passed particles.

    \see IMP::TripletPredicate

    Implementers should see IMP_TRIPLET_MODIFIER(). Also see
    TripletDerivativeModifier.
 */
class IMPKERNELEXPORT TripletModifier : public ParticleInputs,
                                          public ParticleOutputs,
                                          public Object {
 public:
  typedef ParticleTriplet Argument;
  typedef ParticleIndexTriplet IndexArgument;
  TripletModifier(std::string name = "TripletModifier %1%");

  /** Apply the function to a single value*/
  virtual void apply_index(Model *m, const ParticleIndexTriplet& v) const = 0;

  /** Apply the function to a collection of ParticleTripletsTemp */
  /** If bounds are passed, only apply to ones between the upper and
      lower bounds.*/
  virtual void apply_indexes(Model *m, const ParticleIndexTriplets &o,
                             unsigned int lower_bound,
                             unsigned int upper_bound) const {
    for (unsigned int i = lower_bound; i < upper_bound; ++i) {
      apply_index(m, o[i]);
    }
  }
};

IMPKERNEL_END_NAMESPACE

#endif /* IMPKERNEL_TRIPLET_MODIFIER_H */
