// Autogenerated by ../../../../tmp/imp-20170206-36945-1x93gut/imp-2.6.2/tools/build/make_containers.py
// from ../../../../tmp/imp-20170206-36945-1x93gut/imp-2.6.2/tools/build/container_templates/core/classname_predicates.h
// Do not edit - any changes will be lost!

/**
 *  \file IMP/core/quad_predicates.h
 *  \brief Define some predicates.
 *
 *  Copyright 2007-2016 IMP Inventors. All rights reserved.
 */

#ifndef IMPCORE_QUAD_PREDICATES_H
#define IMPCORE_QUAD_PREDICATES_H

#include <IMP/core/core_config.h>
#include <IMP/QuadPredicate.h>
#include <IMP/quad_macros.h>
#include <boost/random.hpp>
#include "internal/container_helpers.h"

IMPCORE_BEGIN_NAMESPACE

/** Always return a constant value.
 */
class IMPCOREEXPORT ConstantQuadPredicate : public QuadPredicate {
  int v_;

 public:
  ConstantQuadPredicate(int v,
                             std::string name = "ConstQuadPredicate%1%");
  virtual int get_value_index(Model *, const ParticleIndexQuad&) const
      IMP_OVERRIDE {
    return v_;
  }
  virtual ModelObjectsTemp do_get_inputs(
      Model *, const ParticleIndexes &) const IMP_OVERRIDE {
    return ModelObjectsTemp();
  }
  IMP_QUAD_PREDICATE_METHODS(ConstantQuadPredicate);
  IMP_OBJECT_METHODS(ConstantQuadPredicate);
};

/** Return a unique predicate value for each unordered set of
   ParticleTypes
    (see Typed).
*/

class IMPCOREEXPORT UnorderedTypeQuadPredicate
    : public QuadPredicate {
 public:
  UnorderedTypeQuadPredicate(std::string name =
                                      "UnorderedTypeQuadPredicate%1%");
  virtual int get_value_index(Model *m, const ParticleIndexQuad& pi) const
      IMP_OVERRIDE {
    return internal::get_type_hash(m, pi);
  }
  virtual ModelObjectsTemp do_get_inputs(
      Model *m, const ParticleIndexes &pis) const IMP_OVERRIDE {
    ModelObjectsTemp ret;
    ret += IMP::get_particles(m, pis);
    return ret;
  }
  IMP_QUAD_PREDICATE_METHODS(UnorderedTypeQuadPredicate);
  IMP_OBJECT_METHODS(UnorderedTypeQuadPredicate);
};

/** Return a unique predicate value for each ordered quad of
    ParticleTypes (see Typed).
*/
class IMPCOREEXPORT OrderedTypeQuadPredicate : public QuadPredicate {
 public:
  OrderedTypeQuadPredicate(std::string name =
                                    "OrderedTypeQuadPredicate%1%");
#ifndef SWIG
  using QuadPredicate::get_value;
#endif
  int get_value(const core::ParticleTypes &types) {
    return internal::get_ordered_type_hash(types);
  }
  virtual int get_value_index(Model *m, const ParticleIndexQuad& pi) const
      IMP_OVERRIDE {
    return internal::get_ordered_type_hash(m, pi);
  }
  virtual ModelObjectsTemp do_get_inputs(
      Model *m, const ParticleIndexes &pis) const IMP_OVERRIDE {
    ModelObjectsTemp ret;
    ret += IMP::get_particles(m, pis);
    return ret;
  }
  IMP_QUAD_PREDICATE_METHODS(OrderedTypeQuadPredicate);
  IMP_OBJECT_METHODS(OrderedTypeQuadPredicate);
};

/** Return true if all members of the tuple are the same. */
class IMPCOREEXPORT AllSameQuadPredicate : public QuadPredicate {
 public:
  AllSameQuadPredicate(std::string name = "AllSameQuadPredicate%1%");
  virtual int get_value_index(Model *m, const ParticleIndexQuad& pi) const
      IMP_OVERRIDE {
    return internal::get_all_same(m, pi);
  }
  virtual ModelObjectsTemp do_get_inputs(
      Model *, const ParticleIndexes &) const IMP_OVERRIDE {
    return ModelObjectsTemp();
  }
  IMP_QUAD_PREDICATE_METHODS(AllSameQuadPredicate);
  IMP_OBJECT_METHODS(AllSameQuadPredicate);
};

/** Return true with a fixed probability. */
class IMPCOREEXPORT CoinFlipQuadPredicate : public QuadPredicate {
  double p_;
  mutable boost::uniform_real<double> rng_;

 public:
  CoinFlipQuadPredicate(double p, std::string name =
                                           "CoinFlipQuadPredicate%1%");
  virtual int get_value_index(Model *, const ParticleIndexQuad&) const
      IMP_OVERRIDE {
    if (rng_(random_number_generator) < p_)
      return 1;
    else
      return 0;
  }
  virtual ModelObjectsTemp do_get_inputs(
      Model *, const ParticleIndexes &) const IMP_OVERRIDE {
    return ModelObjectsTemp();
  }
  IMP_QUAD_PREDICATE_METHODS(CoinFlipQuadPredicate);
  IMP_OBJECT_METHODS(CoinFlipQuadPredicate);
};

IMPCORE_END_NAMESPACE

#endif /* IMPCORE_QUAD_PREDICATES_H */
