// Autogenerated by ../../../../tmp/imp-20170206-20398-jg6jzl/imp-2.6.2/tools/build/make_containers.py
// from ../../../../tmp/imp-20170206-20398-jg6jzl/imp-2.6.2/tools/build/container_templates/kernel/ClassnamePredicate.h
// Do not edit - any changes will be lost!

/**
 *  \file IMP/SingletonPredicate.h
 *  \brief Define SingletonPredicate.
 *
 *  Copyright 2007-2016 IMP Inventors. All rights reserved.
 */

#ifndef IMPKERNEL_SINGLETON_PREDICATE_H
#define IMPKERNEL_SINGLETON_PREDICATE_H

#include <IMP/kernel_config.h>
#include "base_types.h"
#include "DerivativeAccumulator.h"
#include "internal/container_helpers.h"
#include "model_object_helpers.h"

IMPKERNEL_BEGIN_NAMESPACE

//! Abstract predicate function
/** A predicate is a function which returns one of a discrete set of
    values (eg -1, 0, 1 depending on whether a value is negative, zero
    or positive). SingletonPredicates will evaluate the predicate for the passed
    particles.

    Implementers should check out IMP_SINGLETON_PREDICATE().
*/
class IMPKERNELEXPORT SingletonPredicate : public ParticleInputs,
                                           public Object {
 public:
  typedef Particle* Argument;
  typedef ParticleIndex IndexArgument;
  SingletonPredicate(std::string name = "SingletonPredicate %1%");
  /** \deprecated_at{2.1} Use the index based version.*/
  IMPKERNEL_DEPRECATED_METHOD_DECL(2.1)
  virtual int get_value(Particle* vt) const;

  /** \deprecated_at{2.1} Use the index based version.*/
  IMPKERNEL_DEPRECATED_METHOD_DECL(2.1)
  virtual Ints get_value(const ParticlesTemp &o) const;

#if !defined(IMP_DOXYGEN) && !defined(SWIG)
  virtual void remove_if_equal(Model *m, ParticleIndexes &ps,
                               int v) const;
  virtual void remove_if_not_equal(Model *m, ParticleIndexes &ps,
                                   int v) const;
#endif

  //! Compute the predicate and the derivative if needed.
  virtual int get_value_index(Model *m, ParticleIndex vt) const;

  //! Enable them to be use as functors
  /** But beware of slicing.
   */
  int operator()(Model *m, ParticleIndex vt) const {
    return get_value_index(m, vt);
  }

  virtual Ints get_value_index(Model *m,
                               const ParticleIndexes &o) const {
    Ints ret(o.size());
    for (unsigned int i = 0; i < o.size(); ++i) {
      ret[i] += get_value_index(m, o[i]);
    }
    return ret;
  }

  IMP_REF_COUNTED_DESTRUCTOR(SingletonPredicate);
};

IMPKERNEL_END_NAMESPACE

#endif /* IMPKERNEL_SINGLETON_PREDICATE_H */
