// Autogenerated by ../../../../tmp/imp-20170206-69263-1aegmwv/imp-2.6.2/tools/build/make_containers.py
// from ../../../../tmp/imp-20170206-69263-1aegmwv/imp-2.6.2/tools/build/container_templates/container/ClassnameContainerStatistics.h
// Do not edit - any changes will be lost!

/**
 *  \file IMP/container/SingletonContainerStatistics.h
 *  \brief A container for Singletons.
 *
 *  Copyright 2007-2016 IMP Inventors. All rights reserved.
 */

#ifndef IMPCONTAINER_SINGLETON_CONTAINER_STATISTICS_H
#define IMPCONTAINER_SINGLETON_CONTAINER_STATISTICS_H

#include <IMP/container/container_config.h>
#include <IMP/SingletonContainer.h>
#include <IMP/ScoreState.h>
#include <boost/unordered_set.hpp>

IMPCONTAINER_BEGIN_NAMESPACE

//! Track statistics on a SingletonContainer
/** The current statistics are average and min/max occupancy. Other
    statistics can be added on request, but we probably want to
    restrict it to ones that are cheap to gather. */
class IMPCONTAINEREXPORT SingletonContainerStatistics : public ScoreState {
  Pointer<SingletonContainer> container_;
  unsigned int total_;
  unsigned int checks_;
  unsigned int max_;
  unsigned int min_;
  bool track_unique_;
  boost::unordered_set<Particle*> unique_;

 public:
  SingletonContainerStatistics(SingletonContainerAdaptor c);
  void show_statistics(std::ostream &out) const;
  /** Keeping track of the number of unique entries seen is
      expensive, so it is not done by default.
  */
  void set_track_unique(bool tf);
  virtual void do_before_evaluate() IMP_OVERRIDE;
  virtual void do_after_evaluate(DerivativeAccumulator *da) IMP_OVERRIDE;
  virtual ModelObjectsTemp do_get_inputs() const IMP_OVERRIDE;
  virtual ModelObjectsTemp do_get_outputs() const IMP_OVERRIDE;
  IMP_OBJECT_METHODS(SingletonContainerStatistics);
};

IMPCONTAINER_END_NAMESPACE

#endif /* IMPCONTAINER_SINGLETON_CONTAINER_STATISTICS_H */
