// Autogenerated by ../../../../tmp/imp-20170206-69263-1aegmwv/imp-2.6.2/tools/build/make_containers.py
// from ../../../../tmp/imp-20170206-69263-1aegmwv/imp-2.6.2/tools/build/container_templates/kernel/ClassnameModifier.h
// Do not edit - any changes will be lost!

/**
 *  \file IMP/SingletonModifier.h
 *  \brief A Modifier on ParticlesTemp
 *
 *  Copyright 2007-2016 IMP Inventors. All rights reserved.
 */

#ifndef IMPKERNEL_SINGLETON_MODIFIER_H
#define IMPKERNEL_SINGLETON_MODIFIER_H

#include <IMP/kernel_config.h>
#include "DerivativeAccumulator.h"
#include "base_types.h"
#include "internal/container_helpers.h"
#include "model_object_helpers.h"

IMPKERNEL_BEGIN_NAMESPACE

//! A base class for modifiers of ParticlesTemp
/** The primary function of such a class is to change
    the passed particles.

    \see IMP::SingletonPredicate

    Implementers should see IMP_SINGLETON_MODIFIER(). Also see
    SingletonDerivativeModifier.
 */
class IMPKERNELEXPORT SingletonModifier : public ParticleInputs,
                                          public ParticleOutputs,
                                          public Object {
 public:
  typedef Particle* Argument;
  typedef ParticleIndex IndexArgument;
  SingletonModifier(std::string name = "SingletonModifier %1%");

  /** Apply the function to a single value*/
  virtual void apply_index(Model *m, ParticleIndex v) const = 0;

  /** Apply the function to a collection of ParticlesTemp */
  /** If bounds are passed, only apply to ones between the upper and
      lower bounds.*/
  virtual void apply_indexes(Model *m, const ParticleIndexes &o,
                             unsigned int lower_bound,
                             unsigned int upper_bound) const {
    for (unsigned int i = lower_bound; i < upper_bound; ++i) {
      apply_index(m, o[i]);
    }
  }
};

IMPKERNEL_END_NAMESPACE

#endif /* IMPKERNEL_SINGLETON_MODIFIER_H */
