/* Ignore things to prevent SWIG warning about them */
namespace IMP {
  namespace em {
    %ignore DensityMap::operator =;
  }
}
%ignore operator<<(std::ostream&, const DensityHeader &);

/* Make selected classes extensible in Python */
IMP_SWIG_OBJECT(IMP::em, DensityMap, DensityMaps);
IMP_SWIG_OBJECT(IMP::em, SampledDensityMap, SampledDensityMaps);
IMP_SWIG_OBJECT(IMP::em, SurfaceShellDensityMap, SurfaceShellDensityMaps);
IMP_SWIG_OBJECT(IMP::em, FitRestraint, FitRestraints);
IMP_SWIG_OBJECT(IMP::em, PCAFitRestraint, PCAFitRestraints);
IMP_SWIG_OBJECT(IMP::em, EnvelopePenetrationRestraint, EnvelopePenetrationRestraints);
IMP_SWIG_OBJECT(IMP::em, EnvelopeFitRestraint, EnvelopeFitRestraints);
IMP_SWIG_VALUE(IMP::em, KernelParameters, KernelParametersList);
IMP_SWIG_OBJECT(IMP::em, HighDensityEmbedding, HighDensityEmbeddings);
IMP_SWIG_OBJECT(IMP::em, MapReaderWriter, MapReaderWriters);
IMP_SWIG_OBJECT(IMP::em, MRCReaderWriter, MRCReaderWriters);
IMP_SWIG_OBJECT(IMP::em, SpiderMapReaderWriter, SpiderMapReaderWriters);
IMP_SWIG_OBJECT(IMP::em, EMReaderWriter, EMReaderWriters);
IMP_SWIG_OBJECT(IMP::em, XplorReaderWriter, XplorReaderWriters);
IMP_SWIG_OBJECT(IMP::em, CoarseCC, CoarseCCs);
IMP_SWIG_OBJECT(IMP::em, CoarseCCatIntervals, CoarseCCatIntervalsList);
IMP_SWIG_VALUE(IMP::em, FittingSolutions, FittingSolutionsList);

/* Since DensityHeaders are not values or Objects, we must ensure that whenever
   pointers to them are returned to Python, the object that manages the header's
   storage (usually a DensityMap) must be kept alive so that the header is not
   prematurely freed. (They cannot be Objects, since the EM code relies on
   their memory layout, and cannot be values, since it uses them to modify
   existing map objects.) */
namespace IMP {
 namespace em {
  // Note that since SWIG does not preserve const-correctness, get_header()
  // and get_header_writable() are essentially equivalent
  %feature("shadow") DensityMap::get_header() const %{
    def get_header(self):
        h = _IMP_em.DensityMap_get_header(self)
        h._owner = self
        return h
  %}
  %feature("shadow") DensityMap::get_header_writable() %{
    def get_header_writable(self):
        h = _IMP_em.DensityMap_get_header_writable(self)
        h._owner = self
        return h
  %}
 }
}

/* Convert return value from CoarseCCatIntervals::evaluate into useful
   Python objects */
%typemap(out) std::pair<double,IMP::algebra::Vector3Ds> (PyObject *temp1, PyObject *temp2) {
  $result = PyTuple_New(2);
  temp1 = PyFloat_FromDouble($1.first);
  temp2 = ConvertSequence<IMP::algebra::Vector3Ds, Convert< IMP::algebra::Vector3D> >::create_python_object(ValueOrObject<IMP::algebra::Vector3Ds>::get($1.second), $descriptor(IMP::algebra::Vector3D*), SWIG_POINTER_OWN);
  PyTuple_SET_ITEM($result, 0, temp1);
  PyTuple_SET_ITEM($result, 1, temp2);
}

/* Wrap our own classes */
%include "IMP/em/def.h"
%include "IMP/em/MapReaderWriter.h"
%include "IMP/em/DensityHeader.h"
%include "IMP/em/DensityMap.h"
%include "IMP/em/masking.h"
%include "IMP/em/EMReaderWriter.h"
%include "IMP/em/XplorReaderWriter.h"
%include "IMP/em/MRCReaderWriter.h"
%include "IMP/em/KernelParameters.h"
%include "IMP/em/SampledDensityMap.h"
%include "IMP/em/SurfaceShellDensityMap.h"
%include "IMP/em/CoarseCC.h"
%include "IMP/em/CoarseConvolution.h"
%include "IMP/em/CoarseCCatIntervals.h"
%include "IMP/em/FitRestraint.h"
%include "IMP/em/converters.h"
%include "IMP/em/SpiderHeader.h"
%include "IMP/em/ImageHeader.h"
%include "IMP/em/SpiderReaderWriter.h"
%include "IMP/em/rigid_fitting.h"
%include "IMP/em/envelope_penetration.h"
%include "IMP/em/embedding.h"
%include "IMP/em/density_utilities.h"
%include "IMP/em/density_map_volumetrics.h"
%include "IMP/em/EnvelopePenetrationRestraint.h"
%include "IMP/em/PCAFitRestraint.h"
%include "IMP/em/EnvelopeFitRestraint.h"

/* Allow runtime casting of Restraint* objects to FitRestraint* */
namespace IMP {
  namespace em {
    %extend FitRestraint {
      static FitRestraint* cast(Restraint *r) {
        return dynamic_cast<IMP::em::FitRestraint *>(r);
      }
    }
  }
}

%pythoncode %{
import math

def write_pca_cmm(pca, fh):
    """Write out principal components to a file in Chimera Marker format"""
    eigen_values = pca.get_principal_values()
    eigen_vecs = pca.get_principal_components()
    centroid = pca.get_centroid()

    fh.write("<marker_set>\n")
    fh.write("<!-- PCA with eigen values: (%g,%g,%g) and "
                 "centroid (%g,%g,%g) -->\n"
          % (math.sqrt(eigen_values[0]),
             math.sqrt(eigen_values[1]),
             math.sqrt(eigen_values[2]),
             centroid[0], centroid[1], centroid[2]))

    radius = 2.

    for i in range(3):
        val = math.sqrt(eigen_values[i])
        v1 = centroid - val * eigen_vecs[i]
        v2 = centroid + val * eigen_vecs[i]
        for markerid, v in ((i*2+1, v1), (i*2+2, v2)):
            fh.write("<marker id=\"%d\" x=\"%g\" y=\"%g\" z=\"%g\" "
                         "radius=\"%g\"/>\n"
                  % (markerid, v[0], v[1], v[2], radius))

    for i in range(1, 7, 2):
        fh.write("<link id1= \"%d\" id2=\"%d\" radius=\"%g\"/>\n"
              % (i, i+1, radius))
    fh.write("</marker_set>\n")
%}
