// Autogenerated by ../../../../tmp/imp-20170112-15768-muyj9b/imp-2.6.2/tools/build/make_containers.py
// from ../../../../tmp/imp-20170112-15768-muyj9b/imp-2.6.2/tools/build/container_templates/container/ClassnamesRestraint.h
// Do not edit - any changes will be lost!

/**
 *  \file IMP/container/QuadsRestraint.h
 *  \brief Apply a QuadScore to each Quad in a list.
 *
 *  Copyright 2007-2016 IMP Inventors. All rights reserved.
 *
 */

#ifndef IMPCONTAINER_QUADS_RESTRAINT_H
#define IMPCONTAINER_QUADS_RESTRAINT_H

#include <IMP/container/container_config.h>
#include <IMP/internal/ContainerRestraint.h>
#include <IMP/QuadContainer.h>
#include <IMP/QuadScore.h>

IMPCONTAINER_BEGIN_NAMESPACE

//! Applies a QuadScore to each Quad in a list.
/** This restraint stores the used particle indexes in a ParticleIndexQuads.
    The container used can be set so that the list can be shared
    with other containers (or a nonbonded list can be used).

    Examples using various multiplicity containers:
    \include restrain_in_sphere.py
    \include nonbonded_interactions.py

    \see IMP::core::QuadRestraint
 */
class QuadsRestraint :
#if defined(SWIG) || defined(IMP_DOXYGEN)
    public Restraint
#else
    public IMP::internal::ContainerRestraint<QuadScore, QuadContainer>
#endif
    {
  typedef IMP::internal::ContainerRestraint<
      QuadScore, QuadContainer> P;

 public:
  //! Create the restraint with a shared container
  /** \param[in] ss The function to apply to each particle.
      \param[in] pc The container containing the stored particles. This
      container is not copied.
      \param[in] name The object name
   */
  QuadsRestraint(QuadScore *ss, QuadContainerAdaptor pc,
                      std::string name = "QuadsRestraint %1%")
      : P(ss, pc, name) {}

#if defined(IMP_DOXYGEN) || defined(SWIG)
  double unprotected_evaluate(IMP::DerivativeAccumulator *accum) const;
  IMP::ModelObjectsTemp do_get_inputs() const;
  IMP_OBJECT_METHODS(QuadsRestraint)
#endif
};

IMP_OBJECTS(QuadsRestraint, QuadsRestraints);

IMPCONTAINER_END_NAMESPACE

#endif /* IMPCONTAINER_QUADS_RESTRAINT_H */
