// Autogenerated by ../../../../tmp/imp20160323-65083-14xsrb9/imp-2.6.0/tools/build/make_containers.py
// from ../../../../tmp/imp20160323-65083-14xsrb9/imp-2.6.0/tools/build/container_templates/kernel/ClassnameScore.h
// Do not edit - any changes will be lost!

/**
 *  \file IMP/SingletonScore.h
 *  \brief Define SingletonScore.
 *
 *  Copyright 2007-2016 IMP Inventors. All rights reserved.
 */

#ifndef IMPKERNEL_SINGLETON_SCORE_H
#define IMPKERNEL_SINGLETON_SCORE_H

#include <IMP/kernel_config.h>
#include "base_types.h"
#include "DerivativeAccumulator.h"
#include "internal/container_helpers.h"
#include <IMP/utility_macros.h>
#include "model_object_helpers.h"

IMPKERNEL_BEGIN_NAMESPACE

//! Abstract class for scoring object(s) of type ParticleIndex.
/** SingletonScore will evaluate the score and derivatives
    for passed object(s) of type ParticleIndex.

    Use in conjunction with various
    restraints such as IMP::container::SingletonsRestraint or
    IMP::core::SingletonRestraint. The restraints couple the score
    functions with appropriate lists of object(s) of type ParticleIndex.

    Implementers should check out IMP_SINGLETON_SCORE().

    \see PredicateSingletonRestraint
*/
class IMPKERNELEXPORT SingletonScore : public ParticleInputs,
                                       public Object {
 public:
  typedef Particle* Argument;
  typedef ParticleIndex IndexArgument;
  typedef Particle* PassArgument;
  typedef ParticleIndex PassIndexArgument;
  typedef SingletonModifier Modifier;
  SingletonScore(std::string name = "SingletonScore %1%");

  //! Compute the score and the derivative if needed.
  /** @param m the model of vt
      @param vt the index in m of an object of type Particle
      @param da a DerivativeAccumulator that weights
                computed derivatives. If nullptr, derivatives
                will not be computed.
   */
  virtual double evaluate_index(Model *m, ParticleIndex vt,
                                DerivativeAccumulator *da) const = 0;

  //! Compute the score and the derivative if needed over a set.
  /** @param m the model of o
      @param o objects of type Particle, specified by index
      @param da a derivative accumulator that weights
                computed derivatives. If nullptr, derivatives
                will not be computed.
      @param lower_bound index of first item in o to evaluate
      @param upper_bound index of last item in o to evaluate

      @note Implementations for these are provided by
            the IMP_SINGLETON_SCORE() macro.
  */
  virtual double evaluate_indexes(Model *m, const ParticleIndexes &o,
                                  DerivativeAccumulator *da,
                                  unsigned int lower_bound,
                                  unsigned int upper_bound) const;

  //! Compute the score and the derivative if needed, only if "good".
  /** This functions similarly to evaluate_index(),
      but may terminate the computation early if the score is higher than max.

      @return the score if score<= max or some arbitrary value > max otherwise.
  */
  virtual double evaluate_if_good_index(Model *m, ParticleIndex vt,
                                        DerivativeAccumulator *da,
                                        double max) const;

  /** Compute the score and the derivative if needed over a set, only if "good".
      This functions similarly to evaluate_indexes(), but may terminate
      the computation early if the total score is higher than max.

      @return the score if score<= max or some arbitrary value > max otherwise.

      @note Implementations for these are provided by the IMP_SINGLETON_SCORE()
            macro.
  */
  virtual double evaluate_if_good_indexes(Model *m,
                                          const ParticleIndexes &o,
                                          DerivativeAccumulator *da, double max,
                                          unsigned int lower_bound,
                                          unsigned int upper_bound) const;

  //! Decompose this pair score acting on the pair into a set of restraints.
  /** The scoring function and derivatives should
      be equal to the current score. The default implementation
      just returns this object bound to the pair. */
  Restraints create_current_decomposition(Model *m,
                                          ParticleIndex vt) const;

 protected:
  //! Overide this to return your own decomposition.
  virtual Restraints do_create_current_decomposition(Model *m,
                                                     ParticleIndex vt) const;

  IMP_REF_COUNTED_DESTRUCTOR(SingletonScore);
};

IMPKERNEL_END_NAMESPACE

#endif /* IMPKERNEL_SINGLETON_SCORE_H */
