Chimera tools and web services {#web_services}
==============================

These tools use part of %IMP to tackle some modeling problems.
They are the simplest to use because they do not require an %IMP installation.

# Chimera tools

The [UCSF Chimera](http://www.cgl.ucsf.edu/chimera/) software includes
several tools that use %IMP:

 - [Small-Angle X-Ray Profile](http://www.cgl.ucsf.edu/chimera/current/docs/ContributedSoftware/saxs/saxs.html): calculate a theoretical small-angle X-ray scattering (SAXS) profile from a set of atoms
 - [MultiFit](http://www.cgl.ucsf.edu/chimera/current/docs/ContributedSoftware/multifit/multifit.html): perform simultaneous rigid fitting of multiple atomic-resolution structures into density maps at resolutions as low as 25 Å.

In addition, UCSF Chimera is able to read [RMF files](http://integrativemodeling.org/rmf/)
generated by %IMP.

# Web services
We provide a number of web services that use %IMP:

 - [AllosMod](http://salilab.org/allosmod/): modeling of ligand-induced
   protein dynamics and beyond
 - [FoXS](http://salilab.org/foxs/): fast SAXS profile computation with Debye
   formula
 - [AllosMod-FoXS](http://salilab.org/allosmod-foxs/): structure generation
   and SAXS profile calculations, combining the AllosMod and FoXS servers
 - [FoXSDock](http://salilab.org/foxsdock/): macromolecular docking with
   SAXS profile
 - [SAXS Merge](http://salilab.org/saxsmerge/): an automated statistical
   method to merge SAXS profiles from different concentrations and
   exposure times
 - [Pose & Rank](http://salilab.org/poseandrank/): scoring of protein-ligand
   complexes
