Stage 3 - Sampling {#rnapolii_3}
==================

With the system representation built and data restraints entered, the system is now ready to sample configurations.  A replica exchange run can be set up using the [ReplicaExchange0](@ref IMP::pmi::macros::ReplicaExchange0) macro:

\code{.py}
mc1=IMP.pmi.macros.ReplicaExchange0(m,
                                    representation,
                                    monte_carlo_sample_objects=sampleobjects,
                                    output_objects=outputobjects,
                                    crosslink_restraints=[xl1,xl2],
                                    monte_carlo_temperature=1.0,
                                    simulated_annealing=True,
                                    simulated_annealing_minimum_temperature=1.0,
                                    simulated_annealing_maximum_temperature=2.5,
                                    simulated_annealing_minimum_temperature_nframes=200,
                                    simulated_annealing_maximum_temperature_nframes=20,
                                    replica_exchange_minimum_temperature=1.0,
                                    replica_exchange_maximum_temperature=2.5,
                                    number_of_best_scoring_models=100,
                                    monte_carlo_steps=num_mc_steps,
                                    number_of_frames=num_frames,
                                    global_output_directory="output")
\endcode

See the [ReplicaExchange0 documentation](@ref IMP::pmi::macros::ReplicaExchange0.__init__)
for a full description of all of the input parameters.

The sampling is performed by executing the macro built above:

\code{.py}
mc1.execute_macro()
\endcode

### Sampling Output

The script generates an `output` directory containing the following:
* `pdbs`: a directory containing the 100 best-scoring models (see the `number_of_best_scoring_models` variable above) from the run, in PDB format.
* `rmfs`: a single [RMF file](http://integrativemodeling.org/rmf/) containing all the frames. RMF is a file format specially designed to store coarse-grained, multi-resolution and multi-state models such as those generated by %IMP. It is a compact binary format and (as in this case) can also be used to store multiple models or trajectories.
* Statistics from the sampling, contained in a "statfile", `stat.*.out`.  This file contains information on each restraint, MC acceptance criteria and other things at each step. 

**Gathering Data from statfile**  
Data from the stat file can be parsed and analyzed using two utilities: 
* `process_output.py` - parses the statfile and returns columns of interest
* `plot_stat.sh` - plots one or two columns of data (requires [gnuplot](http://www.gnuplot.info/download.html)) 

`process_output.py` usage:

\code{.sh}
IMP_HOME/modules/pmi/pyext/process_output.py [-h] [-f FILENAME] [-s FIELDS [FIELDS ...]]
                                             [-t SINGLE_COLUMN_FIELD] [-p] [--head]
                                             [-n PRINT_RAW_NUMBER] [--soft]
                                             [--search_field SEARCH_FIELD]
                                             [--search_value SEARCH_VALUE] [--nframe]
\endcode

`plot_stat.sh` usage: 
\code{.sh}
IMP_HOME/modules/pmi/pyext/plot_stat.sh -i STATFILE -y YCOLUMN [-x XCOLUMN] [-m POINTS] [-plot] [-o OUTPUTFILE] [-b BEGIN]
#
# -i | input stat file name 
# -y | column number with Y data values OR column header string 
# -x | column number with X data values OR column header string 
# -m | method of plotting. POINTS, LINES or LINESPOINTS 
# -s | suppress showing plot 
# -o | saves plot to png file with column header names 
# -b | begin at this frame number 
# -g | saves gnuplot file 
# -h | prints this help text to screen 
\endcode

---

Analysis of the sampled models is described in \ref rnapolii_4.
