

IMP_SWIG_BASE_OBJECT(IMP::display, Writer, Writers);
IMP_SWIG_BASE_OBJECT(IMP::display, TextWriter, TextWriters);
IMP_SWIG_BASE_OBJECT(IMP::display, Geometry, Geometries);
IMP_SWIG_OBJECT(IMP::display, SingletonGeometry, SingletonGeometries);
IMP_SWIG_OBJECT(IMP::display, PairGeometry, PairGeometries);
IMP_SWIG_OBJECT(IMP::display, SingletonsGeometry, SingletonsGeometries);
IMP_SWIG_OBJECT(IMP::display, PairsGeometry, PairsGeometries);
IMP_SWIG_OBJECT(IMP::display, ChimeraWriter, ChimeraWriters);
IMP_SWIG_OBJECT(IMP::display, PymolWriter, PymolWriters);
IMP_SWIG_OBJECT(IMP::display, SphereGeometry, SphereGeometries);
IMP_SWIG_OBJECT(IMP::display, CylinderGeometry, CylinderGeometries);
IMP_SWIG_OBJECT(IMP::display, EllipsoidGeometry, EllipsoidGeometries);
IMP_SWIG_OBJECT(IMP::display, PointGeometry, PointGeometries);
IMP_SWIG_OBJECT(IMP::display, SegmentGeometry, SegmentGeometries);
IMP_SWIG_OBJECT(IMP::display, PolygonGeometry, PolygonGeometries);
IMP_SWIG_OBJECT(IMP::display, ReferenceFrameGeometry, ReferenceFrameGeometries);
IMP_SWIG_OBJECT(IMP::display, BoundingBoxGeometry, BoundingBoxGeometries);
IMP_SWIG_OBJECT(IMP::display, LabelGeometry, LabelGeometries);
IMP_SWIG_OBJECT(IMP::display, RestraintGeometry, RestraintGeometries);
IMP_SWIG_OBJECT(IMP::display, RestraintSetGeometry, RestraintSetGeometries);
IMP_SWIG_OBJECT(IMP::display, GeometrySet, GeometrySets);
IMP_SWIG_DECORATOR(IMP::display, Colored, Coloreds);
IMP_SWIG_VALUE(IMP::display, Color, Colors);
IMP_SWIG_VALUE(IMP::display, WriterAdaptor, WriterAdaptors);
IMP_SWIG_OBJECT(IMP::display, FilterGeometry, FilterGeometries);
IMP_SWIG_OBJECT(IMP::display, WriteOptimizerState, WriteOptimizerStates);
//IMP_SWIG_OBJECT(IMP::display, WriteFailureHandler, WriteFailureHandlers);
IMP_SWIG_OBJECT(IMP::display, TriangleGeometry, TriangleGeometries);
IMP_SWIG_OBJECT(IMP::display, SurfaceMeshGeometry, SurfaceMeshGeometries);

#ifdef IMP_DISPLAY_USE_IMP_CGAL
IMP_SWIG_OBJECT(IMP::display, PlaneGeometry, PlaneGeometries);
IMP_SWIG_OBJECT(IMP::display, IsosurfaceGeometry, IsosurfaceGeometries);
IMP_SWIG_OBJECT(IMP::display, SkinSurfaceGeometry, SkinSurfaceGeometries);
#endif

%warnfilter(403) Geometry;
%warnfilter(403) Writer;
%warnfilter(403) SingletonGeometry;
%warnfilter(403) SingletonsGeometry;
%warnfilter(403) PairGeometry;
%warnfilter(403) PairsGeometry;
%warnfilter(403) TextWriter;


/* Wrap our own classes */
%include "IMP/display/geometry_macros.h"
%include "IMP/display/writer_macros.h"
%include "IMP/display/Color.h"
%include "IMP/display/declare_Geometry.h"
%include "IMP/display/GeometrySet.h"
%include "IMP/display/primitive_geometries.h"
%include "IMP/display/GeometryProcessor.h"
%include "IMP/display/Writer.h"

%include "IMP/display/ChimeraWriter.h"
%include "IMP/display/Colored.h"
%include "IMP/display/FilterGeometry.h"
%include "IMP/display/LogOptimizerState.h"
%include "IMP/display/particle_geometry.h"
%include "IMP/display/PymolWriter.h"
%include "IMP/display/restraint_geometry.h"

%pythoncode %{
from . import _pivy
PivyWriter= _pivy.get_writer(Writer)
_object_types.append('PivyWriter')
%}
