%{
#include <IMP/internal/range.h>
%}

%include "IMP/algebra/geometric_primitive_macros.h"
%include "IMP_algebra.types.i"
%pythoncode %{
def get_vector(v):
   try:
      return v.get_coordinates()
   except:
      return v
def get_sphere(v):
   try:
      return v.get_sphere()
   except:
      return v
%}

IMP_SWIG_BASE_OBJECT(IMP::algebra, VectorKDMetric, VectorKDMetrics);
IMP_SWIG_EIGEN_MATRIX(MatrixXf);
IMP_SWIG_EIGEN_MATRIX(MatrixXd);
IMP_SWIG_EIGEN_MATRIX(Matrix3d);
IMP_SWIG_EIGEN_VECTOR(VectorXd);
IMP_SWIG_EIGEN_VECTOR(VectorXf);
IMP_SWIG_EIGEN_VECTOR(Vector3d);
IMP_SWIG_EIGEN_MATRIX(ArrayXXf);
IMP_SWIG_EIGEN_MATRIX(ArrayXXd);
IMP_SWIG_OBJECT(IMP::algebra, EuclideanVectorKDMetric, EuclideanVectorKDMetrics);
IMP_SWIG_OBJECT(IMP::algebra, MaxVectorKDMetric, MaxVectorKDMetrics);
IMP_SWIG_OBJECT(IMP::algebra, DynamicNearestNeighbor3D, DynamicNearestNeighbor3Ds);

IMP_SWIG_VALUE(IMP::algebra, Rotation2D, Rotation2Ds);
IMP_SWIG_VALUE(IMP::algebra, Rotation3D, Rotation3Ds);
IMP_SWIG_VALUE(IMP::algebra, Reflection3D, Reflection3Ds);
IMP_SWIG_VALUE(IMP::algebra, Transformation2D, Transformation2Ds);
IMP_SWIG_VALUE(IMP::algebra, Transformation3D, Transformation3Ds);
IMP_SWIG_VALUE(IMP::algebra, SphericalVector3D, SphericalVector3Ds);
IMP_SWIG_VALUE(IMP::algebra, Triangle3D, Triangle3Ds);

IMP_SWIG_VALUE(IMP::algebra,  Cone3D, Cone3Ds);
IMP_SWIG_VALUE(IMP::algebra,  Cylinder3D, Cylinder3Ds);
IMP_SWIG_VALUE(IMP::algebra,  Ellipsoid3D, Ellipsoid3Ds);
IMP_SWIG_VALUE(IMP::algebra,  Plane3D, Plane3Ds);
IMP_SWIG_VALUE(IMP::algebra,  Segment3D, Segment3Ds);
IMP_SWIG_VALUE(IMP::algebra,  SpherePatch3D, SpherePatch3Ds);
IMP_SWIG_VALUE(IMP::algebra,  ConnollySurfacePoint, ConnollySurfacePoints);

// we seem to need the non-typedefed name, at least for the first argument
IMP_SWIG_ALGEBRA_VALUE_D(IMP::algebra,  Sphere);
IMP_SWIG_ALGEBRA_VALUE_D(IMP::algebra,  BoundingBox);
IMP_SWIG_ALGEBRA_VALUE_D(IMP::algebra,  PrincipalComponentAnalysis);
IMP_SWIG_ALGEBRA_OBJECT_D(IMP::algebra,  NearestNeighbor);
IMP_SWIG_VALUE(IMP::algebra,  ReferenceFrame3D, ReferenceFrame3Ds);
IMP_SWIG_VALUE(IMP::algebra, Gaussian3D, Gaussian3Ds);

IMP_SWIG_ALGEBRA_VALUE_D(IMP::algebra,  DefaultEmbedding);
IMP_SWIG_ALGEBRA_VALUE_D(IMP::algebra,  LogEmbedding);
IMP_SWIG_ALGEBRA_VALUE_D(IMP::algebra,  GridIndex);
IMP_SWIG_ALGEBRA_VALUE_D(IMP::algebra,  ExtendedGridIndex);
IMP_SWIG_ALGEBRA_VALUE_D(IMP::algebra,  BoundedGridRange);
IMP_SWIG_ALGEBRA_VALUE_D(IMP::algebra,  UnboundedGridRange);
IMP_SWIG_VALUE(IMP::algebra, LinearFit2D, LinearFit2Ds);
IMP_SWIG_VALUE(IMP::algebra, ParabolicFit2D, ParabolicFit2Ds);
IMP_SWIG_VALUE(IMP::algebra, FixedXYZ, FixedXYZs);

namespace boost {
template <class T, int D> class multi_array{};

namespace multi_array_types {
  typedef size_t size_type;
  typedef size_t difference_type;
}
}




/* to extend */
%include "IMP/algebra/GeometricPrimitiveD.h"
%template(_GeometricPrimitive1D) IMP::algebra::GeometricPrimitiveD<1>;
%template(_GeometricPrimitive2D) IMP::algebra::GeometricPrimitiveD<2>;
%template(_GeometricPrimitive3D) IMP::algebra::GeometricPrimitiveD<3>;
%template(_GeometricPrimitive4D) IMP::algebra::GeometricPrimitiveD<4>;
%template(_GeometricPrimitive5D) IMP::algebra::GeometricPrimitiveD<5>;
%template(_GeometricPrimitive6D) IMP::algebra::GeometricPrimitiveD<6>;
%template(_GeometricPrimitiveKD) IMP::algebra::GeometricPrimitiveD<-1>;

%include "IMP_algebra.bounding_box.i"
%include "IMP_algebra.vector.i"
%include "IMP_algebra.transformation2d.i"
%include "IMP_algebra.transformation3d.i"
%include "IMP_algebra.segment3d.i"

/* Wrap our own classes */
%include "IMP/algebra/VectorBaseD.h"
namespace IMP {
 namespace algebra {
   %template(_VectorBaseKD) VectorBaseD<-1>;
   %template(_VectorBase1D) VectorBaseD<1>;
   %template(_VectorBase2D) VectorBaseD<2>;
   %template(_VectorBase3D) VectorBaseD<3>;
   %template(_VectorBase4D) VectorBaseD<4>;
   %template(_VectorBase5D) VectorBaseD<5>;
   %template(_VectorBase6D) VectorBaseD<6>;
 }
}
%include "IMP/algebra/VectorD.h"
%include "IMP/algebra/Vector2D.h"
%include "IMP/algebra/Vector3D.h"
// to transform bbs
%include "IMP/algebra/Rotation3D.h"
%include "IMP/algebra/BoundingBoxD.h"
%include "IMP/algebra/Transformation3D.h"
%include "IMP/algebra/Rotation2D.h"
%include "IMP/algebra/Transformation2D.h"
%include "IMP/algebra/SphereD.h"
%include "IMP/algebra/Sphere3D.h"

IMP_SWIG_ALGEBRA_TEMPLATE_D(IMP::algebra, Vector);
IMP_SWIG_ALGEBRA_TEMPLATE_D(IMP::algebra, BoundingBox);
IMP_SWIG_ALGEBRA_TEMPLATE_D(IMP::algebra, Sphere);


%include "IMP/algebra/ReferenceFrame3D.h"

%include "IMP_algebra.spherical_coords.i"
%include "IMP/algebra/eigen_analysis.h"
%include "IMP/algebra/Segment3D.h"
%include "IMP/algebra/Triangle3D.h"
%include "IMP/algebra/LinearFit.h"
%include "IMP/algebra/ParabolicFit.h"
%include "IMP/algebra/Plane3D.h"
%include "IMP/algebra/Reflection3D.h"
%include "IMP/algebra/Cylinder3D.h"
%include "IMP/algebra/Ellipsoid3D.h"
%include "IMP/algebra/connolly_surface.h"

%include "IMP/algebra/grid_indexes.h"
%include "IMP/algebra/grid_ranges.h"
%include "IMP/algebra/grid_storages.h"
%include "IMP/algebra/grid_embeddings.h"
%include "IMP/algebra/grid_utility.h"
%include "IMP/algebra/GridD.h"
IMP_ALGEBRA_SWIG_GRID(IMP::algebra::DenseGrid3D, 3);
IMP_ALGEBRA_SWIG_GRID(IMP::algebra::SparseGrid3D, 3);
IMP_ALGEBRA_SWIG_GRID(IMP::algebra::SparseUnboundedGrid3D, 3);
IMP_ALGEBRA_SWIG_GRID(IMP::algebra::SparseUnboundedGridD, -1);
IMP_ALGEBRA_SWIG_GRID(IMP::algebra::DenseIntLogGrid3D, 3);
IMP_ALGEBRA_SWIG_GRID(IMP::algebra::DenseFloatLogGridKD, -1);
%template(LogEmbedding3D) IMP::algebra::LogEmbeddingD<3>;
%template(LogEmbeddingKD) IMP::algebra::LogEmbeddingD<-1>;

%include "IMP/algebra/standard_grids.h"
namespace IMP {
 namespace algebra {
   %template(DenseDoubleGrid3D) DenseGrid3D<double>;
   %template(DenseFloatGrid3D) DenseGrid3D<float >;
   %template(SparseUnboundedIntGrid3D) SparseUnboundedGrid3D<int >;
   %template(SparseUnboundedIntGridKD) SparseUnboundedGridD<-1, int>;
 }
}

IMP_SWIG_ALGEBRA_TEMPLATE_D(IMP::algebra, GridIndex);
IMP_SWIG_ALGEBRA_TEMPLATE_D(IMP::algebra, ExtendedGridIndex);
IMP_SWIG_ALGEBRA_TEMPLATE_D(IMP::algebra, BoundedGridRange);
IMP_SWIG_ALGEBRA_TEMPLATE_D(IMP::algebra, UnboundedGridRange);
IMP_SWIG_ALGEBRA_TEMPLATE_D(IMP::algebra, DefaultEmbedding);
IMP_SWIG_ALGEBRA_TEMPLATE_D(IMP::algebra, LogEmbedding);

%include "IMP/algebra/SpherePatch3D.h"
%include "IMP/algebra/Cone3D.h"
%include "IMP/algebra/io.h"
%include "IMP/algebra/vector_generators.h"
%include "IMP/algebra/endian.h"
%include "IMP/algebra/Rotation2D.h"
%include "IMP/algebra/shortest_segment.h"
%include "IMP/algebra/vector_search.h"
%include "IMP/algebra/vector_metrics.h"

%include "IMP/algebra/Gaussian3D.h"

%include "IMP/algebra/internal/swig.h"


IMP_SWIG_ALGEBRA_TEMPLATE_OBJECT_D(IMP::algebra, NearestNeighbor);

%include "IMP/algebra/geometric_alignment.h"


IMP_SWIG_ALGEBRA_TEMPLATE_D(IMP::algebra, PrincipalComponentAnalysis);
IMP_SWIG_ALGEBRA_FUNCTION_D_DS(PrincipalComponentAnalysis, get_principal_components, Vector);
IMP_SWIG_ALGEBRA_FUNCTION_DS_D(Vector, get_vertices, BoundingBox);

IMP_SWIG_ALGEBRA_FUNCTION_N_DD(double, get_distance, Vector, Vector);
IMP_SWIG_ALGEBRA_FUNCTION_N_DD(double, get_distance, Sphere, Sphere);
IMP_SWIG_ALGEBRA_FUNCTION_N_DD(double, get_squared_distance, Vector, Vector);
IMP_SWIG_ALGEBRA_FUNCTION_TEMPLATE_D(get_basis_vector);
IMP_SWIG_ALGEBRA_FUNCTION_TEMPLATE_D(get_zero_vector);
IMP_SWIG_ALGEBRA_FUNCTION_TEMPLATE_D(get_ones_vector);
IMP_SWIG_ALGEBRA_FUNCTION_TEMPLATE_D(get_unit_bounding_box);
IMP_SWIG_ALGEBRA_FUNCTION_TEMPLATE_D(get_cube);
IMP_SWIG_ALGEBRA_FUNCTION_TEMPLATE_D(get_unit_sphere);
IMP_SWIG_ALGEBRA_FUNCTION_N_DD(bool, get_interiors_intersect, Sphere, Sphere);
IMP_SWIG_ALGEBRA_FUNCTION_N_DD(bool, get_interiors_intersect, BoundingBox, BoundingBox);
IMP_SWIG_ALGEBRA_FUNCTION_D_D(Vector, get_random_vector_on, Sphere);
IMP_SWIG_ALGEBRA_FUNCTION_D_D(Vector, get_random_vector_on, BoundingBox);
IMP_SWIG_ALGEBRA_FUNCTION_D_D(Vector, get_random_vector_in, Sphere);
IMP_SWIG_ALGEBRA_FUNCTION_D_D(Vector, get_random_vector_in, BoundingBox);
IMP_SWIG_ALGEBRA_FUNCTION_D_DD(BoundingBox, get_intersection, BoundingBox, BoundingBox);
IMP_SWIG_ALGEBRA_FUNCTION_D_DD(BoundingBox, get_union, BoundingBox, BoundingBox);
IMP_SWIG_ALGEBRA_FUNCTION_D_D(BoundingBox, get_bounding_box, Sphere);
IMP_SWIG_ALGEBRA_FUNCTION_DS_DN(Vector, get_uniform_surface_cover, Sphere, unsigned int);
IMP_SWIG_ALGEBRA_FUNCTION_DS_DN(Vector, get_grid_interior_cover_by_spacing, BoundingBox, double);

namespace IMP {
 namespace algebra {
   %template(_AxisAnglePair) ::std::pair<IMP::algebra::VectorD<3>,double>;

   %template(get_transformation_aligning_first_to_second) get_transformation_aligning_first_to_second<IMP::Vector<IMP::algebra::VectorD<3> >, IMP::Vector<IMP::algebra::VectorD<3> > >;
   // rotation operations
 }
}

%inline %{
double get_rmsd_transforming_first(IMP::algebra::Transformation3D tr,
                                   const IMP::algebra::Vector3Ds &v0,
                                   const IMP::algebra::Vector3Ds &v1) {
  return IMP::algebra::get_rmsd_transforming_first(tr, v0, v1);
}
double get_rmsd(const IMP::algebra::Vector3Ds &v0,
                                   const IMP::algebra::Vector3Ds &v1) {
  return IMP::algebra::get_rmsd(v0, v1);
}
double get_weighted_rmsd_transforming_first(IMP::algebra::Transformation3D tr,
                                   const IMP::algebra::Vector3Ds &v0,
                                   const IMP::algebra::Vector3Ds &v1,
                                   const IMP::Floats &weights) {
  return IMP::algebra::get_weighted_rmsd_transforming_first(tr, v0, v1, weights);
}
double get_weighted_rmsd(const IMP::algebra::Vector3Ds &v0,
                                   const IMP::algebra::Vector3Ds &v1,
                                   const IMP::Floats &weights) {
  return IMP::algebra::get_weighted_rmsd(v0, v1, weights);
}
%}

%pythoncode %{
  LinearFit=LinearFit2D
  ParabolicFit=ParabolicFit2D
%}
