/**
 *  \file IMP/base/nullptr_macros.h
 *  \brief Provide a nullptr keyword analog.
 *
 *  Copyright 2007-2014 IMP Inventors. All rights reserved.
 */

#ifndef IMPBASE_NULLPTR_MACROS_H
#define IMPBASE_NULLPTR_MACROS_H

#include <IMP/base/base_config.h>

#if(defined(BOOST_NO_CXX11_NULLPTR) || defined(BOOST_NO_NULLPTR)) && \
    !defined(nullptr)
#define IMP_NULLPTR IMP::nullptr
#define IMP_NULLPTR_T IMP::nullptr_t
#else
#define IMP_NULLPTR nullptr
#define IMP_NULLPTR_T std::nullptr_t
#endif  // IMP_COMPILER_HAS_NULLPTR

#endif /* IMPBASE_NULLPTR_MACROS_H */
