% Make a DBN for the meta-model with the following variables
%
% Time-dependent variables
%
% Coupling variables
% Gex.C, Gcell.C, Scell.C
%
% Observed variables
%
% Time-invariant variables
%
% Parameters
%
% To generate a conditional gaussian model

function [meta_dbn, nodes_map]=make_meta_dbn6(DGd_mean_postprandial, DGd_cov_postprandial, Gb_mean_postprandial,...
                                              Gb_cov_postprandial, G_mean_postprandial, G_cov_postprandial,...
                                              DG_mean_postprandial, DG_cov_postprandial, Y_mean_postprandial,...
                                              Y_cov_postprandial, S_mean_postprandial, S_cov_postprandial,...
                                              I_mean_postprandial, I_cov_postprandial, Sb_mean_postprandial,...
                                              Sb_cov_postprandial, alpha_postprandial, beta_postprandial,...
                                              gamma_postprandial, k1_postprandial,k2_postprandial,...
                                              k3_postprandial, k4_postprandial, K_postprandial,...
                                              dt_postprandial, cov_scale_postprandial,...
                                              Scell_mean_pancreas, Scell_cov_pancreas, Sislet_mean_pancreas, ...
                                              Sislet_cov_pancreas, Spancreas_mean_pancreas, Spancreas_cov_pancreas, ...
                                              cov_scale_pancreas, Nc_pancreas, Ni_pancreas,...
                                              G_mean_exocytosis, kt_mean_exocytosis, Npatch_mean_exocytosis,...
                                              Nvesicle_mean_exocytosis, Ninsulin_mean_exocytosis, Rcell_mean_exocytosis,...
                                              Dvesicle_mean_exocytosis, S_mean_exocytosis, G_cov_exocytosis,...
                                              kt_cov_exocytosis, Npatch_cov_exocytosis, Nvesicle_cov_exocytosis, ...
                                              Ninsulin_cov_exocytosis, Rcell_cov_exocytosis,Dvesicle_cov_exocytosis, ...
                                              S_cov_exocytosis,...
                                              cov_scale_exocytosis,...
                                              kG_exocytosis, alpha_exocytosis, ...
                                              kp_exocytosis,beta_exocytosis, kinsulin_exocytosis, ...
                                              kD_exocytosis, kR_exocytosis,...
                                              G_mean_signaling, ATP_mean_signaling, GLP1_mean_signaling,...
                                              GLP1R_mean_signaling, cAMP_mean_signaling, Ca_mean_signaling,...
                                              S_mean_signaling, ...
                                              G_cov_signaling, ATP_cov_signaling, GLP1_cov_signaling, ...
                                              GLP1R_cov_signaling, cAMP_cov_signaling, Ca_cov_signaling, ...
                                              S_cov_signaling, cov_scale_signaling,...
                                              alpha_signaling, kATP_signaling, kGLP1_signaling,...
                                              beta_signaling, gamma_signaling, kcAMP_signaling,...
                                              delta_signaling, kCa_signaling, epsilon_signaling,...
                                              A_mean_screening, A_cov_screening, conc_mean_screening,...
                                              conc_conv_screening, GLP1R_mean_screening, GLP1R_cov_screening,...
                                              cov_scale_screening, k1_screening, k2_screening,...
                                              Gex_mean_metabolism, Gex_cov_metabolism, Ex4_mean_metabolism, ...
                                              Ex4_cov_metabolism, Pathway_mean_metabolism, Pathway_cov_metabolism, ATP_mean_metabolism, ...
                                              ATP_cov_metabolism, cov_scale_metabolism,...
                                              k1_metabolism, k2_metabolism, ...
                                              k3_metabolism);

    % make DBNs for all input models
    [postprandial_dbn_factory]= make_postprandial_dbn(DGd_mean_postprandial, DGd_cov_postprandial, Gb_mean_postprandial,...
                                              Gb_cov_postprandial, G_mean_postprandial, G_cov_postprandial,...
                                              DG_mean_postprandial, DG_cov_postprandial, Y_mean_postprandial,...
                                              Y_cov_postprandial, S_mean_postprandial, S_cov_postprandial,...
                                              I_mean_postprandial, I_cov_postprandial, Sb_mean_postprandial,...
                                              Sb_cov_postprandial, alpha_postprandial, beta_postprandial,...
                                              gamma_postprandial, k1_postprandial,k2_postprandial,...
                                              k3_postprandial, k4_postprandial, K_postprandial,...
                                              dt_postprandial, cov_scale_postprandial);
    [pancreas_dbn_factory]= make_pancreas_dbn(Scell_mean_pancreas, Scell_cov_pancreas, Sislet_mean_pancreas, ...
                                              Sislet_cov_pancreas, Spancreas_mean_pancreas, Spancreas_cov_pancreas, ...
                                              cov_scale_pancreas, Nc_pancreas, Ni_pancreas);
    [exocytosis_dbn_factory]= make_exocytosis_dbn(G_mean_exocytosis, kt_mean_exocytosis, Npatch_mean_exocytosis,...
                                                  Nvesicle_mean_exocytosis, Ninsulin_mean_exocytosis, Rcell_mean_exocytosis,...
                                                  Dvesicle_mean_exocytosis, S_mean_exocytosis, G_cov_exocytosis,...
                                                  kt_cov_exocytosis, Npatch_cov_exocytosis, Nvesicle_cov_exocytosis, ...
                                                  Ninsulin_cov_exocytosis, Rcell_cov_exocytosis,Dvesicle_cov_exocytosis, ...
                                                  S_cov_exocytosis,...
                                                  cov_scale_exocytosis,...
                                                  kG_exocytosis, alpha_exocytosis, ...
                                                  kp_exocytosis,beta_exocytosis, kinsulin_exocytosis, ...
                                                  kD_exocytosis, kR_exocytosis);
    [signaling_dbn_factory]= make_signaling_dbn(G_mean_signaling, ATP_mean_signaling, GLP1_mean_signaling,...
                                                GLP1R_mean_signaling, cAMP_mean_signaling, Ca_mean_signaling,...
                                                S_mean_signaling, ...
                                                G_cov_signaling, ATP_cov_signaling, GLP1_cov_signaling, ...
                                                GLP1R_cov_signaling, cAMP_cov_signaling, Ca_cov_signaling, ...
                                                S_cov_signaling, cov_scale_signaling,...
                                                alpha_signaling, kATP_signaling, kGLP1_signaling,...
                                                beta_signaling, gamma_signaling, kcAMP_signaling,...
                                                delta_signaling, kCa_signaling, epsilon_signaling);
    [screening_dbn_factory]= make_screening_dbn(A_mean_screening, A_cov_screening, conc_mean_screening,...
                                        conc_conv_screening, GLP1R_mean_screening, GLP1R_cov_screening,...
                                        cov_scale_screening, k1_screening, k2_screening);
    [metabolism_dbn_factory]= make_metabolism_dbn(Gex_mean_metabolism, Gex_cov_metabolism, Ex4_mean_metabolism, ...
                                                  Ex4_cov_metabolism, Pathway_mean_metabolism, Pathway_cov_metabolism, ATP_mean_metabolism, ...
                                                  ATP_cov_metabolism, cov_scale_metabolism,...
                                                  k1_metabolism, k2_metabolism, ...
                                                  k3_metabolism);
    
    % make DBNs to generate meta- DBN
    meta_dbn_factory= ...
        merge_dbn_factories(postprandial_dbn_factory, pancreas_dbn_factory, ...
                            exocytosis_dbn_factory, signaling_dbn_factory, screening_dbn_factory, metabolism_dbn_factory);
                     
    % re-define CPDs of connected variables
    weights_Scell0_map_T0= containers.Map(); % parents in slice t
    weights_Scell0_map_T1= containers.Map(); % parents in slice t+1
    weights_Scell0_map_T0('S.exocytosis')= 1/2;
    weights_Scell0_map_T0('S.signaling')= 1/2;
    CPDFactory_Scell0 = ...
        CPDFactory('Gaussian_CPD', 'Scell.C', 0, {'mean', 0.0, 'cov', S_cov_exocytosis*cov_scale_exocytosis}, ...
        weights_Scell0_map_T0, weights_Scell0_map_T1); % Scell.C = 1/2*S.SPT + 1/2*S.Network
    
    weights_Gin0_map_T0= containers.Map(); 
    weights_Gin0_map_T1= containers.Map();
    weights_Gin0_map_T0('G.C')= 0.5;
    CPDFactory_Gin0 = ...
        CPDFactory('Gaussian_CPD', 'Gcell.C', 0, {'mean', 0.0, 'cov', G_cov_exocytosis*cov_scale_exocytosis}, ...
        weights_Gin0_map_T0, weights_Gin0_map_T1); % Gcell.C = 0.5 * Gex.C
    
    weights_S0_map_T0= containers.Map();
    weights_S0_map_T1= containers.Map(); 
    weights_S0_map_T0('DGd.postprandial')= 0.0;
    weights_S0_map_T0('Sb.postprandial')= 1/3;
    weights_S0_map_T0('Spa.C')= 2/3;
    weights_S0_map_T0('Y.postprandial')= 0.0;
    CPDFactory_S0 =  ...
        CPDFactory('Gaussian_CPD', 'S.postprandial', 0, {'mean', 0.0, 'cov', Sb_cov_postprandial*cov_scale_postprandial}, ...
        weights_S0_map_T0, weights_S0_map_T1); % S.postprandial = 2/3 * Scell.C
    
    weights_S1_map_T0= containers.Map(); 
    weights_S1_map_T1= containers.Map();
    weights_S1_map_T1('DGd.postprandial')= K_postprandial/3;
    weights_S1_map_T1('Sb.postprandial')= 1/3;
    weights_S1_map_T1('Spa.C')= 2.0/3;
    weights_S1_map_T1('Y.postprandial')= 1.0/3;
    weights_S1_map_T0('S.postprandial')= 0.0;
    CPDFactory_S1=  ...
        CPDFactory('Gaussian_CPD', 'S.postprandial', 1, ...
        {'mean', 0.0, 'cov', Sb_cov_postprandial*cov_scale_postprandial}, ...
        weights_S1_map_T0, weights_S1_map_T1); % S(t+1) = 0.0 * S(t) + K_mean_postprandial/3 * DGex(t+1) + 2/3 * Scell.C(t+1) + 1/3 * Y(t+1)
    
    weights_GLP1R0_T0= containers.Map();
    weights_GLP1R0_T1= containers.Map();
    weights_GLP1R0_T0('GLP1.signaling')= 0.0;
    weights_GLP1R0_T0('GLP1R.C')= 1.0;
    CPDFactory_GLP1R0=  ...
        CPDFactory('Gaussian_CPD', 'GLP1R.signaling', 0, ...
        {'mean', GLP1R_mean_signaling, 'cov', GLP1R_cov_signaling*cov_scale_signaling}, weights_GLP1R0_T0, weights_GLP1R0_T1);  % GLP1R = 0.5 * GLP1R.C
    
    weights_GLP1R1_T0= containers.Map();
    weights_GLP1R1_T1= containers.Map();
    weights_GLP1R1_T0('GLP1.signaling')= kGLP1_signaling;
    weights_GLP1R1_T0('GLP1R.signaling')= 0.0;
    weights_GLP1R1_T1('GLP1R.C')= 1.0;
    CPDFactory_GLP1R1=  ...
        CPDFactory('Gaussian_CPD', 'GLP1R.signaling', 1, ...
        {'mean', 0.0, 'cov', GLP1R_cov_signaling*cov_scale_signaling}, weights_GLP1R1_T0, weights_GLP1R1_T1); % GLP1R(t+1) = 0.0 * GLP1R(t) + 0.5 * GLP1R.C(t) + 0.5/GLP1_Network * GLP1(t)
    
    weights_ATP1_T0= containers.Map();
    weights_ATP1_T1= containers.Map(); 
    weights_ATP1_T0('G.signaling')= 0.9*alpha_signaling;
    weights_ATP1_T0('ATP.signaling')= 0.9*kATP_signaling;
    weights_ATP1_T1('ATP.C')= 0.11;
    CPDFactory_ATP=  ...
        CPDFactory('Gaussian_CPD', 'ATP.signaling', 1, ...
        {'mean', 0.0, 'cov', ATP_cov_signaling*cov_scale_signaling}, weights_ATP1_T0, weights_ATP1_T1);  % ATP(t+1) = ATP_w_ATP_signaling * ATP(t) + Gcell_w_ATP_signaling * Gcell (t) + 0.5 * ATP.C
    
    add_CPD_factories(meta_dbn_factory, {CPDFactory_Scell0, CPDFactory_Gin0, CPDFactory_S0,...
                        CPDFactory_S1, CPDFactory_GLP1R0, CPDFactory_GLP1R1, CPDFactory_ATP}, false);

    [meta_dbn, ~, ~, nodes_map] = create_dbn(meta_dbn_factory);
    
end
