#!/usr/bin/env python

import pickle

di = {'ALA': {'HB': ('HB1', 'HB2', 'HB3'),
              'HB%': ('HB1', 'HB2', 'HB3'),
              'QB': ('HB1', 'HB2', 'HB3')},
      'ARG': {'HB': ('HB1', 'HB2'),
              'HB%': ('HB1', 'HB2'),
              'HD': ('HD1', 'HD2'),
              'HD%': ('HD1', 'HD2'),
              'HG': ('HG1', 'HG2'),
              'HG%': ('HG1', 'HG2'),
              'HH1': ('HH11', 'HH12'),
              'HH1%': ('HH11', 'HH12'),
              'HH2': ('HH21', 'HH22'),
              'HH2%': ('HH21', 'HH22'),
              'QB': ('HB1', 'HB2'),
              'QD': ('HD1', 'HD2'),
              'QG': ('HG1', 'HG2'),
              'QH1': ('HH11', 'HH12'),
              'QH2': ('HH21', 'HH22')},
      'ASN': {'HB': ('HB1', 'HB2'),
              'HB%': ('HB1', 'HB2'),
              'HD': ('HD21', 'HD22'),
              'HD%': ('HD21', 'HD22'),
              'HD2': ('HD21', 'HD22'),
              'HD2%': ('HD21', 'HD22'),
              'QB': ('HB1', 'HB2'),
              'QD': ('HD21', 'HD22'),
              'QD2': ('HD21', 'HD22')},
      'ASP':
      {'HB': ('HB1', 'HB2'), 'HB%': ('HB1', 'HB2'), 'QB': ('HB1', 'HB2')},
      'CYS':
      {'HB': ('HB1', 'HB2'), 'HB%': ('HB1', 'HB2'), 'QB': ('HB1', 'HB2')},
      'GLN': {'HB': ('HB1', 'HB2'),
              'HB%': ('HB1', 'HB2'),
              'HE': ('HE21', 'HE22'),
              'HE%': ('HE21', 'HE22'),
              'HE2': ('HE21', 'HE22'),
              'HE2%': ('HE21', 'HE22'),
              'HG': ('HG1', 'HG2'),
              'HG%': ('HG1', 'HG2'),
              'QB': ('HB1', 'HB2'),
              'QE': ('HE21', 'HE22'),
              'QE2': ('HE21', 'HE22'),
              'QG': ('HG1', 'HG2')},
      'GLU': {'HB': ('HB1', 'HB2'),
              'HB%': ('HB1', 'HB2'),
              'HG': ('HG1', 'HG2'),
              'HG%': ('HG1', 'HG2'),
              'QB': ('HB1', 'HB2'),
              'QG': ('HG1', 'HG2')},
      'GLY':
      {'HA': ('HA1', 'HA2'), 'HA%': ('HA1', 'HA2'), 'QA': ('HA1', 'HA2')},
      'HIS':
      {'HB': ('HB1', 'HB2'), 'HB%': ('HB1', 'HB2'), 'QB': ('HB1', 'HB2')},
      'HSD':
      {'HB': ('HB1', 'HB2'), 'HB%': ('HB1', 'HB2'), 'QB': ('HB1', 'HB2')},
      'HSE':
      {'HB': ('HB1', 'HB2'), 'HB%': ('HB1', 'HB2'), 'QB': ('HB1', 'HB2')},
      'HSP':
      {'HB': ('HB1', 'HB2'), 'HB%': ('HB1', 'HB2'), 'QB': ('HB1', 'HB2')},
      'ILE': {'HD': ('HD1', 'HD2', 'HD3'),
              'HD%': ('HD1', 'HD2', 'HD3'),
              'HD1': ('HD1', 'HD2', 'HD3'),
              'HD1%': ('HD1', 'HD2', 'HD3'),
              'HG': ('HG11', 'HG12', 'HG21', 'HG22', 'HG23'),
              'HG%': ('HG11', 'HG12', 'HG21', 'HG22', 'HG23'),
              'HG1': ('HG11', 'HG12'),
              'HG1%': ('HG11', 'HG12'),
              'HG2': ('HG21', 'HG22', 'HG23'),
              'HG2%': ('HG21', 'HG22', 'HG23'),
              'QD': ('HD1', 'HD2', 'HD3'),
              'QD1': ('HD1', 'HD2', 'HD3'),
              'QG1': ('HG11', 'HG12'),
              'QG2': ('HG21', 'HG22', 'HG23'),
              'QQG': ('HG11', 'HG12', 'HG21', 'HG22', 'HG23')},
      'LEU': {'HB': ('HB1', 'HB2'),
              'HB%': ('HB1', 'HB2'),
              'HD': ('HD11', 'HD12', 'HD13', 'HD21', 'HD22', 'HD23'),
              'HD%': ('HD11', 'HD12', 'HD13', 'HD21', 'HD22', 'HD23'),
              'HD1': ('HD11', 'HD12', 'HD13'),
              'HD1%': ('HD11', 'HD12', 'HD13'),
              'HD2': ('HD21', 'HD22', 'HD23'),
              'HD2%': ('HD21', 'HD22', 'HD23'),
              'QB': ('HB1', 'HB2'),
              'QD': ('HD11', 'HD12', 'HD13', 'HD21', 'HD22', 'HD23'),
              'QD1': ('HD11', 'HD12', 'HD13'),
              'QD2': ('HD21', 'HD22', 'HD23'),
              'QQD': ('HD11', 'HD12', 'HD13', 'HD21', 'HD22', 'HD23')},
      'LYS': {'HB': ('HB1', 'HB2'),
              'HB%': ('HB1', 'HB2'),
              'HD': ('HD1', 'HD2'),
              'HD%': ('HD1', 'HD2'),
              'HE': ('HE1', 'HE2'),
              'HE%': ('HE1', 'HE2'),
              'HG': ('HG1', 'HG2'),
              'HG%': ('HG1', 'HG2'),
              'HZ': ('HZ1', 'HZ2', 'HZ3'),
              'HZ%': ('HZ1', 'HZ2', 'HZ3'),
              'QB': ('HB1', 'HB2'),
              'QD': ('HD1', 'HD2'),
              'QE': ('HE1', 'HE2'),
              'QG': ('HG1', 'HG2'),
              'QZ': ('HZ1', 'HZ2', 'HZ3')},
      'MET': {'HB': ('HB1', 'HB2'),
              'HB%': ('HB1', 'HB2'),
              'HE': ('HE1', 'HE2', 'HE3'),
              'HE%': ('HE1', 'HE2', 'HE3'),
              'HG': ('HG1', 'HG2'),
              'HG%': ('HG1', 'HG2'),
              'QB': ('HB1', 'HB2'),
              'QE': ('HE1', 'HE2', 'HE3'),
              'QG': ('HG1', 'HG2')},
      'PHE': {'HB': ('HB1', 'HB2'),
              'HB%': ('HB1', 'HB2'),
              'HD': ('HD1', 'HD2'),
              'HD%': ('HD1', 'HD2'),
              'HE': ('HE1', 'HE2'),
              'HE%': ('HE1', 'HE2'),
              'HR': ('HD1', 'HD2', 'HE1', 'HE2', 'HZ'),
              'HR%': ('HD1', 'HD2', 'HE1', 'HE2', 'HZ'),
              'QB': ('HB1', 'HB2'),
              'QD': ('HD1', 'HD2'),
              'QE': ('HE1', 'HE2'),
              'QR': ('HD1', 'HD2', 'HE1', 'HE2', 'HZ')},
      'PRO': {'HB': ('HB1', 'HB2'),
              'HB%': ('HB1', 'HB2'),
              'HD': ('HD1', 'HD2'),
              'HD%': ('HD1', 'HD2'),
              'HG': ('HG1', 'HG2'),
              'HG%': ('HG1', 'HG2'),
              'QB': ('HB1', 'HB2'),
              'QD': ('HD1', 'HD2'),
              'QG': ('HG1', 'HG2')},
      'SER':
      {'HB': ('HB1', 'HB2'), 'HB%': ('HB1', 'HB2'), 'QB': ('HB1', 'HB2')},
      'THR': {'HB': ('HB',),
              'HB%': ('HB',),
              'HG2': ('HG21', 'HG22', 'HG23'),
              'HG2%': ('HG21', 'HG22', 'HG23'),
              'QB': ('HB',),
              'QG2': ('HG21', 'HG22', 'HG23')},
      'TRP': {'HB': ('HB1', 'HB2'),
              'HB%': ('HB1', 'HB2'),
              'QB': ('HB1', 'HB2')},
      'TYR': {'HB': ('HB1', 'HB2'),
              'HB%': ('HB1', 'HB2'),
              'HD': ('HD1', 'HD2'),
              'HD%': ('HD1', 'HD2'),
              'HE': ('HE1', 'HE2'),
              'HE%': ('HE1', 'HE2'),
              'HR': ('HD1', 'HD2', 'HE1', 'HE2'),
              'HR%': ('HD1', 'HD2', 'HE1', 'HE2'),
              'QB': ('HB1', 'HB2'),
              'QD': ('HD1', 'HD2'),
              'QE': ('HE1', 'HE2'),
              'QR': ('HD1', 'HD2', 'HE1', 'HE2')},
      'VAL': {'HG': ('HG11', 'HG12', 'HG13', 'HG21', 'HG22', 'HG23'),
              'HG%': ('HG11', 'HG12', 'HG13', 'HG21', 'HG22', 'HG23'),
              'HG1': ('HG11', 'HG12', 'HG13'),
              'HG1%': ('HG11', 'HG12', 'HG13'),
              'HG2': ('HG21', 'HG22', 'HG23'),
              'HG2%': ('HG21', 'HG22', 'HG23'),
              'QG': ('HG11', 'HG12', 'HG13', 'HG21', 'HG22', 'HG23'),
              'QG1': ('HG11', 'HG12', 'HG13'),
              'QG2': ('HG21', 'HG22', 'HG23'),
              'QQG': ('HG11', 'HG12', 'HG13', 'HG21', 'HG22', 'HG23')}}
with open('CHARMM_pseudoatoms.dict', 'wb') as fl:
    pickle.dump(di, fl)
