/**
 *  \file CloseBipartitePairContainer.h
 *  \brief Return all pairs from a SingletonContainer
 *
 *  This file is generated by a script (core/tools/make-container).
 *  Do not edit directly.
 *
 *  Copyright 2007-2014 IMP Inventors. Close rights reserved.
 */

#ifndef IMPCORE_INTERNAL_CORE_CLOSE_BIPARTITE_PAIR_CONTAINER_H
#define IMPCORE_INTERNAL_CORE_CLOSE_BIPARTITE_PAIR_CONTAINER_H

#include <IMP/core/core_config.h>
#include "../ClosePairsFinder.h"
#include "MovedSingletonContainer.h"
#include <IMP/kernel/PairContainer.h>
#include <IMP/kernel/PairPredicate.h>
#include <IMP/kernel/SingletonContainer.h>
#include <IMP/kernel/internal/ContainerScoreState.h>
#include <IMP/kernel/internal/ListLikeContainer.h>
#include <boost/unordered_map.hpp>

IMPCORE_BEGIN_INTERNAL_NAMESPACE

/** \brief Return all close unordered pairs of particles taken from
    the SingletonContainer

    See ClosePairContainer for a more detailed description. This
    container lists all close pairs of particles where one particle is
    taken from each of the input sets.

    \note Any passed ClosePairsFinder is ignored.

    \usesconstraint
 */
class IMPCOREEXPORT CoreCloseBipartitePairContainer
    : public IMP::kernel::internal::ListLikeContainer<kernel::PairContainer> {
  typedef IMP::kernel::internal::ListLikeContainer<kernel::PairContainer> P;
  IMP::base::PointerMember<SingletonContainer> sc_[2];
  bool were_close_, reset_;
  ObjectKey key_;
  // moved stuff
  kernel::ParticleIndexes rbs_[2];
  kernel::ParticleIndexes xyzrs_[2];
  boost::unordered_map<kernel::ParticleIndex, kernel::ParticleIndexes>
      constituents_;
  double slack_, distance_;
  algebra::Sphere3Ds rbs_backup_sphere_[2];
  algebra::Rotation3Ds rbs_backup_rot_[2];
  algebra::Sphere3Ds xyzrs_backup_[2];
  ParticleIndex covers_[2];
  typedef kernel::internal::ContainerScoreState<CoreCloseBipartitePairContainer>
      SS;
  base::PointerMember<SS> score_state_;
  void initialize(SingletonContainer *a, SingletonContainer *b,
                  kernel::ParticleIndex cover_a, kernel::ParticleIndex cover_b,
                  double distance, double slack, ObjectKey key);

 public:
  kernel::ModelObjectsTemp get_score_state_inputs() const;
  //! Get the individual particles from the passed SingletonContainer
  CoreCloseBipartitePairContainer(SingletonContainer *a, SingletonContainer *b,
                                  double distance, double slack = 1,
                                  std::string name =
                                      "CoreBipartiteClosePairContainer%1%");

  //! make sure you know what you are doing
  CoreCloseBipartitePairContainer(SingletonContainer *a, SingletonContainer *b,
                                  kernel::ParticleIndex cover_a,
                                  kernel::ParticleIndex cover_b, ObjectKey key,
                                  double distance, double slack = 1,
                                  std::string name =
                                      "CoreCloseBipartitePairContainer%1%");

  /** @name Methods to control the set of filters

     PairContainer objects can be used as filters to prevent
     the addition of pairs to the containeroutput list. Pairs
     which are contained in any container added to this list
     will be excluded from the close pairs list.
  */
  /**@{*/
  IMP_LIST_ACTION(public, PairFilter, PairFilters, pair_filter, pair_filters,
                  PairPredicate *, PairPredicates,
  {
    set_has_dependencies(false);
    score_state_->set_has_dependencies(false);
    obj->set_was_used(true);
  },
  {
    score_state_->set_has_dependencies(false);
    set_has_dependencies(false);
  }, );
  /**@}*/
  void clear_caches() { reset_ = true; }
  virtual kernel::ParticleIndexes get_all_possible_indexes() const IMP_OVERRIDE;
  virtual kernel::ModelObjectsTemp do_get_inputs() const IMP_OVERRIDE;
  void do_score_state_before_evaluate();
  void do_score_state_after_evaluate() {}
  virtual kernel::ParticleIndexPairs get_range_indexes() const IMP_OVERRIDE;
  IMP_OBJECT_METHODS(CoreCloseBipartitePairContainer);
};

IMP_OBJECTS(CoreCloseBipartitePairContainer, CoreCloseBipartitePairContainers);

IMPCORE_END_INTERNAL_NAMESPACE

#endif /* IMPCORE_INTERNAL_CORE_CLOSE_BIPARTITE_PAIR_CONTAINER_H */
