# Autogenerated file, run tools/build/setup_cmake.py to regenerate

project(IMP.%(name)s)

imp_get_process_exit_code("setup_application %(name)s" status ${CMAKE_BINARY_DIR}
                          COMMAND ${CMAKE_SOURCE_DIR}/tools/build/setup_application.py
                          --name=%(name)s
                          --datapath=${IMP_DATAPATH}
                           --source=${CMAKE_SOURCE_DIR})
if(${status} EQUAL 0)
include_directories(%(includepath)s)
link_directories(%(libpath)s)
add_definitions("-DIMP_EXECUTABLE")

%(bins)s

set(pybins %(pybins)s)
foreach (pybin ${pybins})
  install(PROGRAMS ${pybin} DESTINATION ${CMAKE_INSTALL_BINDIR})
endforeach(pybin)

math(EXPR expensive_timeout "${IMP_TIMEOUT_FACTOR} * 120")

set(pytests %(pytests)s)
foreach (test ${pytests})
  GET_FILENAME_COMPONENT(name ${test} NAME)
  add_test("IMP.%(name)s-${name}" ${IMP_TEST_SETUP} python ${test})
  set_tests_properties("IMP.%(name)s-${name}" PROPERTIES LABELS "IMP.%(name)s-test-python")
  set_tests_properties("IMP.%(name)s-${name}" PROPERTIES TIMEOUT ${expensive_timeout})
  set_tests_properties("IMP.%(name)s-${name}" PROPERTIES COST 3)
endforeach(test)

if(IMP_DOXYGEN_FOUND)
# documentation

file(GLOB docs ${CMAKE_SOURCE_DIR}/applications/%(name)s/*.dox
               ${CMAKE_SOURCE_DIR}/applications/%(name)s/*.md)

add_custom_command(OUTPUT ${CMAKE_BINARY_DIR}/doxygen/%(name)s/tags ${CMAKE_BINARY_DIR}/doc/html/%(name)s/index.html
   COMMAND mkdir -p doc/html
   COMMAND ${IMP_DOXYGEN_EXECUTABLE} ../../doxygen/%(name)s/Doxyfile
   COMMAND ${CMAKE_SOURCE_DIR}/tools/build/doxygen_patch_tags.py --module=%(name)s --file=../../doxygen/%(name)s/tags
   COMMAND ${CMAKE_SOURCE_DIR}/tools/build/doxygen_show_warnings.py --warn=../../doxygen/%(name)s/warnings.txt
   DEPENDS %(tags)s ${docs}
   WORKING_DIRECTORY ${CMAKE_BINARY_DIR}/doxygen/%(name)s/
   COMMENT "Running doxygen on %(name)s")

add_custom_target("IMP.%(name)s-doc" ALL DEPENDS ${CMAKE_BINARY_DIR}/doxygen/%(name)s/tags)
set_property(TARGET "IMP.%(name)s-doc" PROPERTY FOLDER "IMP.%(name)s")

set(IMP_%(name)s_DOC "IMP.%(name)s-doc" CACHE INTERNAL "" FORCE)

set(IMP_DOC_DEPENDS ${IMP_DOC_DEPENDS} ${IMP_%(name)s_DOC} CACHE INTERNAL "" FORCE)
endif(IMP_DOXYGEN_FOUND)

add_custom_target(IMP.%(name)s DEPENDS
  %(module_deps)s
  ${bins})
set_property(TARGET "IMP.%(name)s" PROPERTY FOLDER "IMP.%(name)s")

elseif(${status} EQUAL 1)
message("Application %(name)s disabled")
else()
message(FATAL_ERROR "setup_application failed ${status}")
endif()
