add_definitions(-DIMP_SWIG_WRAPPER)
add_definitions(-DRMF_SWIG_WRAPPER)

# Suppress modern gcc warnings about a lot of autogenerated SWIG code
# Note that some warnings can be turned off with pragmas
# (see modules/kernel/pyext/include/IMP_kernel.compiler_warnings.i)
# but pragmas seem to be ignored for these particular warnings:
if ("${CMAKE_CXX_COMPILER_ID}" MATCHES "GNU")
  add_definitions("-Wno-unused-function")
  add_definitions("-Wno-unused-parameter")
  add_definitions("-Wno-missing-field-initializers")
  if (GCC_VERSION VERSION_GREATER 4.3)
    add_definitions("-Wno-maybe-uninitialized")
    add_definitions("-Wno-missing-declarations")
  endif()
  if (GCC_VERSION VERSION_GREATER 8.0)
    add_definitions("-Wno-stringop-overflow")
  endif()
endif()

include_directories(%(python_includepath)s)
link_directories(%(libpath)s)

GET_DIRECTORY_PROPERTY(includes INCLUDE_DIRECTORIES)

# SWIG doesn't need Python.h in its own include path
include_directories(${PYTHON_INCLUDE_DIRS})

# this is needed for some reason that I don't understand
set(swig_path %(swigpath)s)
list(APPEND swig_path ${IMP_SWIG_PATH})

file(STRINGS "${CMAKE_BINARY_DIR}/src/%(name)s_swig.deps" swigdeps)

set(wrap_py "${CMAKE_BINARY_DIR}/lib/%(subdir)s/__init__.py")
set(wrap_py_orig "${CMAKE_BINARY_DIR}/src/%(name)s_swig/%(pymod)s.py")
set(source "${CMAKE_BINARY_DIR}/src/%(name)s_swig/wrap.cpp"
                          "${CMAKE_BINARY_DIR}/src/%(name)s_swig/wrap.h")

set(PATH_ARGS )
foreach(path ${includes})
  list(APPEND PATH_ARGS "--includepath=${path}")
endforeach(path)
foreach(path ${swig_path})
  list(APPEND PATH_ARGS "--swigpath=${path}")
endforeach(path)
add_custom_command(OUTPUT ${source} ${wrap_py} ${wrap_py_orig}
   COMMAND  ${PYTHON_EXECUTABLE}
            "%(tools_dir)sbuild/make_swig_wrapper.py"%(extra_include)s%(extra_swig)s
            "--swig=${SWIG_EXECUTABLE}"
            "--module=%(name)s"
            ${PATH_ARGS}
   DEPENDS ${swigdeps} ${IMP_%(name)s_PYTHON_EXTRA_DEPENDENCIES}
   WORKING_DIRECTORY ${CMAKE_BINARY_DIR}
   COMMENT "Running SWIG on %(name)s")

add_library(IMP.%(name)s-python MODULE ${source})
# Apple linkers complain by default if there are undefined symbols
if(APPLE)
  set_target_properties(IMP.%(name)s-python PROPERTIES LINK_FLAGS "-undefined dynamic_lookup")
endif(APPLE)

set_target_properties(IMP.%(name)s-python PROPERTIES PREFIX ""
                      OUTPUT_NAME _IMP_%(name)s)
set_property(TARGET "IMP.%(name)s-python" PROPERTY FOLDER "IMP.%(name)s")


if(WIN32 AND NOT CYGWIN)
  set_target_properties(IMP.%(name)s-python PROPERTIES SUFFIX ".pyd")
endif()

target_link_libraries(IMP.%(name)s-python
    IMP.%(name)s-lib
    ${imp_%(name)s_libs}
    ${IMP_SWIG_LIBRARIES}
  )

set(IMP_%(name)s_PYTHON ${source} IMP.%(name)s-python ${wrap_py} %(other_pythons)s
                   CACHE INTERNAL "" FORCE)

INSTALL(TARGETS IMP.%(name)s-python DESTINATION ${CMAKE_INSTALL_PYTHONDIR})
INSTALL(FILES ${wrap_py} DESTINATION ${CMAKE_INSTALL_PYTHONDIR}/%(subdir)s)
