/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef avro_parsing_ValidatingCodec_hh__
#define avro_parsing_ValidatingCodec_hh__

#include <map>
#include <vector>
#include "boost/make_shared.hpp"

#include "Symbol.hh"
#include "ValidSchema.hh"
#include "NodeImpl.hh"

namespace internal_avro {
namespace parsing {

class ValidatingGrammarGenerator {
 protected:
  template <typename T>
  static void doFixup(Production& p,
                      const std::map<T, boost::shared_ptr<Production> >& m);

  template <typename T>
  static void doFixup(Symbol& s,
                      const std::map<T, boost::shared_ptr<Production> >& m);
  virtual Production doGenerate(
      const NodePtr& n, std::map<NodePtr, boost::shared_ptr<Production> >& m);

  Production generate(const NodePtr& schema);

 public:
  Symbol generate(const ValidSchema& schema);
};

}  // namespace parsing
}  // namespace internal_avro

#endif
