/**
 *  \file LoopStatistical.cpp
 *  \brief Fiser/Melo loop modeling statistical potential
 *
 *  Copyright 2007-2020 IMP Inventors. All rights reserved.
 *
 */

#include <IMP/score_functor/LoopStatistical.h>

IMPSCOREFUNCTOR_BEGIN_NAMESPACE

namespace {

namespace data {

#define LOOP_TYPE(NameKey) \
  const LoopStatisticalType Loop##NameKey( \
                  LoopStatisticalType::add_key(#NameKey));
#define LOOP_TYPE_ALIAS(Name, Key) \
  const LoopStatisticalType Loop##Name( \
            LoopStatisticalType::add_alias(LoopStatisticalType(#Key), #Name));

LOOP_TYPE(A001)
LOOP_TYPE_ALIAS(ALA_CA, A001)
LOOP_TYPE_ALIAS(ARG_CA, A001)
LOOP_TYPE_ALIAS(ASN_CA, A001)
LOOP_TYPE_ALIAS(ASP_CA, A001)
LOOP_TYPE_ALIAS(CYS_CA, A001)
LOOP_TYPE_ALIAS(CSS_CA, A001)
LOOP_TYPE_ALIAS(GLU_CA, A001)
LOOP_TYPE_ALIAS(GLN_CA, A001)
LOOP_TYPE_ALIAS(HIS_CA, A001)
LOOP_TYPE_ALIAS(HSD_CA, A001)
LOOP_TYPE_ALIAS(ILE_CA, A001)
LOOP_TYPE_ALIAS(LEU_CA, A001)
LOOP_TYPE_ALIAS(LYS_CA, A001)
LOOP_TYPE_ALIAS(MET_CA, A001)
LOOP_TYPE_ALIAS(PHE_CA, A001)
LOOP_TYPE_ALIAS(PRO_CA, A001)
LOOP_TYPE_ALIAS(SER_CA, A001)
LOOP_TYPE_ALIAS(THR_CA, A001)
LOOP_TYPE_ALIAS(TRP_CA, A001)
LOOP_TYPE_ALIAS(TYR_CA, A001)
LOOP_TYPE_ALIAS(VAL_CA, A001)
LOOP_TYPE(A002)
LOOP_TYPE_ALIAS(GLY_CA, A002)
LOOP_TYPE(A003)
LOOP_TYPE_ALIAS(ALA_N, A003)
LOOP_TYPE_ALIAS(ARG_N, A003)
LOOP_TYPE_ALIAS(ASN_N, A003)
LOOP_TYPE_ALIAS(ASP_N, A003)
LOOP_TYPE_ALIAS(CYS_N, A003)
LOOP_TYPE_ALIAS(CSS_N, A003)
LOOP_TYPE_ALIAS(GLU_N, A003)
LOOP_TYPE_ALIAS(GLN_N, A003)
LOOP_TYPE_ALIAS(GLY_N, A003)
LOOP_TYPE_ALIAS(HIS_N, A003)
LOOP_TYPE_ALIAS(HSD_N, A003)
LOOP_TYPE_ALIAS(ILE_N, A003)
LOOP_TYPE_ALIAS(LEU_N, A003)
LOOP_TYPE_ALIAS(LYS_N, A003)
LOOP_TYPE_ALIAS(MET_N, A003)
LOOP_TYPE_ALIAS(PHE_N, A003)
LOOP_TYPE_ALIAS(SER_N, A003)
LOOP_TYPE_ALIAS(THR_N, A003)
LOOP_TYPE_ALIAS(TRP_N, A003)
LOOP_TYPE_ALIAS(TYR_N, A003)
LOOP_TYPE_ALIAS(VAL_N, A003)
LOOP_TYPE(A004)
LOOP_TYPE_ALIAS(ALA_C, A004)
LOOP_TYPE_ALIAS(ARG_C, A004)
LOOP_TYPE_ALIAS(ASN_C, A004)
LOOP_TYPE_ALIAS(ASP_C, A004)
LOOP_TYPE_ALIAS(CYS_C, A004)
LOOP_TYPE_ALIAS(CSS_C, A004)
LOOP_TYPE_ALIAS(GLU_C, A004)
LOOP_TYPE_ALIAS(GLN_C, A004)
LOOP_TYPE_ALIAS(GLY_C, A004)
LOOP_TYPE_ALIAS(HIS_C, A004)
LOOP_TYPE_ALIAS(HSD_C, A004)
LOOP_TYPE_ALIAS(ILE_C, A004)
LOOP_TYPE_ALIAS(LEU_C, A004)
LOOP_TYPE_ALIAS(LYS_C, A004)
LOOP_TYPE_ALIAS(MET_C, A004)
LOOP_TYPE_ALIAS(PHE_C, A004)
LOOP_TYPE_ALIAS(PRO_C, A004)
LOOP_TYPE_ALIAS(SER_C, A004)
LOOP_TYPE_ALIAS(THR_C, A004)
LOOP_TYPE_ALIAS(TRP_C, A004)
LOOP_TYPE_ALIAS(TYR_C, A004)
LOOP_TYPE_ALIAS(VAL_C, A004)
LOOP_TYPE(A005)
LOOP_TYPE_ALIAS(ALA_O, A005)
LOOP_TYPE_ALIAS(ARG_O, A005)
LOOP_TYPE_ALIAS(ASN_O, A005)
LOOP_TYPE_ALIAS(ASP_O, A005)
LOOP_TYPE_ALIAS(CYS_O, A005)
LOOP_TYPE_ALIAS(CSS_O, A005)
LOOP_TYPE_ALIAS(GLU_O, A005)
LOOP_TYPE_ALIAS(GLN_O, A005)
LOOP_TYPE_ALIAS(GLY_O, A005)
LOOP_TYPE_ALIAS(HIS_O, A005)
LOOP_TYPE_ALIAS(HSD_O, A005)
LOOP_TYPE_ALIAS(ILE_O, A005)
LOOP_TYPE_ALIAS(LEU_O, A005)
LOOP_TYPE_ALIAS(LYS_O, A005)
LOOP_TYPE_ALIAS(MET_O, A005)
LOOP_TYPE_ALIAS(PHE_O, A005)
LOOP_TYPE_ALIAS(PRO_O, A005)
LOOP_TYPE_ALIAS(SER_O, A005)
LOOP_TYPE_ALIAS(THR_O, A005)
LOOP_TYPE_ALIAS(TRP_O, A005)
LOOP_TYPE_ALIAS(TYR_O, A005)
LOOP_TYPE_ALIAS(VAL_O, A005)
LOOP_TYPE(A006)
LOOP_TYPE_ALIAS(ALA_CB, A006)
LOOP_TYPE_ALIAS(ILE_CG2, A006)
LOOP_TYPE_ALIAS(ILE_CD1, A006)
LOOP_TYPE_ALIAS(ILE_CD, A006)
LOOP_TYPE_ALIAS(LEU_CD1, A006)
LOOP_TYPE_ALIAS(LEU_CD2, A006)
LOOP_TYPE_ALIAS(THR_CG2, A006)
LOOP_TYPE_ALIAS(VAL_CG1, A006)
LOOP_TYPE_ALIAS(VAL_CG2, A006)
LOOP_TYPE(A007)
LOOP_TYPE_ALIAS(ILE_CB, A007)
LOOP_TYPE_ALIAS(LEU_CG, A007)
LOOP_TYPE_ALIAS(VAL_CB, A007)
LOOP_TYPE(A008)
LOOP_TYPE_ALIAS(ARG_CB, A008)
LOOP_TYPE_ALIAS(ARG_CG, A008)
LOOP_TYPE_ALIAS(ASN_CB, A008)
LOOP_TYPE_ALIAS(ASP_CB, A008)
LOOP_TYPE_ALIAS(GLU_CB, A008)
LOOP_TYPE_ALIAS(GLU_CG, A008)
LOOP_TYPE_ALIAS(ILE_CG1, A008)
LOOP_TYPE_ALIAS(GLN_CB, A008)
LOOP_TYPE_ALIAS(GLN_CG, A008)
LOOP_TYPE_ALIAS(HIS_CB, A008)
LOOP_TYPE_ALIAS(HSD_CB, A008)
LOOP_TYPE_ALIAS(LEU_CB, A008)
LOOP_TYPE_ALIAS(LYS_CB, A008)
LOOP_TYPE_ALIAS(LYS_CG, A008)
LOOP_TYPE_ALIAS(LYS_CD, A008)
LOOP_TYPE_ALIAS(MET_CB, A008)
LOOP_TYPE_ALIAS(PHE_CB, A008)
LOOP_TYPE_ALIAS(PRO_CB, A008)
LOOP_TYPE_ALIAS(PRO_CG, A008)
LOOP_TYPE_ALIAS(TRP_CB, A008)
LOOP_TYPE_ALIAS(TYR_CB, A008)
LOOP_TYPE(A009)
LOOP_TYPE_ALIAS(MET_SD, A009)
LOOP_TYPE(A010)
LOOP_TYPE_ALIAS(PRO_N, A010)
LOOP_TYPE(A011)
LOOP_TYPE_ALIAS(PHE_CG, A011)
LOOP_TYPE_ALIAS(TRP_CD2, A011)
LOOP_TYPE_ALIAS(TYR_CG, A011)
LOOP_TYPE(A012)
LOOP_TYPE_ALIAS(PHE_CD1, A012)
LOOP_TYPE_ALIAS(PHE_CD2, A012)
LOOP_TYPE_ALIAS(PHE_CE1, A012)
LOOP_TYPE_ALIAS(PHE_CE2, A012)
LOOP_TYPE_ALIAS(PHE_CZ, A012)
LOOP_TYPE_ALIAS(TRP_CE3, A012)
LOOP_TYPE_ALIAS(TRP_CZ2, A012)
LOOP_TYPE_ALIAS(TRP_CZ3, A012)
LOOP_TYPE_ALIAS(TRP_CH2, A012)
LOOP_TYPE_ALIAS(TYR_CD1, A012)
LOOP_TYPE_ALIAS(TYR_CD2, A012)
LOOP_TYPE_ALIAS(TYR_CE1, A012)
LOOP_TYPE_ALIAS(TYR_CE2, A012)
LOOP_TYPE(A013)
LOOP_TYPE_ALIAS(TRP_CG, A013)
LOOP_TYPE(A014)
LOOP_TYPE_ALIAS(TRP_CE2, A014)
LOOP_TYPE(A015)
LOOP_TYPE_ALIAS(SER_CB, A015)
LOOP_TYPE(A016)
LOOP_TYPE_ALIAS(SER_OG, A016)
LOOP_TYPE_ALIAS(THR_OG1, A016)
LOOP_TYPE(A017)
LOOP_TYPE_ALIAS(THR_CB, A017)
LOOP_TYPE(A018)
LOOP_TYPE_ALIAS(ASN_ND2, A018)
LOOP_TYPE_ALIAS(GLN_NE2, A018)
LOOP_TYPE(A019)
LOOP_TYPE_ALIAS(CYS_SG, A019)
LOOP_TYPE_ALIAS(CSS_SG, A019)
LOOP_TYPE(A020)
LOOP_TYPE_ALIAS(LYS_NZ, A020)
LOOP_TYPE(A021)
LOOP_TYPE_ALIAS(ARG_CZ, A021)
LOOP_TYPE(A022)
LOOP_TYPE_ALIAS(ARG_NH1, A022)
LOOP_TYPE_ALIAS(ARG_NH2, A022)
LOOP_TYPE(A023)
LOOP_TYPE_ALIAS(HIS_CG, A023)
LOOP_TYPE_ALIAS(HSD_CG, A023)
LOOP_TYPE(A024)
LOOP_TYPE_ALIAS(HIS_CD2, A024)
LOOP_TYPE_ALIAS(HSD_CD2, A024)
LOOP_TYPE_ALIAS(TRP_CD1, A024)
LOOP_TYPE(A025)
LOOP_TYPE_ALIAS(HIS_NE2, A025)
LOOP_TYPE_ALIAS(HSD_NE2, A025)
LOOP_TYPE(A026)
LOOP_TYPE_ALIAS(HIS_CE1, A026)
LOOP_TYPE_ALIAS(HSD_CE1, A026)
LOOP_TYPE(A027)
LOOP_TYPE_ALIAS(ASP_CG, A027)
LOOP_TYPE_ALIAS(GLU_CD, A027)
LOOP_TYPE(A028)
LOOP_TYPE_ALIAS(ALA_OXT, A028)
LOOP_TYPE_ALIAS(ARG_OXT, A028)
LOOP_TYPE_ALIAS(ASN_OXT, A028)
LOOP_TYPE_ALIAS(ASP_OXT, A028)
LOOP_TYPE_ALIAS(CYS_OXT, A028)
LOOP_TYPE_ALIAS(CSS_OXT, A028)
LOOP_TYPE_ALIAS(GLU_OXT, A028)
LOOP_TYPE_ALIAS(GLN_OXT, A028)
LOOP_TYPE_ALIAS(GLY_OXT, A028)
LOOP_TYPE_ALIAS(HIS_OXT, A028)
LOOP_TYPE_ALIAS(HSD_OXT, A028)
LOOP_TYPE_ALIAS(ILE_OXT, A028)
LOOP_TYPE_ALIAS(LEU_OXT, A028)
LOOP_TYPE_ALIAS(LYS_OXT, A028)
LOOP_TYPE_ALIAS(MET_OXT, A028)
LOOP_TYPE_ALIAS(PHE_OXT, A028)
LOOP_TYPE_ALIAS(PRO_OXT, A028)
LOOP_TYPE_ALIAS(SER_OXT, A028)
LOOP_TYPE_ALIAS(THR_OXT, A028)
LOOP_TYPE_ALIAS(TRP_OXT, A028)
LOOP_TYPE_ALIAS(TYR_OXT, A028)
LOOP_TYPE_ALIAS(VAL_OXT, A028)
LOOP_TYPE_ALIAS(ASP_OD1, A028)
LOOP_TYPE_ALIAS(ASP_OD2, A028)
LOOP_TYPE_ALIAS(ASP_OT1, A028)
LOOP_TYPE_ALIAS(ASP_OT2, A028)
LOOP_TYPE_ALIAS(GLU_OE1, A028)
LOOP_TYPE_ALIAS(GLU_OE2, A028)
LOOP_TYPE_ALIAS(GLU_OT1, A028)
LOOP_TYPE_ALIAS(GLU_OT2, A028)
LOOP_TYPE(A029)
LOOP_TYPE_ALIAS(CYS_CB, A029)
LOOP_TYPE_ALIAS(CSS_CB, A029)
LOOP_TYPE_ALIAS(MET_CG, A029)
LOOP_TYPE(A030)
LOOP_TYPE_ALIAS(MET_CE, A030)
LOOP_TYPE(A031)
LOOP_TYPE_ALIAS(TYR_CZ, A031)
LOOP_TYPE(A032)
LOOP_TYPE_ALIAS(PRO_CD, A032)
LOOP_TYPE(A033)
LOOP_TYPE_ALIAS(ASN_CG, A033)
LOOP_TYPE_ALIAS(GLN_CD, A033)
LOOP_TYPE(A034)
LOOP_TYPE_ALIAS(ASN_OD1, A034)
LOOP_TYPE_ALIAS(GLN_OE1, A034)
LOOP_TYPE(A035)
LOOP_TYPE_ALIAS(LYS_CE, A035)
LOOP_TYPE(A036)
LOOP_TYPE_ALIAS(ARG_NE, A036)
LOOP_TYPE(A037)
LOOP_TYPE_ALIAS(ARG_CD, A037)
LOOP_TYPE(A038)
LOOP_TYPE_ALIAS(HIS_ND1, A038)
LOOP_TYPE_ALIAS(HSD_ND1, A038)
LOOP_TYPE(A039)
LOOP_TYPE_ALIAS(TRP_NE1, A039)
LOOP_TYPE(A040)
LOOP_TYPE_ALIAS(TYR_OH, A040)
}
}

IMPSCOREFUNCTOR_END_NAMESPACE
