\brief Sampling exhaustiveness protocol

[![Build Status](https://travis-ci.org/salilab/imp-sampcon.svg?branch=master)](https://travis-ci.org/salilab/imp-sampcon)
[![codecov](https://codecov.io/gh/salilab/imp-sampcon/branch/master/graph/badge.svg)](https://codecov.io/gh/salilab/imp-sampcon)

This module implements the sampling exhaustiveness test described in
[Viswanath et al, 2017](https://www.ncbi.nlm.nih.gov/pubmed/29211988).
The protocol is primarily designed to work with models generated by
the [Integrative Modeling Platform (IMP)](https://integrativemodeling.org)
(and more specifically the IMP::pmi module), but could probably be adapted
for other systems.

# Dependencies:

[pyRMSD](https://github.com/salilab/pyRMSD) is needed. (This is a fork of the
original pyRMSD - which is no longer maintained - to fix bugs and add
Python 3 support.)

In the Sali lab, pyRMSD is already built, so can be used with
`module load python2/pyrmsd` or `module load python3/pyrmsd`.

# imp_sampcon: sampling exhaustiveness test {#imp_sampcon}

The protocol is typically run using the `imp_sampcon` command line tool:

 - `imp_sampcon show_stat` to show the available fields (e.g. scoring function
   terms, restraint satisfaction) in an IMP::pmi stat file.
 - `imp_sampcon select_good` to select a subset of good-scoring models from
   a set of IMP::pmi trajectories.
 - `imp_sampcon plot_score` to plot the score distributions of the selected
   models.
 - `imp_sampcon exhaust` to analyze the selected models and determine whether
   sampling was exhaustive.

For a full demonstration of the protocol, see its usage in
IMP's [actin modeling tutorial](https://integrativemodeling.org/tutorials/actin/analysis.html).
