/**
 *  \file IMP/kernel/classname_macros.h
 *  \brief Macros for various classes.
 *
 *  This file is generated by a script (core/tools/make-containers).
 *  Do not edit directly.
 *
 *  Copyright 2007-2013 IMP Inventors. All rights reserved.
 */

#ifndef IMPKERNEL_CLASSNAME_MACROS_H
#define IMPKERNEL_CLASSNAME_MACROS_H

#include "internal/TupleRestraint.h"
#include "internal/functors.h"
#include "container_macros.h"
#include <IMP/base/object_macros.h>
#include "input_output_macros.h"
#include <algorithm>


/** \deprecated_at{2.1} Declare methods youself and use
    IMP_CLASSNAME_SCORE_METHODS() to fill in the rest.
*/
#define IMP_CLASSNAME_SCORE(Name)                                      \
  IMPKERNEL_DEPRECATED_MACRO(2.1, "Declare methods yourself and use "   \
                             "IMP_CLASSNAME_SCORE_METHODS() to fill in the rest."); \
  IMP_IMPLEMENT(double evaluate(ARGUMENTTYPE p,\
                                DerivativeAccumulator *da) const);      \
  IMP_IMPLEMENT_INLINE(double evaluate_index(kernel::Model *m,                  \
                                PASSINDEXTYPE p,           \
                                     DerivativeAccumulator *da) const, { \
       return evaluate(IMP::kernel::internal::get_particle(m,p), da); \
                                    });                                 \
  IMP_IMPLEMENT_INLINE(double evaluate_if_good_index(kernel::Model *m,          \
                          PASSINDEXTYPE p,                       \
                          DerivativeAccumulator *da,                    \
                                                     double max) const, { \
    IMP_UNUSED(max);                                                    \
    return evaluate_index(m, p, da);                                    \
                       });                                              \
  IMP_BACKWARDS_MACRO_INPUTS;                                           \
  IMP_OBJECT_NO_WARNING(Name)

/** \deprecated_at{2.1} Declare methods youself and use
    IMP_CLASSNAME_SCORE_METHODS() to fill in the rest.
*/
#define IMP_SIMPLE_CLASSNAME_SCORE(Name)                               \
  IMPKERNEL_DEPRECATED_MACRO(2.1, "Declare methods yourself and use "   \
                             "IMP_CLASSNAME_SCORE_METHODS() to fill in the rest."); \
 IMP_IMPLEMENT(double evaluate(ARGUMENTTYPE p,    \
                                DerivativeAccumulator *da) const);      \
  IMP_IMPLEMENT_INLINE(kernel::ModelObjectsTemp                                 \
                       do_get_inputs(kernel::Model *m,                          \
                                     const ParticleIndexes &pis) const, { \
                         kernel::ModelObjectsTemp ret;                          \
                         ret+=IMP::kernel::get_particles(m, pis);       \
                         return ret;                                    \
                       });                                              \
  IMP_IMPLEMENT_INLINE(Restraints do_create_current_decomposition          \
                       (kernel::Model *m,                                       \
                        PASSINDEXTYPE vt) const, {           \
                         return  IMP::kernel::internal            \
                           ::create_score_current_decomposition(this, m, vt); \
                       });                                        \
  IMP_OBJECT_NO_WARNING(Name)



/** \deprecated_at{2.1} Do it yourself.
*/
#define IMP_COMPOSITE_CLASSNAME_SCORE(Name)                            \
  IMPKERNEL_DEPRECATED_MACRO(2.1, "Do it yourself.");                  \
  IMP_IMPLEMENT_INLINE(double evaluate(ARGUMENTTYPE p,     \
                                       DerivativeAccumulator *da) const, { \
              return evaluate_index(IMP::kernel::internal::get_model(p), \
                               IMP::kernel::internal::get_index(p), da); \
                       });                                              \
  IMP_IMPLEMENT(double evaluate_index(kernel::Model *m, PASSINDEXTYPE p,\
                                      DerivativeAccumulator *da) const); \
  IMP_IMPLEMENT(double evaluate_if_good_index(kernel::Model *m,                 \
                          PASSINDEXTYPE p,                       \
                          DerivativeAccumulator *da,                    \
                                              double max) const);       \
  IMP_IMPLEMENT_INLINE(double evaluate_indexes(kernel::Model *m,                \
                                        const PLURALINDEXTYPE &p,       \
                                        DerivativeAccumulator *da,      \
                                        unsigned int lower_bound,       \
                                               unsigned int upper_bound) const,\
  {                                                                     \
    double ret=0;                                                       \
    for (unsigned int i=lower_bound; i < upper_bound; ++i) {            \
      ret+= evaluate_index(m, p[i], da);                                \
    }                                                                   \
    return ret;                                                         \
  });                                                                   \
  IMP_IMPLEMENT_INLINE(double                                           \
                       evaluate_if_good_indexes(kernel::Model *m,               \
                         const PLURALINDEXTYPE &p,                      \
                         DerivativeAccumulator *da,                     \
                         double max,                                    \
                         unsigned int lower_bound,                      \
                         unsigned int upper_bound) const, {             \
    double ret=0;                                                       \
    for (unsigned int i=lower_bound; i < upper_bound; ++i) {            \
      ret+= evaluate_if_good_index(m, p[i], da, max-ret);               \
      if (ret>max) return std::numeric_limits<double>::max();           \
    }                                                                   \
    return ret;                                                         \
                       });                                              \
  IMP_IMPLEMENT(kernel::ModelObjectsTemp                                        \
  do_get_inputs(kernel::Model *m,                                               \
                const ParticleIndexes &pis) const );        \
   IMP_OBJECT_NO_WARNING(Name)

/** Define
    - IMP::kernel::ClassnameScore::evaluate_indexes()
    - IMP::kernel::ClassnameScore::evaluate_if_good_indexes()
 */
#define IMP_CLASSNAME_SCORE_METHODS(Name) \
  double evaluate_indexes(kernel::Model *m,                                     \
                          const PLURALINDEXTYPE &p,                     \
                          DerivativeAccumulator *da,                    \
                          unsigned int lower_bound,                     \
                          unsigned int upper_bound) const IMP_FINAL {   \
    double ret=0;                                                       \
    for (unsigned int i=lower_bound; i < upper_bound; ++i) {            \
      ret+= evaluate_index(m, p[i], da);                                \
    }                                                                   \
    return ret;                                                         \
  }                                                                     \
  double evaluate_if_good_indexes(kernel::Model *m,                             \
                                  const PLURALINDEXTYPE &p,             \
                                  DerivativeAccumulator *da,            \
                                  double max,                           \
                                  unsigned int lower_bound,             \
                                  unsigned int upper_bound) const {     \
    double ret=0;                                                       \
    for (unsigned int i=lower_bound; i < upper_bound; ++i) {            \
      ret+= evaluate_if_good_index(m, p[i], da, max-ret);               \
      if (ret>max) return std::numeric_limits<double>::max();           \
    }                                                                   \
    return ret;                                                         \
  }                                                                     \


/** \deprecated_at{2.1} Declare methods youself and use
    IMP_CLASSNAME_SCORE_METHODS() to fill in the rest.
*/
#define IMP_INDEX_CLASSNAME_SCORE(Name)                                 \
  IMPKERNEL_DEPRECATED_MACRO(2.1, "Declare methods yourself and use "\
                             "IMP_CLASSNAME_SCORE_METHODS() to fill in the rest."); \
  double evaluate(ARGUMENTTYPE p, DerivativeAccumulator *da) const {    \
    return evaluate_index(IMP::kernel::internal::get_model(p),          \
                          IMP::kernel::internal::get_index(p),          \
                          da);                                          \
  }                                                                     \
  double evaluate_index(kernel::Model *m, PASSINDEXTYPE p,                      \
                        DerivativeAccumulator *da) const IMP_FINAL;     \
  double evaluate_if_good_index(kernel::Model *m, PASSINDEXTYPE p,              \
                                DerivativeAccumulator *da,              \
                                double max) const {                     \
    IMP_UNUSED(max);                                                    \
    return evaluate_index(m, p, da);                                    \
  }                                                                     \
  double evaluate_indexes(kernel::Model *m,                                     \
                          const PLURALINDEXTYPE &p,                     \
                          DerivativeAccumulator *da,                    \
                          unsigned int lower_bound,                     \
                          unsigned int upper_bound) const IMP_FINAL {   \
    double ret=0;                                                       \
    for (unsigned int i=lower_bound; i < upper_bound; ++i) {            \
      ret+= evaluate_index(m, p[i], da);                                \
    }                                                                   \
    return ret;                                                         \
  }                                                                     \
  double evaluate_if_good_indexes(kernel::Model *m,                             \
                                  const PLURALINDEXTYPE &p,             \
                                  DerivativeAccumulator *da,            \
                                  double max,                           \
                                  unsigned int lower_bound,             \
                                  unsigned int upper_bound) const {     \
    double ret=0;                                                       \
    for (unsigned int i=lower_bound; i < upper_bound; ++i) {            \
      ret+= evaluate_if_good_index(m, p[i], da, max-ret);               \
      if (ret>max) return std::numeric_limits<double>::max();           \
    }                                                                   \
    return ret;                                                         \
  }                                                                     \
  kernel::ModelObjectsTemp do_get_inputs(kernel::Model *m,                              \
                                 const ParticleIndexes &pis) const;     \
  IMP_OBJECT_METHODS(Name)



/** \deprecated_at{2.1} Use IMP_CLASSNAME_PREDICATE_METHODS instead and declare
    the methods you implement.
 */
#define IMP_CLASSNAME_PREDICATE(Name)                                   \
  IMPKERNEL_DEPRECATED_MACRO(2.1, "Use IMP_CLASSNAME_PREDICATE_METHODS"\
                             " and declare the methods you implement."); \
  IMP_IMPLEMENT(int get_value(ARGUMENTTYPE a) const);   \
  IMP_IMPLEMENT_INLINE(Ints get_value(const                             \
                              PLURALVARIABLETYPE &o) const, {   \
    Ints ret(o.size());                                                 \
    for (unsigned int i=0; i< o.size(); ++i) {                          \
      ret[i]+= Name::get_value(o[i]);                                   \
    }                                                                   \
    return ret;                                                         \
    });                                                                 \
  IMP_IMPLEMENT_INLINE(int get_value_index(kernel::Model *m,                    \
                                           PASSINDEXTYPE vt)\
                       const, {                                         \
        return Name::get_value(IMP::kernel::internal::get_particle(m, vt)); \
                       });                                              \
  IMP_IMPLEMENT_INLINE(Ints get_value_index(kernel::Model *m,                   \
                                     const PLURALINDEXTYPE &o) const, { \
   Ints ret(o.size());                                                  \
   for (unsigned int i=0; i< o.size(); ++i) {                           \
     ret[i]+= Name::get_value_index(m, o[i]);                           \
   }                                                                    \
   return ret;                                                          \
                       });                                              \
  IMP_BACKWARDS_MACRO_INPUTS;                                           \
  IMP_OBJECT_NO_WARNING(Name)


//! Define extra the functions needed for a ClassnamePredicate
#define IMP_CLASSNAME_PREDICATE_METHODS(Name)                           \
  int get_value(ARGUMENTTYPE a) const {                                 \
    return get_value_index(IMP::kernel::internal::get_model(a),         \
                           IMP::kernel::internal::get_index(a));        \
  }                                                                     \
  Ints get_value(const PLURALVARIABLETYPE &o) const {                   \
    Ints ret(o.size());                                                 \
    for (unsigned int i=0; i< o.size(); ++i) {                          \
      ret[i]+= Name::get_value(o[i]);                                   \
    }                                                                   \
    return ret;                                                         \
  }                                                                     \
  Ints get_value_index(kernel::Model *m, const PLURALINDEXTYPE &o) const {      \
    Ints ret(o.size());                                                 \
    for (unsigned int i=0; i< o.size(); ++i) {                          \
      ret[i]+= Name::get_value_index(m, o[i]);                          \
    }                                                                   \
    return ret;                                                         \
  }                                                                     \
  IMP_IMPLEMENT_INLINE_NO_SWIG(void remove_if_equal(kernel::Model *m,           \
                                            PLURALINDEXTYPE& ps,        \
                                            int value) const, {         \
      ps.erase(std::remove_if(ps.begin(), ps.end(),                     \
               IMP::kernel::internal::PredicateEquals<Name, true>(this, \
                                                            m, value)), \
               ps.end());                                               \
                       });                                              \
  IMP_IMPLEMENT_INLINE_NO_SWIG(void remove_if_not_equal(kernel::Model *m,       \
                                            PLURALINDEXTYPE& ps,        \
                                            int value) const, {         \
      ps.erase(std::remove_if(ps.begin(), ps.end(),                     \
              IMP::kernel::internal::PredicateEquals<Name, false>(this, \
                                                            m, value)), \
               ps.end());                                               \
                       });

/** \deprecated_at{2.1} Declare methods yourself and use
    IMP_CLASSNAME_PREDICATE_METHODS to fill in the rest.
*/
#define IMP_INDEX_CLASSNAME_PREDICATE(Name, return_value, return_inputs) \
  IMPKERNEL_DEPRECATED_MACRO(2.1, "Declare the methods yourself and use" \
                 " IMP_CLASSNAME_PREDICATE_METHODS to fill in the rest."); \
  int get_value(ARGUMENTTYPE a) const {                                 \
    return get_value_index(IMP::kernel::internal::get_model(a),         \
                           IMP::kernel::internal::get_index(a));        \
  }                                                                     \
  Ints get_value(const PLURALVARIABLETYPE &o) const {                   \
    Ints ret(o.size());                                                 \
    for (unsigned int i=0; i< o.size(); ++i) {                          \
      ret[i]+= Name::get_value(o[i]);                                   \
    }                                                                   \
    return ret;                                                         \
  }                                                                     \
  int get_value_index(kernel::Model *m, PASSINDEXTYPE pi) const {               \
    return_value;                                                       \
  }                                                                     \
  Ints get_value_index(kernel::Model *m, const PLURALINDEXTYPE &o) const {      \
    Ints ret(o.size());                                                 \
    for (unsigned int i=0; i< o.size(); ++i) {                          \
      ret[i]+= Name::get_value_index(m, o[i]);                          \
    }                                                                   \
    return ret;                                                         \
  }                                                                     \
  IMP_IMPLEMENT_INLINE_NO_SWIG(void remove_if_equal(kernel::Model *m,           \
                                            PLURALINDEXTYPE& ps,        \
                                            int value) const, {         \
      ps.erase(std::remove_if(ps.begin(), ps.end(),                     \
               IMP::kernel::internal::PredicateEquals<Name, true>(this, \
                                                            m, value)), \
               ps.end());                                               \
                       });                                              \
  IMP_IMPLEMENT_INLINE_NO_SWIG(void remove_if_not_equal(kernel::Model *m,       \
                                            PLURALINDEXTYPE& ps,        \
                                            int value) const, {         \
      ps.erase(std::remove_if(ps.begin(), ps.end(),                     \
              IMP::kernel::internal::PredicateEquals<Name, false>(this, \
                                                            m, value)), \
               ps.end());                                               \
                       });                                              \
  kernel::ModelObjectsTemp do_get_inputs(kernel::Model *m,                              \
                                 const ParticleIndexes &pi) const {     \
    return_inputs;                                                      \
  }                                                                     \
  IMP_OBJECT_METHODS(Name)


/** \deprecated_at{2.1} Declare methods yourself and use IMP_CLASSNAME_MODIFIER_METHODS
    to fill in the rest.
*/
#define IMP_CLASSNAME_MODIFIER(Name)                                    \
  IMPKERNEL_DEPRECATED_MACRO(2.1, "Declare methods yourself and"        \
                             " use IMP_CLASSNAME_MODIFIER_METHODS to fill in the rest"); \
  IMP_IMPLEMENT(void apply(ARGUMENTTYPE a) const);                      \
  IMP_IMPLEMENT_INLINE(void apply_index(kernel::Model *m,                       \
                                        PASSINDEXTYPE a) const, {       \
                         return Name::apply(IMP::kernel::internal::get_particle(m,a)); \
                       })                                               \
  IMP_BACKWARDS_MACRO_INPUTS;                                           \
  IMP_BACKWARDS_MACRO_OUTPUTS;                                          \
  IMP_OBJECT_NO_WARNING(Name)

//! Use IMP_CLASSNAME_MODIFIER() instead
#define IMP_CLASSNAME_DERIVATIVE_MODIFIER(Name)                        \
  IMP_CLASSNAME_MODIFIER(Name)


/** Define
    - IMP::kernel::ClassnameModifier::apply_indexes()
*/
#define IMP_CLASSNAME_MODIFIER_METHODS(Name)                            \
  virtual void apply_indexes(kernel::Model *m, const PLURALINDEXTYPE &o,        \
                     unsigned int lower_bound,                          \
                     unsigned int upper_bound) const IMP_FINAL  {       \
    for (unsigned int i=lower_bound; i < upper_bound; ++i) {            \
      apply_index(m, o[i]);                                             \
    }                                                                   \
  }                                                                     \



/** \deprecated_at{2.1} Declare methods yourself and use IMP_CLASSNAME_MODIFIER_METHODS
    to fill in the rest.
*/
#define IMP_INDEX_CLASSNAME_MODIFIER(Name)                            \
  IMPKERNEL_DEPRECATED_MACRO(2.1, "Declare methods yourself and"        \
                             " use IMP_CLASSNAME_MODIFIER_METHODS to fill in the rest"); \
  void apply(ARGUMENTTYPE a) const {                                  \
    apply_index(IMP::kernel::internal::get_model(a),                  \
                IMP::kernel::internal::get_index(a));                   \
  }                                                                     \
  void apply_index(kernel::Model *m, PASSINDEXTYPE a) const IMP_FINAL;          \
  void apply_indexes(kernel::Model *m, const PLURALINDEXTYPE &o,                \
                     unsigned int lower_bound,                          \
                     unsigned int upper_bound) const IMP_FINAL  {       \
    for (unsigned int i=lower_bound; i < upper_bound; ++i) {            \
      apply_index(m, o[i]);                                             \
    }                                                                   \
  }                                                                     \
  kernel::ModelObjectsTemp do_get_inputs(kernel::Model *m,  const ParticleIndexes &pis) const; \
  kernel::ModelObjectsTemp do_get_outputs(kernel::Model *m,                             \
                                  const ParticleIndexes &pis) const;   \
  IMP_OBJECT_METHODS(Name)

//! Use IMP_INDEX_CLASSNAME_MODIFIER instead
#define IMP_INDEX_CLASSNAME_DERIVATIVE_MODIFIER(Name)  \
  IMP_INDEX_CLASSNAME_MODIFIER(Name)




#ifndef IMP_DOXYGEN
#define IMP_IMPLEMENT_CLASSNAME_CONTAINER(Name)                        \
  IMP_IMPLEMENT_INLINE(void do_apply(const ClassnameModifier *sm) const, {\
    apply_generic(sm);                                                  \
  });                                                                   \
  virtual ParticleIndexes get_all_possible_indexes() const IMP_OVERRIDE; \
  IMP_OBJECT_NO_WARNING(Name)
#endif


/** Use this to fill in container methods
    IMP::kernel::ClassnameContainer::do_apply()
*/
#define IMP_CLASSNAME_CONTAINER_METHODS(Name)                          \
  void do_apply(const ClassnameModifier *sm) const {                   \
    apply_generic(sm);                                                 \
  }


/** \deprecated_at{2.1} Declare the methods directly and use
    IMP_CLASSNAME_CONTAINER_METHODS
*/
#define IMP_CLASSNAME_CONTAINER(Name)                                  \
  IMPKERNEL_DEPRECATED_MACRO(2.1, "Declare the methods yourself and use "\
                             "IMP_CLASSNAME_CONTAINER_METHODS");        \
  IMP_IMPLEMENT(PLURALINDEXTYPE get_indexes() const);                   \
  IMP_IMPLEMENT(PLURALINDEXTYPE get_range_indexes() const);      \
  IMP_IMPLEMENT(void do_before_evaluate());                             \
  IMP_IMPLEMENT(ParticlesTemp get_input_particles() const);             \
  IMP_IMPLEMENT(ContainersTemp get_input_containers() const);           \
  IMP_IMPLEMENT_INLINE(kernel::ModelObjectsTemp do_get_inputs() const, {        \
    kernel::ModelObjects ret;                                                   \
    ret+=get_input_containers();                                        \
    ret+=get_input_particles();                                         \
    return ret;                                                         \
  });                                                                   \
  IMP_IMPLEMENT_CLASSNAME_CONTAINER(Name)


/** \deprecated_at{2.1} Declare the methods directly and use
    IMP_CLASSNAME_CONTAINER_METHODS
*/
#define IMP_ACTIVE_CLASSNAME_CONTAINER(Name)                           \
  IMP_CLASSNAME_CONTAINER(name)

/** Use IMP_CONTAINER_FOREACH() instead.
*/
#define IMP_FOREACH_CLASSNAME(sequence, operation) do {                 \
    IMPKERNEL_DEPRECATED_MACRO(2.1, "Use IMP_CONTAINER_FOREACH instead"); \
    IMP::kernel::PLURALVARIABLETYPE imp_all=sequence->get();            \
    for (unsigned int _2=0;                                             \
       _2 != imp_all.size();                                            \
         ++_2) {                                                        \
      IMP::kernel::VARIABLETYPE _1= imp_all[_2];                        \
      bool imp_foreach_break=false;                                     \
      operation                                                         \
        if (imp_foreach_break) break;                                   \
    }                                                                   \
  } while (false)



/** Use IMP_CONTAINER_FOREACH() instead.
*/
#define IMP_FOREACH_CLASSNAME_INDEX(sequence, operation)               \
  IMPKERNEL_DEPRECATED_MACRO(2.1, "Use IMP_CONTAINER_FOREACH instead"); \
  IMP_CONTAINER_FOREACH(ClassnameContainer, sequence, operation)

#endif  /* IMPKERNEL_CLASSNAME_MACROS_H */
