import IMP
import IMP.test
import IMP.restrainer

class Tests(IMP.test.TestCase):
    def setUp(self):
        IMP.base.set_log_level(IMP.base.NONE)
        IMP.test.TestCase.setUp(self)

        RepParser = IMP.restrainer.XMLRepresentation(self.get_input_file_name('pdb_representation.xml'))
        RestraintParser = IMP.restrainer.XMLRestraint(self.get_input_file_name('pdb_methods_restraint.xml'))
        self.representation = RepParser.run()
        self.restraint = RestraintParser.run()

        self.Model = self.representation.get_model()
        self.restraint.add_to_representation(self.representation)


    def test_show(self):
        """Check multiple input restraints for pdb"""

        self.Model.show()
        score = self.Model.evaluate(False)
        self.assertAlmostEqual(score, 187500., delta=10.0)

if __name__ == '__main__':
    IMP.test.main()
