# Autogenerated file, run tools/build/setup_cmake.py to regenerate

if(NOT DEFINED EIGEN3_LIBRARIES)

set(CHECK_COMPILES_BODY "")

include(LibFindMacros)

# Use pkg-config to get hints about paths
libfind_pkg_check_modules("EIGEN3_PKGCONF" "eigen3")

# Include dir
find_path("EIGEN3_INCLUDE_DIR"
  NAMES Eigen/Core
  PATHS ${EIGEN3_PKGCONF_INCLUDE_DIRS}
)

# Finally the library itself
foreach(lib )
find_library("${lib}_LIBRARY"
  NAMES ${lib}
  PATHS ${EIGEN3_PKGCONF_LIBRARY_DIRS}
)
list(APPEND EIGEN3_LIBRARY "${${lib}_LIBRARY}")
endforeach(lib)


# Set the include dir variables and the libraries and let libfind_process do the rest.
# NOTE: Singular variables for this library, plural for libraries this this lib depends on.
set(EIGEN3_PROCESS_INCLUDES EIGEN3_INCLUDE_DIR)
set(EIGEN3_PROCESS_LIBS EIGEN3_LIBRARY)

# clear target variable
set(EIGEN3_LIBRARIES "" CACHE INTERNAL "")
libfind_process(EIGEN3)

if ("${EIGEN3_LIBRARY}" MATCHES ".*NOTFOUND.*"
    OR "${EIGEN3_INCLUDE_DIR}" MATCHES ".*NOTFOUND.*")
  message("Eigen3 not found")
file(WRITE "${CMAKE_BINARY_DIR}/data/build_info/Eigen3" "ok=False")
else()
  check_compiles("_found" "Eigen3" "EIGEN3" "#include <Eigen/Core>" "${EIGEN3_INCLUDE_DIR}" "${EIGEN3_LIBRARIES}" EIGEN3_ok_ok)
  if(${EIGEN3_ok_ok} MATCHES "1")
    message(STATUS "Found Eigen3")
  else()
    message("Eigen3 not found")
file(WRITE "${CMAKE_BINARY_DIR}/data/build_info/Eigen3" "ok=False")
  endif()
endif()
else()
#message(STATUS "EIGEN3 already setup")

endif(NOT DEFINED EIGEN3_LIBRARIES)
