# Autogenerated file, run tools/build/setup_cmake.py to regenerate

if(NOT DEFINED OPENCV22_LIBRARIES)

set(CHECK_COMPILES_BODY "new cv::Mat(); BOOST_STATIC_ASSERT(CV_MAJOR_VERSION>=2 && CV_MINOR_VERSION>=1);")

include(LibFindMacros)

# Use pkg-config to get hints about paths
libfind_pkg_check_modules("OPENCV22_PKGCONF" "opencv22")

# Include dir
find_path("OPENCV22_INCLUDE_DIR"
  NAMES opencv2/core/core.hpp;opencv2/imgproc/imgproc.hpp;opencv2/highgui/highgui.hpp;opencv2/core/version.hpp;boost/static_assert.hpp
  PATHS ${OPENCV22_PKGCONF_INCLUDE_DIRS}
)

# Finally the library itself
foreach(lib opencv_core;opencv_imgproc;opencv_highgui)
find_library("${lib}_LIBRARY"
  NAMES ${lib}
  PATHS ${OPENCV22_PKGCONF_LIBRARY_DIRS}
)
list(APPEND OPENCV22_LIBRARY "${${lib}_LIBRARY}")
endforeach(lib)


# Set the include dir variables and the libraries and let libfind_process do the rest.
# NOTE: Singular variables for this library, plural for libraries this this lib depends on.
set(OPENCV22_PROCESS_INCLUDES OPENCV22_INCLUDE_DIR)
set(OPENCV22_PROCESS_LIBS OPENCV22_LIBRARY)

# clear target variable
set(OPENCV22_LIBRARIES "" CACHE INTERNAL "")
libfind_process(OPENCV22)

if ("${OPENCV22_LIBRARY}" MATCHES ".*NOTFOUND.*"
    OR "${OPENCV22_INCLUDE_DIR}" MATCHES ".*NOTFOUND.*")
  message("OpenCV22 not found")
file(WRITE "${CMAKE_BINARY_DIR}/data/build_info/OpenCV22" "ok=False")
else()
  check_compiles("_found" "OpenCV22" "OPENCV22" "#include <opencv2/core/core.hpp>
#include <opencv2/imgproc/imgproc.hpp>
#include <opencv2/highgui/highgui.hpp>
#include <opencv2/core/version.hpp>
#include <boost/static_assert.hpp>" "${OPENCV22_INCLUDE_DIR}" "${OPENCV22_LIBRARIES}" OPENCV22_ok_ok)
  if(${OPENCV22_ok_ok} MATCHES "1")
    message(STATUS "Found OpenCV22")
  else()
    message("OpenCV22 not found")
file(WRITE "${CMAKE_BINARY_DIR}/data/build_info/OpenCV22" "ok=False")
  endif()
endif()
else()
#message(STATUS "OPENCV22 already setup")

endif(NOT DEFINED OPENCV22_LIBRARIES)
