# Autogenerated file, run tools/build/setup_cmake.py to regenerate

if(NOT DEFINED EXAMPLEDEPENDENCY_LIBRARIES)

set(CHECK_COMPILES_BODY "")

include(LibFindMacros)

# Use pkg-config to get hints about paths
libfind_pkg_check_modules("EXAMPLEDEPENDENCY_PKGCONF" "exampledependency")

# Include dir
find_path("EXAMPLEDEPENDENCY_INCLUDE_DIR"
  NAMES example_dependency_header.hh
  PATHS ${EXAMPLEDEPENDENCY_PKGCONF_INCLUDE_DIRS}
)

# Finally the library itself
foreach(lib example_dependency)
find_library("${lib}_LIBRARY"
  NAMES ${lib}
  PATHS ${EXAMPLEDEPENDENCY_PKGCONF_LIBRARY_DIRS}
)
list(APPEND EXAMPLEDEPENDENCY_LIBRARY "${${lib}_LIBRARY}")
endforeach(lib)


# Set the include dir variables and the libraries and let libfind_process do the rest.
# NOTE: Singular variables for this library, plural for libraries this this lib depends on.
set(EXAMPLEDEPENDENCY_PROCESS_INCLUDES EXAMPLEDEPENDENCY_INCLUDE_DIR)
set(EXAMPLEDEPENDENCY_PROCESS_LIBS EXAMPLEDEPENDENCY_LIBRARY)

# clear target variable
set(EXAMPLEDEPENDENCY_LIBRARIES "" CACHE INTERNAL "")
libfind_process(EXAMPLEDEPENDENCY)

if ("${EXAMPLEDEPENDENCY_LIBRARY}" MATCHES ".*NOTFOUND.*"
    OR "${EXAMPLEDEPENDENCY_INCLUDE_DIR}" MATCHES ".*NOTFOUND.*")
  message("ExampleDependency not found")
file(WRITE "${CMAKE_BINARY_DIR}/data/build_info/ExampleDependency" "ok=False")
else()
  check_compiles("_found" "ExampleDependency" "EXAMPLEDEPENDENCY" "#include <example_dependency_header.hh>" "${EXAMPLEDEPENDENCY_INCLUDE_DIR}" "${EXAMPLEDEPENDENCY_LIBRARIES}" EXAMPLEDEPENDENCY_ok_ok)
  if(${EXAMPLEDEPENDENCY_ok_ok} MATCHES "1")
    message(STATUS "Found ExampleDependency")
  else()
    message("ExampleDependency not found")
file(WRITE "${CMAKE_BINARY_DIR}/data/build_info/ExampleDependency" "ok=False")
  endif()
endif()
else()
#message(STATUS "EXAMPLEDEPENDENCY already setup")

endif(NOT DEFINED EXAMPLEDEPENDENCY_LIBRARIES)
