# Autogenerated file, run tools/build/setup_cmake.py to regenerate

if(NOT DEFINED OPENCV21_LIBRARIES)

set(CHECK_COMPILES_BODY "BOOST_STATIC_ASSERT( CV_MAJOR_VERSION==2 && CV_MINOR_VERSION==1); new cv::Mat();")

include(LibFindMacros)

# Use pkg-config to get hints about paths
libfind_pkg_check_modules("OPENCV21_PKGCONF" "opencv21")

# Include dir
find_path("OPENCV21_INCLUDE_DIR"
  NAMES opencv/cv.h;opencv/cvver.h;boost/static_assert.hpp
  PATHS ${OPENCV21_PKGCONF_INCLUDE_DIRS}
)

# Finally the library itself
foreach(lib cv;cxcore;highgui)
find_library("${lib}_LIBRARY"
  NAMES ${lib}
  PATHS ${OPENCV21_PKGCONF_LIBRARY_DIRS}
)
list(APPEND OPENCV21_LIBRARY "${${lib}_LIBRARY}")
endforeach(lib)


# Set the include dir variables and the libraries and let libfind_process do the rest.
# NOTE: Singular variables for this library, plural for libraries this this lib depends on.
set(OPENCV21_PROCESS_INCLUDES OPENCV21_INCLUDE_DIR)
set(OPENCV21_PROCESS_LIBS OPENCV21_LIBRARY)

# clear target variable
set(OPENCV21_LIBRARIES "" CACHE INTERNAL "")
libfind_process(OPENCV21)

if ("${OPENCV21_LIBRARY}" MATCHES ".*NOTFOUND.*"
    OR "${OPENCV21_INCLUDE_DIR}" MATCHES ".*NOTFOUND.*")
  message("OpenCV21 not found")
file(WRITE "${CMAKE_BINARY_DIR}/data/build_info/OpenCV21" "ok=False")
else()
  check_compiles("_found" "OpenCV21" "OPENCV21" "#include <opencv/cv.h>
#include <opencv/cvver.h>
#include <boost/static_assert.hpp>" "${OPENCV21_INCLUDE_DIR}" "${OPENCV21_LIBRARIES}" OPENCV21_ok_ok)
  if(${OPENCV21_ok_ok} MATCHES "1")
    message(STATUS "Found OpenCV21")
  else()
    message("OpenCV21 not found")
file(WRITE "${CMAKE_BINARY_DIR}/data/build_info/OpenCV21" "ok=False")
  endif()
endif()
else()
#message(STATUS "OPENCV21 already setup")

endif(NOT DEFINED OPENCV21_LIBRARIES)
