# Autogenerated file, run tools/build/setup_cmake.py to regenerate

if(NOT DEFINED LIBTAU_LIBRARIES)

set(CHECK_COMPILES_BODY "")

include(LibFindMacros)

# Use pkg-config to get hints about paths
libfind_pkg_check_modules("LIBTAU_PKGCONF" "libtau")

# Include dir
find_path("LIBTAU_INCLUDE_DIR"
  NAMES libTAU/PairwiseDockingEngine.h
  PATHS ${LIBTAU_PKGCONF_INCLUDE_DIRS}
)

# Finally the library itself
foreach(lib TAU)
find_library("${lib}_LIBRARY"
  NAMES ${lib}
  PATHS ${LIBTAU_PKGCONF_LIBRARY_DIRS}
)
list(APPEND LIBTAU_LIBRARY "${${lib}_LIBRARY}")
endforeach(lib)


# Set the include dir variables and the libraries and let libfind_process do the rest.
# NOTE: Singular variables for this library, plural for libraries this this lib depends on.
set(LIBTAU_PROCESS_INCLUDES LIBTAU_INCLUDE_DIR)
set(LIBTAU_PROCESS_LIBS LIBTAU_LIBRARY)

# clear target variable
set(LIBTAU_LIBRARIES "" CACHE INTERNAL "")
libfind_process(LIBTAU)

if ("${LIBTAU_LIBRARY}" MATCHES ".*NOTFOUND.*"
    OR "${LIBTAU_INCLUDE_DIR}" MATCHES ".*NOTFOUND.*")
  message("libTau not found")
file(WRITE "${CMAKE_BINARY_DIR}/data/build_info/libTau" "ok=False")
else()
  check_compiles("_found" "libTau" "LIBTAU" "#include <libTAU/PairwiseDockingEngine.h>" "${LIBTAU_INCLUDE_DIR}" "${LIBTAU_LIBRARIES}" LIBTAU_ok_ok)
  if(${LIBTAU_ok_ok} MATCHES "1")
    message(STATUS "Found libTau")
  else()
    message("libTau not found")
file(WRITE "${CMAKE_BINARY_DIR}/data/build_info/libTau" "ok=False")
  endif()
endif()
else()
#message(STATUS "LIBTAU already setup")

endif(NOT DEFINED LIBTAU_LIBRARIES)
